/*
 * Decompiled with CFR 0.152.
 */
package minetweaker.mc1102.entity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import minetweaker.api.entity.IEntityDefinition;
import minetweaker.api.item.IItemStack;
import minetweaker.util.IntegerRange;
import net.minecraft.entity.Entity;

public class MCEntityDefinition
implements IEntityDefinition {
    private final Class<? extends Entity> entityClass;
    private final String entityName;
    private final Map<IItemStack, IntegerRange> dropsToAdd = new HashMap<IItemStack, IntegerRange>();
    private final Map<IItemStack, IntegerRange> dropsToAddPlayerOnly = new HashMap<IItemStack, IntegerRange>();
    private final List<IItemStack> dropsToRemove = new ArrayList<IItemStack>();

    public MCEntityDefinition(Class<? extends Entity> entityClass, String entityName) {
        this.entityClass = entityClass;
        this.entityName = entityName;
    }

    @Override
    public String getId() {
        return this.entityClass.getName();
    }

    @Override
    public String getName() {
        return this.entityName;
    }

    @Override
    public void addDrop(IItemStack stack, int min, int max) {
        this.dropsToAdd.put(stack, new IntegerRange(min, max));
    }

    @Override
    public void addPlayerOnlyDrop(IItemStack stack, int min, int max) {
        this.dropsToAddPlayerOnly.put(stack, new IntegerRange(min, max));
    }

    @Override
    public void removeDrop(IItemStack stack) {
        this.dropsToRemove.add(stack);
    }

    @Override
    public Map<IItemStack, IntegerRange> getDropsToAdd() {
        return this.dropsToAdd;
    }

    @Override
    public Map<IItemStack, IntegerRange> getDropsToAddPlayerOnly() {
        return this.dropsToAddPlayerOnly;
    }

    @Override
    public List<IItemStack> getDropsToRemove() {
        return this.dropsToRemove;
    }
}

