/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.render.particle;

import codechicken.lib.render.CCModel;
import codechicken.lib.render.CCOBJParser;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.RenderUtils;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Scale;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Vector3;
import com.brandon3055.brandonscore.client.particle.BCEffectHandler;
import com.brandon3055.brandonscore.client.particle.BCParticle;
import com.brandon3055.brandonscore.client.particle.IBCParticleFactory;
import com.brandon3055.brandonscore.lib.Vec3D;
import com.brandon3055.brandonscore.utils.Utils;
import com.brandon3055.draconicevolution.client.DEParticles;
import com.brandon3055.draconicevolution.client.handler.ClientEventHandler;
import com.brandon3055.draconicevolution.helpers.ResourceHelperDE;
import java.util.Map;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class ParticleChaosImplosion
extends BCParticle {
    private static CCModel model = null;
    private final Vec3D target;
    public double size = 0.0;
    public boolean isOrigin = false;
    public boolean isTracer = true;
    public boolean contract = false;
    public boolean explosion = false;

    public ParticleChaosImplosion(World worldIn, Vec3D pos, Vec3D target) {
        super(worldIn, pos, new Vec3D(0.0, 0.0, 0.0));
        this.texturesPerRow = 8.0f;
        this.target = target;
        this.field_187131_k = 0.0;
        this.field_187130_j = 0.0;
        this.field_187129_i = 0.0;
        if (model == null) {
            Map map = CCOBJParser.parseObjModels((ResourceLocation)ResourceHelperDE.getResource("models/reactor_core_model.obj"));
            model = CCModel.combine(map.values());
            model.apply((Transformation)new Scale(1.0, 0.5, 1.0));
        }
    }

    public boolean func_187111_c() {
        return true;
    }

    public void func_189213_a() {
        this.field_187123_c = this.field_187126_f;
        this.field_187124_d = this.field_187127_g;
        this.field_187125_e = this.field_187128_h;
        ++this.field_70546_d;
        if (this.isOrigin) {
            if (this.field_70546_d % 5 == 0) {
                BCEffectHandler.spawnFX((int)DEParticles.CHAOS_IMPLOSION, (World)this.field_187122_b, (Vec3D)new Vec3D(this.field_187126_f, this.field_187127_g, this.field_187128_h), (Vec3D)this.target, (double)512.0, (int[])new int[]{this.contract ? 4 : 3});
            }
            if (this.field_70546_d > 20) {
                this.func_187112_i();
            }
        } else if (this.isTracer) {
            double dist = Utils.getDistanceAtoB((Vec3D)this.target, (Vec3D)new Vec3D(this.field_187126_f, this.field_187127_g, this.field_187128_h));
            if (this.field_70546_d > 200 || dist < 0.1) {
                this.func_187112_i();
            }
            Vec3D dir = Vec3D.getDirectionVec((Vec3D)new Vec3D(this.field_187126_f, this.field_187127_g, this.field_187128_h), (Vec3D)this.target);
            double speed = 0.5;
            this.field_187129_i = dir.x * speed;
            this.field_187130_j = dir.y * speed;
            this.field_187131_k = dir.z * speed;
            this.moveEntityNoClip(this.field_187129_i, this.field_187130_j, this.field_187131_k);
        } else if (this.explosion) {
            int max = 1000;
            if (this.field_70546_d > max) {
                this.func_187112_i();
            }
            this.field_82339_as = 0.4f;
            float fadeOut = 400.0f;
            if ((float)this.field_70546_d > (float)max - fadeOut) {
                this.field_82339_as *= 1.0f - ((float)this.field_70546_d - fadeOut) / fadeOut;
            }
            this.size += 1.0;
        } else {
            if (this.size > 50.0) {
                this.func_187112_i();
            }
            this.field_82339_as = this.contract ? (float)this.size / 50.0f * 0.5f : 0.5f - (float)this.size / 50.0f * 0.5f;
            this.size += 1.0;
        }
    }

    public void func_180434_a(VertexBuffer vertexbuffer, Entity entity, float partialTicks, float rotationX, float rotationZ, float rotationYZ, float rotationXY, float rotationXZ) {
        if (this.isTracer) {
            super.func_180434_a(vertexbuffer, entity, partialTicks, rotationX, rotationZ, rotationYZ, rotationXY, rotationXZ);
            return;
        }
        CCRenderState ccrs = CCRenderState.instance();
        ccrs.draw();
        GlStateManager.func_179094_E();
        GlStateManager.func_179129_p();
        GlStateManager.func_179092_a((int)516, (float)0.0f);
        GlStateManager.func_179131_c((float)this.field_70552_h, (float)this.field_70553_i, (float)this.field_70551_j, (float)this.field_82339_as);
        GlStateManager.func_179090_x();
        GlStateManager.func_179132_a((boolean)false);
        float xx = (float)(this.field_187123_c + (this.field_187126_f - this.field_187123_c) * (double)partialTicks - field_70556_an);
        float yy = (float)(this.field_187124_d + (this.field_187127_g - this.field_187124_d) * (double)partialTicks - field_70554_ao);
        float zz = (float)(this.field_187125_e + (this.field_187128_h - this.field_187125_e) * (double)partialTicks - field_70555_ap);
        if (!this.explosion && !this.isOrigin) {
            double scale = (this.contract ? 50.0 - (this.size + (double)partialTicks) : this.size + (double)partialTicks) * 8.0;
            GlStateManager.func_179137_b((double)((double)xx + 0.5), (double)((double)yy + 0.5), (double)((double)zz + 0.5));
            ccrs.startDrawing(4, DefaultVertexFormats.field_181707_g);
            Matrix4 mat = RenderUtils.getMatrix((Vector3)new Vector3(0.0, 0.0, 0.0), (Rotation)new Rotation((double)(((float)ClientEventHandler.elapsedTicks + partialTicks) / 40.0f), 0.0, 1.0, 0.0), (double)(-1.0 * scale));
            model.render(ccrs, new IVertexOperation[]{mat});
            ccrs.draw();
        } else if (this.explosion) {
            double baseScale = this.size + (double)partialTicks;
            GlStateManager.func_179137_b((double)((double)xx + 0.5), (double)((double)yy + 0.5), (double)((double)zz + 0.5));
            ccrs.startDrawing(4, DefaultVertexFormats.field_181707_g);
            for (int i = 40; i > 0; --i) {
                double scale = baseScale / (double)i * 4.0;
                Matrix4 mat = RenderUtils.getMatrix((Vector3)new Vector3(0.0, 0.0, 0.0), (Rotation)new Rotation((double)(((float)ClientEventHandler.elapsedTicks + partialTicks) / 40.0f), 0.0, 1.0, 0.0), (double)(-1.0 * scale));
                model.render(ccrs, new IVertexOperation[]{mat});
            }
            ccrs.draw();
        }
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179098_w();
        GlStateManager.func_179089_o();
        GlStateManager.func_179121_F();
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181704_d);
    }

    public static class Factory
    implements IBCParticleFactory {
        public Particle getEntityFX(int particleID, World world, Vec3D pos, Vec3D speed, int ... args) {
            ParticleChaosImplosion particle = new ParticleChaosImplosion(world, pos, speed);
            if (args.length > 0) {
                if (args[0] == 0) {
                    particle.isTracer = true;
                } else if (args[0] == 1) {
                    particle.isOrigin = true;
                    particle.isTracer = false;
                } else if (args[0] == 2) {
                    particle.isOrigin = true;
                    particle.contract = true;
                    particle.isTracer = false;
                } else if (args[0] == 3) {
                    particle.isTracer = false;
                } else if (args[0] == 4) {
                    particle.contract = true;
                    particle.isTracer = false;
                } else if (args[0] == 5) {
                    particle.isTracer = false;
                    particle.explosion = true;
                }
            }
            return particle;
        }
    }
}

