/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.render.item;

import codechicken.lib.render.CCModel;
import codechicken.lib.render.CCOBJParser;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.RenderUtils;
import codechicken.lib.render.item.IItemRenderer;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.render.shader.ShaderProgram;
import codechicken.lib.render.state.GlStateManagerHelper;
import codechicken.lib.util.TransformUtils;
import codechicken.lib.vec.Matrix4;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Vector3;
import com.brandon3055.draconicevolution.blocks.energynet.EnergyCrystal;
import com.brandon3055.draconicevolution.client.handler.ClientEventHandler;
import com.brandon3055.draconicevolution.client.render.shaders.DEShaders;
import com.brandon3055.draconicevolution.helpers.ResourceHelperDE;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IPerspectiveAwareModel;
import org.apache.commons.lang3.tuple.Pair;

public class RenderItemEnergyCrystal
implements IItemRenderer,
IPerspectiveAwareModel {
    private CCModel crystalFull;
    private CCModel crystalHalf;
    private CCModel crystalBase;
    private static float[] r = new float[]{0.0f, 0.47f, 1.0f};
    private static float[] g = new float[]{0.2f, 0.0f, 0.4f};
    private static float[] b = new float[]{0.3f, 0.58f, 0.1f};

    public RenderItemEnergyCrystal() {
        Map map = CCOBJParser.parseObjModels((ResourceLocation)ResourceHelperDE.getResource("models/crystal.obj"));
        this.crystalFull = CCModel.combine(map.values());
        map = CCOBJParser.parseObjModels((ResourceLocation)ResourceHelperDE.getResource("models/crystal_half.obj"));
        this.crystalHalf = (CCModel)map.get("Crystal");
        this.crystalBase = (CCModel)map.get("Base");
    }

    public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
        return new ArrayList<BakedQuad>();
    }

    public boolean func_177555_b() {
        return false;
    }

    public boolean func_177556_c() {
        return false;
    }

    public boolean func_188618_c() {
        return true;
    }

    public TextureAtlasSprite func_177554_e() {
        return null;
    }

    public ItemCameraTransforms func_177552_f() {
        return ItemCameraTransforms.field_178357_a;
    }

    public ItemOverrideList func_188617_f() {
        return ItemOverrideList.field_188022_a;
    }

    public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
        return IPerspectiveAwareModel.MapWrapper.handlePerspective((IBakedModel)this, (ImmutableMap)TransformUtils.DEFAULT_BLOCK.getTransforms(), (ItemCameraTransforms.TransformType)cameraTransformType);
    }

    public void renderItem(ItemStack item) {
        EnergyCrystal.CrystalType type = EnergyCrystal.CrystalType.fromMeta(item.func_77952_i());
        int tier = EnergyCrystal.CrystalType.getTier(item.func_77952_i());
        GlStateManager.func_179094_E();
        GlStateManagerHelper.pushState();
        GlStateManager.func_179140_f();
        CCRenderState ccrs = CCRenderState.instance();
        Matrix4 mat = RenderUtils.getMatrix((Vector3)new Vector3(0.5, type == EnergyCrystal.CrystalType.CRYSTAL_IO ? 0.0 : 0.5, 0.5), (Rotation)new Rotation(0.0, 0.0, 0.0, 0.0), (double)1.0);
        ResourceHelperDE.bindTexture("textures/models/crystal_purple_transparent.png");
        if (type == EnergyCrystal.CrystalType.CRYSTAL_IO) {
            ccrs.startDrawing(4, DefaultVertexFormats.field_181707_g);
            this.crystalBase.render(ccrs, new IVertexOperation[]{mat});
            ccrs.draw();
            mat.apply((Transformation)new Rotation((double)((float)ClientEventHandler.elapsedTicks / 400.0f), 0.0, 1.0, 0.0));
            ResourceHelperDE.bindTexture("textures/models/reactor_core.png");
            this.bindShader(0.0f, tier);
            ccrs.startDrawing(4, DefaultVertexFormats.field_181707_g);
            this.crystalHalf.render(ccrs, new IVertexOperation[]{mat});
            ccrs.draw();
            this.releaseShader();
        } else {
            this.bindShader(0.0f, tier);
            ccrs.startDrawing(4, DefaultVertexFormats.field_181707_g);
            this.crystalFull.render(ccrs, new IVertexOperation[]{mat});
            ccrs.draw();
            this.releaseShader();
        }
        GlStateManagerHelper.popState();
        GlStateManager.func_179121_F();
    }

    public void bindShader(float partialTicks, int tier) {
        if (OpenGlHelper.field_148824_g) {
            DEShaders.eCrystalOp.setType(tier);
            DEShaders.eCrystalOp.setAnimation(((float)ClientEventHandler.elapsedTicks + partialTicks) / 50.0f);
            DEShaders.eCrystalOp.setMipmap(0.0f);
            DEShaders.energyCrystal.freeBindShader();
        } else {
            ResourceHelperDE.bindTexture("textures/models/crystal_no_shader.png");
            GlStateManager.func_179124_c((float)r[tier], (float)g[tier], (float)b[tier]);
        }
        OpenGlHelper.field_148824_g = true;
    }

    private void releaseShader() {
        if (OpenGlHelper.field_148824_g) {
            ShaderProgram.unbindShader();
        }
    }
}

