/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.render.effect;

import codechicken.lib.render.CCModelLibrary;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.RenderUtils;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Vector3;
import com.brandon3055.brandonscore.client.particle.BCEffectHandler;
import com.brandon3055.brandonscore.client.particle.BCParticle;
import com.brandon3055.brandonscore.lib.Vec3D;
import com.brandon3055.brandonscore.utils.Utils;
import com.brandon3055.draconicevolution.api.fusioncrafting.IFusionCraftingInventory;
import com.brandon3055.draconicevolution.blocks.tileentity.TileCraftingPedestal;
import com.brandon3055.draconicevolution.client.DEParticles;
import com.brandon3055.draconicevolution.client.render.effect.RenderEnergyBolt;
import com.brandon3055.draconicevolution.lib.DESoundHandler;
import java.util.Random;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;

public class EffectTrackerFusionCrafting {
    public static double interpPosX = 0.0;
    public static double interpPosY = 0.0;
    public static double interpPosZ = 0.0;
    private Random rand = new Random();
    private final Vec3D corePos;
    public final IFusionCraftingInventory craftingInventory;
    private int renderBolt = 0;
    private float rotation;
    private float rotationSpeed = 1.0f;
    private float aRandomFloat = 0.0f;
    public boolean positionLocked = false;
    public Vec3D startPos;
    public Vec3D pos;
    public Vec3D prevPos = new Vec3D();
    public Vec3D circlePosition = new Vec3D();
    private World worldObj;
    private long boltSeed = 0L;
    public float alpha = 0.0f;
    public float scale = 1.0f;
    public float red = 0.0f;
    public float green = 1.0f;
    public float blue = 1.0f;

    public EffectTrackerFusionCrafting(World world, Vec3D pos, Vec3D corePos, IFusionCraftingInventory craftingInventory) {
        this.worldObj = world;
        this.corePos = corePos;
        this.craftingInventory = craftingInventory;
        this.rotation = this.rand.nextInt(1000);
        this.aRandomFloat = this.rand.nextFloat();
        this.pos = pos.copy();
        this.startPos = pos.copy();
        this.prevPos.set(pos);
    }

    public void onUpdate(boolean isMoving) {
        this.prevPos.set(this.pos);
        if (isMoving) {
            double distance;
            if (this.pos.equals((Object)this.startPos)) {
                this.worldObj.func_184134_a(this.pos.x, this.pos.y, this.pos.z, DESoundHandler.fusionComplete, SoundCategory.BLOCKS, 0.5f, 0.5f, false);
            }
            if ((distance = Utils.getDistanceAtoB((Vec3D)this.circlePosition, (Vec3D)this.pos)) > 0.1 && !this.positionLocked) {
                if (this.scale > 1.0f) {
                    this.scale -= 0.05f;
                }
                Vec3D dir = Vec3D.getDirectionVec((Vec3D)this.pos, (Vec3D)this.circlePosition);
                double speed = 0.1 + (double)this.aRandomFloat * 0.1;
                dir.multiply(speed, speed, speed);
                this.pos.add(dir.x, dir.y, dir.z);
            } else {
                if (!this.positionLocked) {
                    this.worldObj.func_184134_a(this.pos.x, this.pos.y, this.pos.z, DESoundHandler.fusionComplete, SoundCategory.BLOCKS, 2.0f, 0.5f, false);
                }
                this.positionLocked = true;
                this.pos.set(this.circlePosition);
            }
        } else {
            this.scale = 1.5f;
        }
        int chance = 22 - (int)((double)this.craftingInventory.getCraftingStage() / 2000.0 * 22.0);
        if (chance < 1) {
            chance = 1;
        }
        if (this.rand.nextInt(chance) == 0) {
            BCEffectHandler.spawnFXDirect((ResourceLocation)DEParticles.DE_SHEET, (BCParticle)new SubParticle(this.worldObj, this.pos));
        }
        if (this.renderBolt > 0) {
            --this.renderBolt;
        }
        if (this.rand.nextInt(chance * 2 + 2) == 0) {
            this.renderBolt = 1;
            this.boltSeed = this.rand.nextLong();
            Vec3D pos = this.corePos.copy().add(0.5, 0.5, 0.5);
            BCEffectHandler.spawnFXDirect((ResourceLocation)DEParticles.DE_SHEET, (BCParticle)new SubParticle(this.worldObj, pos));
            this.worldObj.func_184134_a(pos.x, pos.y, pos.z, DESoundHandler.energyBolt, SoundCategory.BLOCKS, 1.0f, 0.9f + this.rand.nextFloat() * 0.2f, false);
        }
        if (this.craftingInventory.getCraftingStage() < 1000) {
            TileEntity tile = this.worldObj.func_175625_s(this.pos.getPos());
            if (tile instanceof TileCraftingPedestal && this.craftingInventory.getRequiredCharge() > 0) {
                this.alpha = (float)((TileCraftingPedestal)tile).getCharge() / (float)this.craftingInventory.getRequiredCharge();
            }
        } else {
            this.alpha = 1.0f;
        }
        this.rotationSpeed = 1.0f + (float)this.craftingInventory.getCraftingStage() / 1000.0f * 10.0f;
        if (this.alpha > 1.0f) {
            this.alpha = 1.0f;
        }
        this.rotation += this.rotationSpeed;
    }

    public void renderEffect(Tessellator tessellator, float partialTicks) {
        VertexBuffer vertexbuffer = tessellator.func_178180_c();
        CCRenderState ccrs = CCRenderState.instance();
        float relativeX = (float)(this.prevPos.x + (this.pos.x - this.prevPos.x) * (double)partialTicks - interpPosX);
        float relativeY = (float)(this.prevPos.y + (this.pos.y - this.prevPos.y) * (double)partialTicks - interpPosY);
        float relativeZ = (float)(this.prevPos.z + (this.pos.z - this.prevPos.z) * (double)partialTicks - interpPosZ);
        float correctX = (float)(this.prevPos.x + (this.pos.x - this.prevPos.x) * (double)partialTicks);
        float correctY = (float)(this.prevPos.y + (this.pos.y - this.prevPos.y) * (double)partialTicks);
        float correctZ = (float)(this.prevPos.z + (this.pos.z - this.prevPos.z) * (double)partialTicks);
        GlStateManager.func_179094_E();
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)200.0f, (float)200.0f);
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179131_c((float)this.red, (float)this.green, (float)this.blue, (float)this.alpha);
        GlStateManager.func_179109_b((float)relativeX, (float)relativeY, (float)relativeZ);
        GlStateManager.func_179114_b((float)(this.rotation + partialTicks * this.rotationSpeed), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179109_b((float)(-relativeX), (float)(-relativeY), (float)(-relativeZ));
        ccrs.reset();
        ccrs.startDrawing(7, DefaultVertexFormats.field_181710_j, vertexbuffer);
        Matrix4 pearlMat = RenderUtils.getMatrix((Vector3)new Vector3((double)relativeX, (double)relativeY, (double)relativeZ), (Rotation)new Rotation(0.0, new Vector3(0.0, 0.0, 0.0)), (double)(0.15 * (double)this.scale));
        ccrs.bind(vertexbuffer);
        CCModelLibrary.icosahedron7.render(ccrs, new IVertexOperation[]{pearlMat});
        tessellator.func_78381_a();
        GlStateManager.func_179121_F();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)relativeX, (float)relativeY, (float)relativeZ);
        if (this.renderBolt > 0) {
            RenderEnergyBolt.renderBoltBetween(new Vec3D(), this.corePos.copy().subtract((double)correctX - 0.5, (double)correctY - 0.5, (double)correctZ - 0.5), 0.05, 1.0, 10, this.boltSeed, true);
        }
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179140_f();
        GlStateManager.func_179121_F();
    }

    public static class SubParticle
    extends BCParticle {
        public SubParticle(World worldIn, Vec3D pos) {
            super(worldIn, pos);
            double speed = 0.1;
            this.field_187129_i = (-0.5 + this.field_187136_p.nextDouble()) * speed;
            this.field_187130_j = (-0.5 + this.field_187136_p.nextDouble()) * speed;
            this.field_187131_k = (-0.5 + this.field_187136_p.nextDouble()) * speed;
            this.field_70547_e = 10 + this.field_187136_p.nextInt(10);
            this.field_70544_f = 1.0f;
            this.field_94055_c = 1;
            this.field_70552_h = 0.0f;
        }

        public boolean func_187111_c() {
            return true;
        }

        public void func_189213_a() {
            this.field_187123_c = this.field_187126_f;
            this.field_187124_d = this.field_187127_g;
            this.field_187125_e = this.field_187128_h;
            this.field_94054_b = this.field_187136_p.nextInt(5);
            int ttd = this.field_70547_e - this.field_70546_d;
            if (ttd < 10) {
                this.field_70544_f = (float)ttd / 10.0f;
            }
            this.moveEntityNoClip(this.field_187129_i, this.field_187130_j, this.field_187131_k);
            if (this.field_70546_d++ > this.field_70547_e) {
                this.func_187112_i();
            }
        }

        public void func_180434_a(VertexBuffer vertexbuffer, Entity entityIn, float partialTicks, float rotationX, float rotationZ, float rotationYZ, float rotationXY, float rotationXZ) {
            float minU = (float)this.field_94054_b / 8.0f;
            float maxU = minU + 0.125f;
            float minV = (float)this.field_94055_c / 8.0f;
            float maxV = minV + 0.125f;
            float scale = 0.1f * this.field_70544_f;
            float renderX = (float)(this.field_187123_c + (this.field_187126_f - this.field_187123_c) * (double)partialTicks - field_70556_an);
            float renderY = (float)(this.field_187124_d + (this.field_187127_g - this.field_187124_d) * (double)partialTicks - field_70554_ao);
            float renderZ = (float)(this.field_187125_e + (this.field_187128_h - this.field_187125_e) * (double)partialTicks - field_70555_ap);
            int brightnessForRender = this.func_189214_a(partialTicks);
            int j = brightnessForRender >> 16 & 0xFFFF;
            int k = brightnessForRender & 0xFFFF;
            vertexbuffer.func_181662_b((double)(renderX - rotationX * scale - rotationXY * scale), (double)(renderY - rotationZ * scale), (double)(renderZ - rotationYZ * scale - rotationXZ * scale)).func_187315_a((double)maxU, (double)maxV).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_187314_a(j, k).func_181675_d();
            vertexbuffer.func_181662_b((double)(renderX - rotationX * scale + rotationXY * scale), (double)(renderY + rotationZ * scale), (double)(renderZ - rotationYZ * scale + rotationXZ * scale)).func_187315_a((double)maxU, (double)minV).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_187314_a(j, k).func_181675_d();
            vertexbuffer.func_181662_b((double)(renderX + rotationX * scale + rotationXY * scale), (double)(renderY + rotationZ * scale), (double)(renderZ + rotationYZ * scale + rotationXZ * scale)).func_187315_a((double)minU, (double)minV).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_187314_a(j, k).func_181675_d();
            vertexbuffer.func_181662_b((double)(renderX + rotationX * scale - rotationXY * scale), (double)(renderY - rotationZ * scale), (double)(renderZ + rotationYZ * scale - rotationXZ * scale)).func_187315_a((double)minU, (double)maxV).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_187314_a(j, k).func_181675_d();
        }
    }
}

