/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.gui.modwiki.moddata.displaycontent;

import com.brandon3055.brandonscore.client.gui.modulargui.MGuiElementBase;
import com.brandon3055.brandonscore.client.gui.modulargui.lib.EnumAlignment;
import com.brandon3055.brandonscore.client.gui.modulargui.lib.IMGuiListener;
import com.brandon3055.brandonscore.client.gui.modulargui.modularelements.MGuiButton;
import com.brandon3055.brandonscore.client.gui.modulargui.modularelements.MGuiButtonSolid;
import com.brandon3055.brandonscore.client.gui.modulargui.modularelements.MGuiHoverPopup;
import com.brandon3055.brandonscore.client.gui.modulargui.modularelements.MGuiLabel;
import com.brandon3055.brandonscore.client.gui.modulargui.modularelements.MGuiTextField;
import com.brandon3055.brandonscore.utils.Utils;
import com.brandon3055.draconicevolution.client.gui.modwiki.GuiModWiki;
import com.brandon3055.draconicevolution.client.gui.modwiki.moddata.displaycontent.DisplayComponentBase;
import com.brandon3055.draconicevolution.client.gui.modwiki.moddata.displaycontent.IDisplayComponentFactory;
import com.brandon3055.draconicevolution.client.gui.modwiki.moddata.guidoctree.TreeBranchRoot;
import com.google.common.base.Predicate;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.StringUtils;
import net.minecraft.util.text.TextFormatting;
import org.w3c.dom.Element;

public class DCHeading
extends DisplayComponentBase {
    public int headingSize = 0;
    public String displayString = "";
    public static final String SIZE_ATTRIB = "size";

    public DCHeading(GuiModWiki modularGui, String componentType, TreeBranchRoot branch) {
        super(modularGui, componentType, branch);
        this.ySize = 12;
    }

    @Override
    public int getEntryHeight() {
        return super.getEntryHeight();
    }

    @Override
    public void setXSize(int xSize) {
        super.setXSize(xSize);
        if (xSize < 10) {
            return;
        }
        float scaleFactor = 1.0f + (float)this.headingSize / 2.0f;
        int split = this.fontRenderer.func_78271_c(this.displayString, (int)((float)xSize / scaleFactor)).size();
        this.ySize = (int)((float)this.fontRenderer.field_78288_b * scaleFactor * (float)split);
    }

    @Override
    public void renderBackgroundLayer(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        float scaleFactor = 1.0f + (float)this.headingSize / 2.0f;
        List list = this.fontRenderer.func_78271_c(this.displayString, (int)((float)this.xSize / scaleFactor));
        for (String string : list) {
            float x = 0.0f;
            float y = (float)this.yPos + (float)this.fontRenderer.field_78288_b * scaleFactor * (float)list.indexOf(string);
            float scaledWidth = (float)this.fontRenderer.func_78256_a(string) * scaleFactor;
            switch (this.alignment) {
                case LEFT: {
                    x = (float)this.xPos + 2.0f * scaleFactor;
                    break;
                }
                case CENTER: {
                    x = (float)this.xPos + (float)this.xSize / 2.0f - scaledWidth / 2.0f;
                    break;
                }
                case RIGHT: {
                    x = (float)this.xPos + ((float)this.xSize - scaledWidth) - 2.0f * scaleFactor;
                }
            }
            if (this.headingSize > 0) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)x, (float)y, (float)0.0f);
                GlStateManager.func_179152_a((float)scaleFactor, (float)scaleFactor, (float)1.0f);
                GlStateManager.func_179109_b((float)(-x), (float)(-y), (float)0.0f);
            }
            this.drawString(this.fontRenderer, string, x, y, this.getColour(), this.shadow && this.getColour() / 3 > 50);
            if (this.headingSize <= 0) continue;
            GlStateManager.func_179121_F();
        }
        super.renderBackgroundLayer(minecraft, mouseX, mouseY, partialTicks);
    }

    @Override
    public LinkedList<MGuiElementBase> getEditControls() {
        LinkedList<MGuiElementBase> list = super.getEditControls();
        list.add((MGuiElementBase)new MGuiButtonSolid(this.modularGui, "TOGGLE_ALIGN", 0, 0, 26, 12, "Align"){

            public int getBorderColour(boolean hovering, boolean disabled) {
                return hovering ? -16711936 : -65536;
            }
        }.setListener((IMGuiListener)this).setToolTip(new String[]{"Toggle Text Alignment"}));
        MGuiTextField textField = new MGuiTextField(this.modularGui, 0, 0, 100, 12, this.fontRenderer).setListener((IMGuiListener)this).setMaxStringLength(2048).setText(this.displayString);
        textField.setId("TEXT");
        textField.addChild((MGuiElementBase)new MGuiHoverPopup(this.modularGui, new String[]{"Modify Heading Text", TextFormatting.GREEN + "Will Auto-Save 3 seconds after you stop typing."}, (MGuiElementBase)textField));
        list.add((MGuiElementBase)textField);
        list.add((MGuiElementBase)new MGuiLabel(this.modularGui, 0, 0, 37, 12, "Colour:").setAlignment(EnumAlignment.CENTER));
        MGuiTextField colourField = new MGuiTextField(this.modularGui, 0, 0, 45, 12, this.fontRenderer).setListener((IMGuiListener)this).setMaxStringLength(6).setText("FFFFFF");
        colourField.addChild((MGuiElementBase)new MGuiHoverPopup(this.modularGui, new String[]{"Set the base colour. If left default this will be the text colour for the selected style", "If you change this the only way to to go back is to remove the colour attribute from the entry in the XML file."}, (MGuiElementBase)colourField));
        colourField.setId("COLOUR");
        colourField.setText(Integer.toHexString(this.getColour()));
        colourField.setValidator((Predicate)new Predicate<String>(){

            public boolean apply(@Nullable String input) {
                try {
                    Utils.parseHex((String)input, (boolean)false);
                }
                catch (Exception e) {
                    return false;
                }
                return true;
            }
        });
        list.add((MGuiElementBase)colourField);
        list.add((MGuiElementBase)new MGuiButtonSolid(this.modularGui, "CYCLE_SIZE", 0, 0, 20, 12, "H:"){

            public int getBorderColour(boolean hovering, boolean disabled) {
                return hovering ? -16711936 : -65536;
            }
        }.setListener((IMGuiListener)this).setToolTip(new String[]{"Cycle Trough Heading Sizes", "Hold Shift to reverse"}).setDisplayString("H:" + this.headingSize));
        list.add((MGuiElementBase)new MGuiButtonSolid(this.modularGui, "SHADOW", 0, 0, 10, 12, "S"){

            public int getBorderColour(boolean hovering, boolean disabled) {
                return hovering ? -16711936 : -65536;
            }
        }.setListener((IMGuiListener)this).setToolTip(new String[]{"Toggle Shadow"}));
        list.add(new MGuiButtonSolid(this.modularGui, "OBFUSCATED", 0, 0, 10, 12, TextFormatting.OBFUSCATED + "O"){

            public int getBorderColour(boolean hovering, boolean disabled) {
                return hovering ? -16711936 : -65536;
            }
        }.setListener((IMGuiListener)this).setToolTip(new String[]{"Toggle Obfuscated"}).addToGroup("STYLE"));
        list.add(new MGuiButtonSolid(this.modularGui, "BOLD", 0, 0, 10, 12, TextFormatting.BOLD + "B"){

            public int getBorderColour(boolean hovering, boolean disabled) {
                return hovering ? -16711936 : -65536;
            }
        }.setListener((IMGuiListener)this).setToolTip(new String[]{"Toggle Bold"}).addToGroup("STYLE"));
        list.add(new MGuiButtonSolid(this.modularGui, "STRIKETHROUGH", 0, 0, 10, 12, TextFormatting.STRIKETHROUGH + "S"){

            public int getBorderColour(boolean hovering, boolean disabled) {
                return hovering ? -16711936 : -65536;
            }
        }.setListener((IMGuiListener)this).setToolTip(new String[]{"Toggle Strike-through"}).addToGroup("STYLE"));
        list.add(new MGuiButtonSolid(this.modularGui, "UNDERLINE", 0, 0, 10, 12, TextFormatting.UNDERLINE + "U"){

            public int getBorderColour(boolean hovering, boolean disabled) {
                return hovering ? -16711936 : -65536;
            }
        }.setListener((IMGuiListener)this).setToolTip(new String[]{"Toggle Underline"}).addToGroup("STYLE"));
        list.add(new MGuiButtonSolid(this.modularGui, "ITALIC", 0, 0, 10, 12, TextFormatting.ITALIC + "I"){

            public int getBorderColour(boolean hovering, boolean disabled) {
                return hovering ? -16711936 : -65536;
            }
        }.setListener((IMGuiListener)this).setToolTip(new String[]{"Toggle Italic"}).addToGroup("STYLE"));
        return list;
    }

    @Override
    public void onMGuiEvent(String eventString, MGuiElementBase eventElement) {
        super.onMGuiEvent(eventString, eventElement);
        if (eventElement.id.equals("TEXT") && eventString.equals("TEXT_FIELD_CHANGED") && eventElement instanceof MGuiTextField) {
            if (StringUtils.func_151246_b((String)((MGuiTextField)eventElement).getText())) {
                return;
            }
            this.element.setTextContent(((MGuiTextField)eventElement).getText());
            this.displayString = ((MGuiTextField)eventElement).getText();
            this.requiresSave = true;
            this.saveTimer = 60;
        } else if (eventString.equals("BUTTON_PRESS") && eventElement instanceof MGuiButtonSolid && ((MGuiButtonSolid)eventElement).buttonName.equals("CYCLE_SIZE")) {
            this.headingSize += GuiScreen.func_146272_n() ? -1 : 1;
            if (this.headingSize > 10) {
                this.headingSize = 0;
            } else if (this.headingSize < 0) {
                this.headingSize = 0;
            }
            this.element.setAttribute(SIZE_ATTRIB, String.valueOf(this.headingSize));
            this.save();
        } else if (eventString.equals("BUTTON_PRESS") && eventElement instanceof MGuiButtonSolid && ((MGuiButtonSolid)eventElement).buttonName.equals("SHADOW")) {
            this.shadow = !this.shadow;
            this.element.setAttribute("shadow", String.valueOf(this.shadow));
            this.save();
        } else if (eventElement.id.equals("COLOUR") && eventString.equals("TEXT_FIELD_CHANGED") && eventElement instanceof MGuiTextField) {
            try {
                this.setColour(Utils.parseHex((String)((MGuiTextField)eventElement).getText()));
                this.element.setAttribute("colour", Integer.toHexString(this.getColour()));
                this.requiresSave = true;
                this.saveTimer = 60;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (eventElement instanceof MGuiButton && eventElement.isInGroup("STYLE")) {
            TextFormatting format = TextFormatting.valueOf((String)((MGuiButton)eventElement).buttonName);
            this.displayString = this.displayString.contains(format.toString()) ? this.displayString.replace(format.toString(), "") : format + this.displayString;
            for (MGuiElementBase element : this.branch.guiWiki.contentWindow.editControls) {
                if (!(element instanceof MGuiTextField)) continue;
                ((MGuiTextField)element).setText(this.displayString);
                break;
            }
            this.element.setTextContent(this.displayString);
            this.save();
        }
    }

    @Override
    public void onCreated() {
        this.element.setAttribute(SIZE_ATTRIB, "0");
        this.element.setTextContent("Click To Edit");
        this.element.setAttribute("shadow", "true");
        this.element.setAttribute("alignment", "CENTER");
    }

    @Override
    public void loadFromXML(Element element) {
        super.loadFromXML(element);
        this.displayString = element.getTextContent();
        if (element.hasAttribute(SIZE_ATTRIB)) {
            this.headingSize = Integer.parseInt(element.getAttribute(SIZE_ATTRIB));
        }
    }

    public static class Factory
    implements IDisplayComponentFactory {
        @Override
        public DisplayComponentBase createNewInstance(GuiModWiki guiWiki, TreeBranchRoot branch) {
            DCHeading component = new DCHeading(guiWiki, this.getID(), branch);
            component.setWorldAndResolution(guiWiki.field_146297_k, guiWiki.screenWidth(), guiWiki.screenHeight());
            return component;
        }

        @Override
        public String getID() {
            return "heading";
        }
    }
}

