/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.gui;

import com.brandon3055.brandonscore.blocks.TileBCBase;
import com.brandon3055.brandonscore.client.gui.effects.GuiEffect;
import com.brandon3055.brandonscore.client.gui.effects.GuiEffectRenderer;
import com.brandon3055.brandonscore.client.utils.GuiHelper;
import com.brandon3055.brandonscore.lib.Vec3D;
import com.brandon3055.brandonscore.network.PacketTileMessage;
import com.brandon3055.brandonscore.utils.Utils;
import com.brandon3055.draconicevolution.api.OreDictHelper;
import com.brandon3055.draconicevolution.api.fusioncrafting.IFusionRecipe;
import com.brandon3055.draconicevolution.blocks.tileentity.TileFusionCraftingCore;
import com.brandon3055.draconicevolution.client.render.effect.RenderEnergyBolt;
import com.brandon3055.draconicevolution.helpers.ResourceHelperDE;
import com.brandon3055.draconicevolution.integration.ModHelper;
import com.brandon3055.draconicevolution.inventory.ContainerFusionCraftingCore;
import com.brandon3055.draconicevolution.lib.RecipeManager;
import java.io.IOException;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiFusionCraftingCore
extends GuiContainer {
    private final EntityPlayer player;
    private final TileFusionCraftingCore tile;
    private IFusionRecipe currentRecipe = null;
    private String canCraft = "";
    private GuiButton startCrafting;
    private GuiEffectRenderer guiEffectRenderer = new GuiEffectRenderer();
    private Random rand = new Random();
    private int[] boltStats = new int[]{0, 0, 0, 0, 0, 0};

    public GuiFusionCraftingCore(EntityPlayer player, TileFusionCraftingCore tile) {
        super((Container)new ContainerFusionCraftingCore(player, tile));
        this.player = player;
        this.tile = tile;
        this.field_146999_f = 180;
        this.field_147000_g = 200;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.clear();
        this.startCrafting = new StartButton(0, this.field_146294_l / 2 - 40, this.field_147009_r + 93, 80, 14, I18n.func_135052_a((String)"gui.de.button.start", (Object[])new Object[0]));
        this.field_146292_n.add(this.startCrafting);
        this.startCrafting.field_146125_m = false;
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GuiHelper.drawGuiBaseBackground((Gui)this, (int)this.field_147003_i, (int)this.field_147009_r, (int)this.field_146999_f, (int)this.field_147000_g);
        GuiHelper.drawColouredRect((int)(this.field_147003_i + 3), (int)(this.field_147009_r + 3), (int)(this.field_146999_f - 6), (int)110, (int)-16711681);
        GuiHelper.drawColouredRect((int)(this.field_147003_i + 4), (int)(this.field_147009_r + 4), (int)(this.field_146999_f - 8), (int)108, (int)-16777216);
        if (this.currentRecipe != null && this.canCraft != null && this.canCraft.equals("true")) {
            GuiHelper.drawColouredRect((int)(this.field_147003_i + 15), (int)(this.field_147009_r + 7), (int)20, (int)100, (int)-5635841);
            GuiHelper.drawColouredRect((int)(this.field_147003_i + 16), (int)(this.field_147009_r + 8), (int)18, (int)98, (int)-16777216);
            GuiHelper.drawColouredRect((int)(this.field_147003_i + this.field_146999_f - 35), (int)(this.field_147009_r + 7), (int)20, (int)100, (int)-5635841);
            GuiHelper.drawColouredRect((int)(this.field_147003_i + this.field_146999_f - 34), (int)(this.field_147009_r + 8), (int)18, (int)98, (int)-16777216);
            GuiHelper.drawColouredRect((int)(this.field_147003_i + this.field_146999_f / 2 - 10), (int)(this.field_147009_r + 24), (int)20, (int)64, (int)-16711681);
            GuiHelper.drawColouredRect((int)(this.field_147003_i + this.field_146999_f / 2 - 9), (int)(this.field_147009_r + 25), (int)18, (int)62, (int)-16777216);
        }
        this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"gui.de.fusionCraftingCore.name", (Object[])new Object[0]), this.field_147003_i + this.field_146999_f / 2, this.field_147009_r + 5, 65535);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ResourceHelperDE.bindTexture("textures/gui/fusion_crafting.png");
        GuiHelper.drawPlayerSlots((Gui)this, (int)(this.field_147003_i + this.field_146999_f / 2), (int)(this.field_147009_r + 115), (boolean)true);
        if (this.currentRecipe == null || this.canCraft == null || !this.canCraft.equals("true")) {
            this.func_73729_b(this.field_147003_i + this.field_146999_f / 2 - 9, this.field_147009_r + 25, 138, 0, 18, 18);
            if (this.tile.func_70301_a(1) != null) {
                this.func_73729_b(this.field_147003_i + this.field_146999_f / 2 - 9, this.field_147009_r + 69, 138, 0, 18, 18);
            }
        }
        if (this.currentRecipe != null) {
            GuiHelper.drawStack2D((ItemStack)this.currentRecipe.getRecipeOutput(this.tile.getStackInCore(0)), (Minecraft)this.field_146297_k, (int)(this.field_147003_i + this.field_146999_f / 2 - 8), (int)(this.field_147009_r + 70), (float)16.0f);
            List ingredients = this.currentRecipe.getRecipeIngredients();
            int centerX = this.field_147003_i + this.field_146999_f / 2;
            int centerY = this.field_147009_r + this.field_147000_g / 2 - 42;
            if (this.tile.isCrafting.value && this.tile.craftingStage.value > 0) {
                GlStateManager.func_179132_a((boolean)false);
                double charge = (double)this.tile.craftingStage.value / 1000.0;
                if (charge > 1.0) {
                    charge = 1.0;
                }
                int size = (int)((1.0 - charge) * 98.0);
                RenderEnergyBolt.renderBoltBetween(new Vec3D((double)(this.field_147003_i + 16 + this.boltStats[0]), (double)(this.field_147009_r + 106), 0.0), new Vec3D((double)(this.field_147003_i + 16 + this.boltStats[1]), (double)(this.field_147009_r + 8 + size), 0.0), 1.0, charge * 10.0, 10, this.boltStats[2], true);
                RenderEnergyBolt.renderBoltBetween(new Vec3D((double)(this.field_147003_i + 16 + this.boltStats[3]), (double)(this.field_147009_r + 106), 0.0), new Vec3D((double)(this.field_147003_i + 16 + this.boltStats[4]), (double)(this.field_147009_r + 8 + size), 0.0), 1.0, charge * 10.0, 10, this.boltStats[5], true);
                RenderEnergyBolt.renderBoltBetween(new Vec3D((double)(this.field_147003_i + this.field_146999_f - 34 + this.boltStats[0]), (double)(this.field_147009_r + 106), 0.0), new Vec3D((double)(this.field_147003_i + this.field_146999_f - 34 + this.boltStats[1]), (double)(this.field_147009_r + 8 + size), 0.0), 1.0, charge * 10.0, 10, this.boltStats[2], true);
                RenderEnergyBolt.renderBoltBetween(new Vec3D((double)(this.field_147003_i + this.field_146999_f - 34 + this.boltStats[3]), (double)(this.field_147009_r + 106), 0.0), new Vec3D((double)(this.field_147003_i + this.field_146999_f - 34 + this.boltStats[4]), (double)(this.field_147009_r + 8 + size), 0.0), 1.0, charge * 10.0, 10, this.boltStats[5], true);
            }
            for (int i = 0; i < ingredients.size(); ++i) {
                int yPos;
                int sideIndex;
                int ySize;
                int xPos;
                boolean isLeft = i % 2 == 0;
                boolean isOdd = ingredients.size() % 2 == 1;
                int sideCount = ingredients.size() / 2;
                if (isOdd && !isLeft) {
                    --sideCount;
                }
                if (isLeft) {
                    xPos = centerX - 65;
                    ySize = 80 / Math.max(sideCount - (isOdd ? 0 : 1), 1);
                    sideIndex = i / 2;
                    if (!(sideCount > 1 || isOdd && ingredients.size() != 1)) {
                        sideIndex = 1;
                        ySize = 40;
                    }
                    yPos = centerY - 40 + sideIndex * ySize;
                } else {
                    xPos = centerX + 65;
                    ySize = 80 / Math.max(sideCount - (isOdd ? 0 : 1), 1);
                    sideIndex = i / 2;
                    if (isOdd) {
                        ++sideCount;
                    }
                    if (sideCount <= 1) {
                        sideIndex = 1;
                        ySize = 40;
                    }
                    yPos = centerY - 40 + sideIndex * ySize;
                }
                GuiHelper.drawStack2D((ItemStack)OreDictHelper.resolveObject(ingredients.get(i)), (Minecraft)this.field_146297_k, (int)(xPos - 8), (int)(yPos - 8), (float)16.0f);
            }
            if (this.tile.isCrafting.value && this.tile.craftingStage.value >= 0) {
                short state = this.tile.craftingStage.value;
                String status = state > 1000 ? I18n.func_135052_a((String)"gui.fusionCrafting.crafting.info", (Object[])new Object[0]) : I18n.func_135052_a((String)"gui.fusionCrafting.charging.info", (Object[])new Object[0]);
                double d = state > 1000 ? (double)((float)state - 1000.0f) / 1000.0 : (double)state / 1000.0;
                this.func_73732_a(this.field_146289_q, status + ": " + TextFormatting.GOLD + (int)(d * 100.0) + "%", this.field_146294_l / 2, this.field_147009_r + 95, state < 1000 ? 65280 : 65535);
            }
        }
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.currentRecipe = RecipeManager.FUSION_REGISTRY.findRecipe(this.tile, this.player.field_70170_p, this.tile.func_174877_v());
        if (this.currentRecipe != null) {
            this.canCraft = this.currentRecipe.canCraft(this.tile, this.player.field_70170_p, this.tile.func_174877_v());
        }
        this.startCrafting.field_146125_m = this.currentRecipe != null && this.canCraft != null && this.canCraft.equals("true") && !this.tile.craftingInProgress();
        this.startCrafting.field_146124_l = this.startCrafting.field_146125_m;
        if (this.currentRecipe != null && this.canCraft != null && this.canCraft.equals("true")) {
            List ingredients = this.currentRecipe.getRecipeIngredients();
            int centerX = this.field_147003_i + this.field_146999_f / 2;
            int centerY = this.field_147009_r + this.field_147000_g / 2 - 45;
            for (int i = 0; i < ingredients.size(); ++i) {
                int yPos;
                int sideIndex;
                int ySize;
                int xPos;
                boolean isLeft = i % 2 == 0;
                boolean isOdd = ingredients.size() % 2 == 1;
                int sideCount = ingredients.size() / 2;
                if (isOdd && !isLeft) {
                    --sideCount;
                }
                if (isLeft) {
                    xPos = centerX - 65;
                    ySize = 80 / Math.max(sideCount - (isOdd ? 0 : 1), 1);
                    sideIndex = i / 2;
                    if (!(sideCount > 1 || isOdd && ingredients.size() != 1)) {
                        sideIndex = 1;
                        ySize = 40;
                    }
                    yPos = centerY - 40 + sideIndex * ySize;
                } else {
                    xPos = centerX + 65;
                    ySize = 80 / Math.max(sideCount - (isOdd ? 0 : 1), 1);
                    sideIndex = i / 2;
                    if (isOdd) {
                        ++sideCount;
                    }
                    if (sideCount <= 1) {
                        sideIndex = 1;
                        ySize = 40;
                    }
                    yPos = centerY - 40 + sideIndex * ySize;
                }
                if (this.rand.nextInt(10) != 0) continue;
                xPos = (int)((double)xPos + (-8.0 + this.rand.nextDouble() * 16.0));
                yPos = (int)((double)yPos + (-8.0 + this.rand.nextDouble() * 16.0));
                double ty = (double)centerY + (-20.0 + this.rand.nextDouble() * 40.0);
                this.guiEffectRenderer.addEffect((GuiEffect)new EnergyEffect(this.player.field_70170_p, xPos, yPos, centerX, ty, 0));
            }
            if (this.tile.craftingStage.value > 1000) {
                double xPos = (double)(centerX - 8) + this.rand.nextDouble() * 16.0;
                double yTop = (double)(this.field_147009_r + 35 - 8) + this.rand.nextDouble() * 16.0;
                this.guiEffectRenderer.addEffect((GuiEffect)new EnergyEffect(this.player.field_70170_p, xPos, yTop, centerX, this.field_147009_r + 78, 1));
            }
            this.guiEffectRenderer.updateEffects();
        } else {
            this.guiEffectRenderer.clearEffects();
        }
        this.boltStats[0] = (int)(this.rand.nextDouble() * 18.0);
        this.boltStats[1] = (int)(this.rand.nextDouble() * 18.0);
        this.boltStats[2] = this.rand.nextInt();
        this.boltStats[3] = (int)(this.rand.nextDouble() * 18.0);
        this.boltStats[4] = (int)(this.rand.nextDouble() * 18.0);
        this.boltStats[5] = this.rand.nextInt();
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
        if (this.currentRecipe != null) {
            if (this.canCraft != null && !this.canCraft.equals("true")) {
                if (this.canCraft.equals("tierLow")) {
                    GuiHelper.drawCenteredString((FontRenderer)this.field_146289_q, (String)I18n.func_135052_a((String)"gui.fusionCrafting.tierLow.info", (Object[])new Object[0]), (int)(this.field_146999_f / 2), (int)95, (int)0xAA00FF, (boolean)false);
                } else if (this.canCraft.equals("outputObstructed")) {
                    GuiHelper.drawCenteredString((FontRenderer)this.field_146289_q, (String)I18n.func_135052_a((String)"gui.fusionCrafting.outputObstructed.info", (Object[])new Object[0]), (int)(this.field_146999_f / 2), (int)95, (int)0xAA00FF, (boolean)false);
                } else {
                    GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)600.0f);
                    GuiHelper.drawColouredRect((int)5, (int)88, (int)(this.field_146999_f - 10), (int)20, (int)-65536);
                    GuiHelper.drawColouredRect((int)6, (int)89, (int)(this.field_146999_f - 12), (int)18, (int)-16777216);
                    GuiHelper.drawCenteredSplitString((FontRenderer)this.field_146289_q, (String)I18n.func_135052_a((String)this.canCraft, (Object[])new Object[0]), (int)(this.field_146999_f / 2), (int)90, (int)(this.field_146999_f - 10), (int)0xAA00FF, (boolean)false);
                    GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-600.0f);
                }
            }
        } else if (ModHelper.isJEIInstalled) {
            GuiHelper.drawBorderedRect((int)81, (int)45, (int)18, (int)22, (int)1, (int)-15724528, (int)-13619152);
            this.field_146289_q.func_175065_a("R", 87.0f, 52.0f, 0xA0A0A0, false);
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.guiEffectRenderer.renderEffects(partialTicks);
        if (this.currentRecipe != null && this.canCraft != null) {
            ItemStack stack;
            List ingredients = this.currentRecipe.getRecipeIngredients();
            int centerX = this.field_147003_i + this.field_146999_f / 2;
            int centerY = this.field_147009_r + this.field_147000_g / 2 - 45;
            for (int i = 0; i < ingredients.size(); ++i) {
                ItemStack stack2;
                int yPos;
                int sideIndex;
                int ySize;
                int xPos;
                boolean isLeft = i % 2 == 0;
                boolean isOdd = ingredients.size() % 2 == 1;
                int sideCount = ingredients.size() / 2;
                if (isOdd && !isLeft) {
                    --sideCount;
                }
                if (isLeft) {
                    xPos = centerX - 65;
                    ySize = 80 / Math.max(sideCount - (isOdd ? 0 : 1), 1);
                    sideIndex = i / 2;
                    if (!(sideCount > 1 || isOdd && ingredients.size() != 1)) {
                        sideIndex = 1;
                        ySize = 40;
                    }
                    yPos = centerY - 40 + sideIndex * ySize;
                } else {
                    xPos = centerX + 65;
                    ySize = 80 / Math.max(sideCount - (isOdd ? 0 : 1), 1);
                    sideIndex = i / 2;
                    if (isOdd) {
                        ++sideCount;
                    }
                    if (sideCount <= 1) {
                        sideIndex = 1;
                        ySize = 40;
                    }
                    yPos = centerY - 40 + sideIndex * ySize;
                }
                if (!GuiHelper.isInRect((int)(xPos - 9), (int)(yPos - 9), (int)18, (int)18, (int)mouseX, (int)mouseY) || (stack2 = OreDictHelper.resolveObject(ingredients.get(i))) == null) continue;
                this.func_146285_a(stack2, mouseX, mouseY);
            }
            if (GuiHelper.isInRect((int)(centerX - 8), (int)(this.field_147009_r + 70), (int)18, (int)18, (int)mouseX, (int)mouseY) && (stack = this.currentRecipe.getRecipeOutput(this.tile.getStackInCore(0))) != null) {
                this.func_146285_a(stack, mouseX, mouseY);
            }
        }
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        this.tile.sendPacketToServer(new PacketTileMessage((TileBCBase)this.tile, (byte)button.field_146127_k, true, false));
    }

    private void drawItemStack(ItemStack stack, int x, int y, String altText) {
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)32.0f);
        this.field_73735_i = 200.0f;
        this.field_146296_j.field_77023_b = 200.0f;
        FontRenderer font = null;
        if (stack != null) {
            font = stack.func_77973_b().getFontRenderer(stack);
        }
        if (font == null) {
            font = this.field_146289_q;
        }
        this.field_146296_j.func_180450_b(stack, x, y);
        this.field_146296_j.func_180453_a(font, stack, x, y, altText);
        this.field_73735_i = 0.0f;
        this.field_146296_j.field_77023_b = 0.0f;
    }

    public class StartButton
    extends GuiButton {
        public StartButton(int buttonId, int x, int y, int width, int height, String text) {
            super(buttonId, x, y, width, height, text);
        }

        public void func_146112_a(Minecraft mc, int mouseX, int mouseY) {
            if (this.field_146125_m) {
                this.field_146123_n = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
                int back = -16777216;
                GuiHelper.drawColouredRect((int)(this.field_146128_h + 1), (int)(this.field_146129_i + 1), (int)(this.field_146120_f - 2), (int)(this.field_146121_g - 2), (int)back);
                int border = this.field_146123_n ? -16737895 : -7864133;
                GuiHelper.drawColouredRect((int)this.field_146128_h, (int)this.field_146129_i, (int)this.field_146120_f, (int)1, (int)border);
                GuiHelper.drawColouredRect((int)this.field_146128_h, (int)(this.field_146129_i + this.field_146121_g - 1), (int)this.field_146120_f, (int)1, (int)border);
                GuiHelper.drawColouredRect((int)this.field_146128_h, (int)this.field_146129_i, (int)1, (int)this.field_146121_g, (int)border);
                GuiHelper.drawColouredRect((int)(this.field_146128_h + this.field_146120_f - 1), (int)this.field_146129_i, (int)1, (int)this.field_146121_g, (int)border);
                GuiHelper.drawCenteredString((FontRenderer)mc.field_71466_p, (String)this.field_146126_j, (int)(this.field_146128_h + this.field_146120_f / 2), (int)(this.field_146129_i + this.field_146121_g / 2 - mc.field_71466_p.field_78288_b / 2), (int)0xFFFFFF, (boolean)false);
            }
        }

        public void drawToolTips(Minecraft mc, int mouseX, int mouseY) {
        }

        public void func_146113_a(SoundHandler soundHandlerIn) {
            super.func_146113_a(soundHandlerIn);
        }
    }

    public static class EnergyEffect
    extends GuiEffect {
        private final double xTarget;
        private final double yTarget;
        private final int type;

        public EnergyEffect(World world, double xCoord, double yCoord, double xTarget, double yTarget, int type) {
            super(world, xCoord, yCoord, 0.0, 0.0);
            this.xTarget = xTarget;
            this.yTarget = yTarget;
            this.type = type;
            this.motionY = 0.0;
            this.motionX = 0.0;
            this.particleMaxAge = 12;
            this.particleScale = 1.0f;
            this.particleTextureIndexY = 1;
            if (type == 1) {
                this.particleRed = 0.0f;
                this.particleGreen = 0.8f;
                this.particleBlue = 1.0f;
                this.particleMaxAge = 21;
            }
        }

        public boolean isTransparent() {
            return true;
        }

        public void onUpdate() {
            block6: {
                block5: {
                    this.prevPosX = this.posX;
                    this.prevPosY = this.posY;
                    if (this.particleAge++ >= this.particleMaxAge) break block5;
                    Vec3D vec3D = new Vec3D(this.posX, this.posY, 0.0);
                    Vec3D vec3D2 = new Vec3D(this.xTarget, this.yTarget, 0.0);
                    if (!(Utils.getDistanceAtoB((Vec3D)vec3D, (Vec3D)vec3D2) < -10.0)) break block6;
                }
                this.setExpired();
            }
            if (this.particleMaxAge - this.particleAge < 10) {
                float d = (float)(this.particleMaxAge - this.particleAge) / 10.0f;
                this.particleScale = d * 1.0f;
            }
            if (this.type == 1 && this.particleMaxAge - this.particleAge < 2) {
                this.particleScale = 3.0f;
            }
            this.particleTextureIndexX = this.rand.nextInt(5);
            Vec3D dir = Vec3D.getDirectionVec((Vec3D)new Vec3D(this.posX, this.posY, 0.0), (Vec3D)new Vec3D(this.xTarget, this.yTarget, 0.0));
            double speed = this.type == 0 ? 5.0 : 3.0;
            this.motionX = dir.x * speed;
            this.motionY = dir.y * speed;
            this.moveEntity(this.motionX, this.motionY);
        }

        public void renderParticle(float partialTicks) {
            ResourceHelperDE.bindTexture("textures/particle/particles.png");
            float minU = (float)this.particleTextureIndexX / 8.0f;
            float maxU = minU + 0.125f;
            float minV = (float)this.particleTextureIndexY / 8.0f;
            float maxV = minV + 0.125f;
            float scale = 8.0f * this.particleScale;
            Tessellator tessellator = Tessellator.func_178181_a();
            VertexBuffer vertexbuffer = tessellator.func_178180_c();
            vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            float renderX = (float)(this.prevPosX + (this.posX - this.prevPosX) * (double)partialTicks);
            float renderY = (float)(this.prevPosY + (this.posY - this.prevPosY) * (double)partialTicks);
            vertexbuffer.func_181662_b((double)(renderX - 1.0f * scale), (double)(renderY - 1.0f * scale), 0.0).func_187315_a((double)maxU, (double)maxV).func_181666_a(this.particleRed, this.particleGreen, this.particleBlue, this.particleAlpha).func_181675_d();
            vertexbuffer.func_181662_b((double)(renderX - 1.0f * scale), (double)(renderY + 1.0f * scale), 0.0).func_187315_a((double)maxU, (double)minV).func_181666_a(this.particleRed, this.particleGreen, this.particleBlue, this.particleAlpha).func_181675_d();
            vertexbuffer.func_181662_b((double)(renderX + 1.0f * scale), (double)(renderY + 1.0f * scale), 0.0).func_187315_a((double)minU, (double)minV).func_181666_a(this.particleRed, this.particleGreen, this.particleBlue, this.particleAlpha).func_181675_d();
            vertexbuffer.func_181662_b((double)(renderX + 1.0f * scale), (double)(renderY - 1.0f * scale), 0.0).func_187315_a((double)minU, (double)maxV).func_181666_a(this.particleRed, this.particleGreen, this.particleBlue, this.particleAlpha).func_181675_d();
            tessellator.func_78381_a();
        }
    }
}

