/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks.reactor;

import codechicken.lib.math.MathHelper;
import com.brandon3055.brandonscore.handlers.IProcess;
import com.brandon3055.brandonscore.lib.DelayedExecutor;
import com.brandon3055.brandonscore.lib.Vec3D;
import com.brandon3055.brandonscore.utils.SimplexNoise;
import com.brandon3055.brandonscore.utils.Utils;
import com.brandon3055.draconicevolution.DraconicEvolution;
import com.brandon3055.draconicevolution.lib.ExplosionHelper;
import com.brandon3055.draconicevolution.network.PacketExplosionFX;
import com.brandon3055.draconicevolution.utils.LogHelper;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class ProcessExplosion
implements IProcess {
    public static DamageSource fusionExplosion = new DamageSource("damage.de.fusionExplode").func_94540_d().func_76348_h().func_151518_m();
    public final Vec3D origin;
    private final WorldServer world;
    private final MinecraftServer server;
    private final int minimumDelay;
    public double[] angularResistance;
    public boolean isDead = false;
    public int radius = 0;
    public int maxRadius;
    public double circumference = 0.0;
    public double meanResistance = 0.0;
    private boolean calculationComplete = false;
    private boolean detonated = false;
    private long startTime = -1L;
    private long calcWait = 0L;
    public boolean lava = true;
    public HashSet<BlockPos> blocksToUpdate = new HashSet();
    public HashSet<HashSet<BlockPos>> destroyedBlocks = new HashSet();
    public HashSet<BlockPos> lavaPositions = new HashSet();
    public HashSet<BlockPos> destroyedCache = new HashSet();
    public HashSet<BlockPos> scannedCache = new HashSet();
    private IBlockState lavaState;

    public ProcessExplosion(BlockPos origin, int radius, WorldServer world, int minimumDelayTime) {
        Fluid pyro;
        this.origin = Vec3D.getCenter((BlockPos)origin);
        this.world = world;
        this.server = world.func_73046_m();
        this.minimumDelay = minimumDelayTime;
        this.angularResistance = new double[121];
        Arrays.fill(this.angularResistance, 100.0);
        LogHelper.info("Explosion Calculation Started for " + radius + " Block radius detonation!");
        this.maxRadius = radius;
        this.lavaState = Blocks.field_150356_k.func_176223_P();
        LogHelper.dev(FluidRegistry.isFluidRegistered((String)"pyrotheum"));
        if (FluidRegistry.isFluidRegistered((String)"pyrotheum") && (pyro = FluidRegistry.getFluid((String)"pyrotheum")).canBePlacedInWorld()) {
            this.lavaState = pyro.getBlock().func_176223_P();
        }
    }

    public void updateProcess() {
        this.server.field_175591_ab = MinecraftServer.func_130071_aq();
        if (this.startTime == -1L) {
            this.startTime = System.currentTimeMillis();
        }
        if (this.calcWait > 0L) {
            --this.calcWait;
            return;
        }
        if (!this.calculationComplete) {
            long t = System.currentTimeMillis();
            this.updateCalculation();
            t = System.currentTimeMillis() - t;
            this.calcWait = t / 40L;
            if (this.calcWait > 0L) {
                LogHelper.dev("Explosion Calc loop took " + t + "ms! Waiting " + this.calcWait + " ticks before continuing");
            }
        } else if (this.minimumDelay == -1) {
            this.isDead = true;
        } else if ((System.currentTimeMillis() - this.startTime) / 1000L >= (long)this.minimumDelay) {
            this.detonate();
        }
    }

    public void updateCalculation() {
        BlockPos originPos = this.origin.getPos();
        double maxCoreHeight = 20.0 * ((double)this.maxRadius / 150.0);
        Vec3D posVec = new Vec3D();
        for (int x = originPos.func_177958_n() - this.radius; x < originPos.func_177958_n() + this.radius; ++x) {
            for (int z = originPos.func_177952_p() - this.radius; z < originPos.func_177952_p() + this.radius; ++z) {
                double dist = Utils.getDistanceAtoB((double)x, (double)z, (double)originPos.func_177958_n(), (double)originPos.func_177952_p());
                if (!(dist < (double)this.radius) || !(dist >= (double)(this.radius - 1))) continue;
                posVec.set((double)x + 0.5, this.origin.y, (double)z + 0.5);
                double radialAngle = this.getRadialAngle(posVec);
                double radialResistance = this.getRadialResistance(radialAngle);
                double angularLoad = this.meanResistance / radialResistance * 1.0;
                double radialPos = 1.0 - (double)this.radius / (double)this.maxRadius;
                double coreFalloff = Math.max(0.0, (radialPos - 0.8) * 5.0);
                coreFalloff = 1.0 - (1.0 - coreFalloff) * (1.0 - coreFalloff) * (1.0 - coreFalloff);
                double coreHeight = coreFalloff * maxCoreHeight;
                double edgeNoise = Math.max(0.0, (-radialPos + 0.2) * 5.0);
                double edgeScatter = edgeNoise * (double)this.world.field_73012_v.nextInt(10);
                double sim = SimplexNoise.noise((double)((double)x / 50.0), (double)((double)z / 50.0));
                edgeNoise = 1.0 + Math.abs(sim) * edgeNoise * 8.0;
                double power = 10000.0 * radialPos * radialPos * radialPos * angularLoad * edgeNoise + edgeScatter;
                double heightUp = 20.0 + (5.0 + (double)this.radius / 10.0) * angularLoad;
                double heightDown = coreHeight + (5.0 + (double)this.radius / 10.0) * angularLoad * (1.0 - coreFalloff);
                double resist = this.trace(posVec.copy(), power, (int)(heightUp += Math.abs(sim) * 4.0 + this.world.field_73012_v.nextDouble()) * 3, 1, 0.0, 0);
                resist += this.trace(posVec.subtract(0.0, 1.0, 0.0), power, (int)(heightDown += Math.abs(sim) * 4.0 + this.world.field_73012_v.nextDouble()), -1, 0.0, 0);
                resist *= 1.0 / angularLoad;
                if (!(radialPos < 0.8)) continue;
                this.addRadialResistance(radialAngle, resist);
            }
        }
        this.recalcResist();
        ++this.radius;
        this.circumference = Math.PI * 2 * (double)this.radius;
        this.destroyedBlocks.add(this.destroyedCache);
        this.destroyedCache = new HashSet();
        this.scannedCache = new HashSet();
        if (this.radius >= this.maxRadius) {
            LogHelper.dev("Explosion Calculation Completed!");
            this.calculationComplete = true;
        }
    }

    private void recalcResist() {
        double total = 0.0;
        for (double resist : this.angularResistance) {
            total += resist;
        }
        this.meanResistance = total / (double)this.angularResistance.length;
    }

    public double getRadialAngle(Vec3D pos) {
        double theta = Math.atan2(pos.x - this.origin.x, this.origin.z - pos.z);
        if (theta < 0.0) {
            theta += Math.PI * 2;
        }
        double angle = theta / (Math.PI * 2) * (double)this.angularResistance.length;
        return angle;
    }

    public double getRadialResistance(double radialPos) {
        int max;
        int min = MathHelper.floor((double)radialPos);
        if (min >= this.angularResistance.length) {
            min -= this.angularResistance.length;
        }
        if ((max = MathHelper.ceil((double)radialPos)) >= this.angularResistance.length) {
            max -= this.angularResistance.length;
        }
        double delta = radialPos - (double)min;
        return this.angularResistance[min] * (1.0 - delta) + this.angularResistance[max] * delta;
    }

    public void addRadialResistance(double radialPos, double power) {
        int max;
        int min = MathHelper.floor((double)radialPos);
        if (min >= this.angularResistance.length) {
            min -= this.angularResistance.length;
        }
        if ((max = MathHelper.ceil((double)radialPos)) >= this.angularResistance.length) {
            max -= this.angularResistance.length;
        }
        double delta = radialPos - (double)min;
        int n = min;
        this.angularResistance[n] = this.angularResistance[n] + power * (1.0 - delta);
        int n2 = max;
        this.angularResistance[n2] = this.angularResistance[n2] + power * delta;
    }

    private double trace(Vec3D posVec, double power, int dist, int traceDir, double totalResist, int travel) {
        if (dist > 100) {
            dist = 100;
        }
        if (dist <= 0 || power <= 0.0 || posVec.y < 0.0 || posVec.y > 255.0) {
            return totalResist;
        }
        --dist;
        ++travel;
        BlockPos pos = posVec.getPos();
        posVec.add(0.0, (double)traceDir, 0.0);
        if (this.scannedCache.contains(pos) || this.destroyedCache.contains(pos)) {
            return this.trace(posVec, power, dist, traceDir, totalResist, travel);
        }
        double r = 1.0;
        IBlockState state = this.world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (!block.isAir(state, (IBlockAccess)this.world, pos)) {
            Material mat = state.func_185904_a();
            double effectivePower = power / 10.0 * ((double)dist / (double)(dist + travel));
            r = block.func_149638_a(null);
            if (effectivePower >= r) {
                this.destroyedCache.add(pos);
            } else if (mat == Material.field_151586_h || mat == Material.field_151587_i) {
                if (effectivePower > 5.0) {
                    this.destroyedCache.add(pos);
                } else {
                    this.blocksToUpdate.add(pos);
                }
                r = 10.0;
            } else {
                if (mat == Material.field_151587_i || mat == Material.field_151586_h || block instanceof BlockLiquid || block instanceof IFluidBlock || block instanceof BlockFalling) {
                    this.blocksToUpdate.add(pos);
                }
                this.scannedCache.add(pos);
            }
            if (r > 1000.0) {
                r = 1000.0;
            }
        } else {
            this.scannedCache.add(pos);
        }
        r = r / (double)this.radius / (double)travel;
        totalResist += r;
        power -= r;
        if (dist == 1 && traceDir == -1 && this.lava && this.world.field_73012_v.nextInt(250) == 0 && !this.world.func_175623_d(pos.func_177977_b())) {
            dist = 0;
            if (this.destroyedCache.contains(pos)) {
                this.destroyedCache.remove(pos);
            }
            this.lavaPositions.add(pos);
            this.blocksToUpdate.add(pos);
            this.scannedCache.add(pos);
        }
        return this.trace(posVec, power, dist, traceDir, totalResist, travel);
    }

    public boolean isCalculationComplete() {
        return this.calculationComplete;
    }

    public boolean detonate() {
        if (!this.isCalculationComplete() || this.detonated) {
            return false;
        }
        long l = System.currentTimeMillis();
        LogHelper.dev("Removing Blocks!");
        LogHelper.startTimer("Adding Blocks For Removal");
        ExplosionHelper removalHelper = new ExplosionHelper(this.world, this.origin.getPos());
        int i = 0;
        for (Collection collection : this.destroyedBlocks) {
            removalHelper.addBlocksForRemoval(collection);
            i += collection.size();
        }
        LogHelper.stopTimer();
        LogHelper.startTimer("Adding Lava");
        for (BlockPos blockPos : this.lavaPositions) {
            this.world.func_175656_a(blockPos, this.lavaState);
        }
        LogHelper.stopTimer();
        LogHelper.startTimer("Adding update Blocks");
        removalHelper.addBlocksForUpdate(this.blocksToUpdate);
        LogHelper.dev("Blocks Removed: " + i);
        LogHelper.stopTimer();
        removalHelper.finish();
        this.isDead = true;
        this.detonated = true;
        final BlockPos pos = this.origin.getPos();
        PacketExplosionFX packetExplosionFX = new PacketExplosionFX(pos, this.radius, false);
        DraconicEvolution.network.sendToAllAround((IMessage)packetExplosionFX, new NetworkRegistry.TargetPoint(this.world.field_73011_w.getDimension(), (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (double)(this.radius * 4)));
        new DelayedExecutor(30, new Object[0]){

            public void execute(Object[] args) {
                List list = ProcessExplosion.this.world.func_72872_a(Entity.class, new AxisAlignedBB(pos, pos.func_177982_a(1, 1, 1)).func_72314_b((double)ProcessExplosion.this.radius * 2.5, (double)ProcessExplosion.this.radius * 2.5, (double)ProcessExplosion.this.radius * 2.5));
                for (Entity e : list) {
                    double dist = e.func_70011_f((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
                    float dmg = 10000.0f * (1.0f - (float)(dist / ((double)ProcessExplosion.this.radius * 1.2)));
                    e.func_70097_a(fusionExplosion, dmg);
                }
            }
        }.run();
        LogHelper.dev("Total explosion time: " + (double)(System.currentTimeMillis() - l) / 1000.0 + "s");
        return true;
    }

    public boolean isDead() {
        return this.isDead;
    }
}

