/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution;

import com.brandon3055.brandonscore.config.ModConfigProperty;
import java.util.HashMap;
import java.util.Map;

public class DEConfig {
    public static Map<String, String> comments = new HashMap<String, String>();
    @ModConfigProperty(category="World", name="worldGenEnabled", comment="Setting this to false will just completely disable ALL DE world gen!")
    public static boolean worldGenEnabled;
    @ModConfigProperty(category="World", name="enableRetroGen", comment="Set this to false if you do not want ore added to chunks that have not previously been generated by DE (this can almost always be left true)")
    public static boolean enableRetroGen;
    @ModConfigProperty(category="World", name="disableOreSpawnOverworld", comment="Disables draconium ore generation in the overworld")
    public static boolean disableOreSpawnOverworld;
    @ModConfigProperty(category="World", name="disableOreSpawnEnd", comment="Disables draconium ore generation in the end")
    public static boolean disableOreSpawnEnd;
    @ModConfigProperty(category="World", name="disableOreSpawnNether", comment="Disables draconium ore generation in the nether")
    public static boolean disableOreSpawnNether;
    @ModConfigProperty(category="World", name="generateEnderComets", comment="Set to false to disable the generation of Ender Comets")
    public static boolean generateEnderComets;
    @ModConfigProperty(category="World", name="generateChaosIslands", comment="Set to false to disable the generation of Chaos Islands")
    public static boolean generateChaosIslands;
    @ModConfigProperty(category="World", name="cometRarity", comment="Ender Comets have a 1 in {this number} chance to spawn in each chunk")
    public static int cometRarity;
    @ModConfigProperty(category="World", name="chaosIslandSeparation", comment="This is the distance between chaos islands")
    public static int chaosIslandSeparation;
    @ModConfigProperty(category="World", name="oreGenDimentionBlacklist", comment="Add the dimension id of any mod dimension's you dont want draconium ore generated in")
    public static int[] oreGenDimentionBlacklist;
    @ModConfigProperty(category="Tweaks", name="rapidDespawnAOEMinedItems", comment="If set to true items dropped by tools in AOE mode will despawn after 5 seconds if not picked up.")
    public static boolean rapidDespawnAOEMinedItems;
    @ModConfigProperty(category="Tweaks", name="disableGuardianCrystalRespawn", comment="(Wuss mode) Setting this to true will disable the chaos guardians ability to respawn healing crystals.")
    public static boolean disableGuardianCrystalRespawn;
    @ModConfigProperty(category="Tweaks", name="enableFlight", comment="Set this to false if you would like to disable the draconic armors flight.")
    public static boolean enableFlight;
    @ModConfigProperty(category="Tweaks", name="dislocatorUsesPerPearl", comment="Sets the number of teleports you get per ender pearl with the Advanced Dislocator")
    public static int dislocatorUsesPerPearl;
    @ModConfigProperty(category="Tweaks", name="hardMode", comment="When true everything is just a little harder. (Currently only effects recipes but that will probably change in the future)")
    public static boolean hardMode;
    @ModConfigProperty(category="Tweaks", name="bowBlockDamage", comment="Set to false to prevent the bows explosion effect breaking blocks")
    public static boolean bowBlockDamage;
    @ModConfigProperty(category="Tweaks", name="grinderEnergyPerHeart", comment="Sets the energy per use per heart of damage for the grinder.")
    public static int grinderEnergyPerHeart;
    @ModConfigProperty(category="Tweaks", name="dragonEggSpawnOverride", comment="By default the dragon egg only ever spawns once. This forces it to spawn every time the dragon is killed.")
    public static boolean dragonEggSpawnOverride;
    @ModConfigProperty(category="Tweaks", name="expensiveDragonRitual", comment="Lets face it. The biggest issue with the new dragon ritual is it is too darn cheap! This modifies the recipe to make it a bit more expensive.")
    public static boolean expensiveDragonRitual;
    @ModConfigProperty(category="Tweaks", name="itemDislocatorBlacklist", comment="A list of items of items that should be ignored by the item dislocator. Use the items registry name e.g. minecraft:apple you can also add a meta value like so minecraft:wool|4")
    public static String[] itemDislocatorBlacklist;
    @ModConfigProperty(category="Tweaks", name="reactorOutputMultiplier", comment="Adjusts the energy output multiplier of the reactor")
    public static double reactorOutputMultiplier;
    @ModConfigProperty(category="Tweaks", name="reactorFuelUsageMultiplier", comment="Adjusts the fuel usage multiplier of the reactor")
    public static double reactorFuelUsageMultiplier;
    @ModConfigProperty(category="Tweaks", name="dragonDustLootModifier", comment="This can be used to adjust the amount of draconium dust the dragon drops when killed.\nThe amount dropped will be this number +/- 10%")
    public static int dragonDustLootModifier;
    @ModConfigProperty(category="Client Settings", name="hudSettings", comment="This is where the settings for the in game hud are stores. You should not need to adjust these unless something breaks.")
    public static int[] hudSettings;
    @ModConfigProperty(category="Client Settings", name="disable3DModels", comment="Disabled the 3D tool and armor models. This is required if you want to use a 2D resource pack.)")
    public static boolean disable3DModels;
    @ModConfigProperty(category="Client Settings", name="invertDPDSB", comment="Invert Dislocator Pedestal display name shift behavior.")
    public static boolean invertDPDSB;
    @ModConfigProperty(category="Client Settings", name="useShaders", comment="Set this to false if your system can not handle the awesomeness that is shaders! (Warning will make cool things look like crap)")
    public static boolean useShaders;
    @ModConfigProperty(category="Client Settings", name="useCrystalShaders", comment="This allowes you to just disable the energy crystal shader which can be a lot lagier than the reactor since there are usually a lot more of them (The fallback crystal texture is not soooo bad...)")
    public static boolean useCrystalShaders;
    @ModConfigProperty(category="Client Settings", name="useReactorBeamShaders", comment="Set this to false if you prefer the original look of the reactor beams")
    public static boolean useReactorBeamShaders;
    @ModConfigProperty(category="Client Settings", name="disableLoudCelestialManipulator", comment="If true the range of the celestial manipulator sound effect will be significantly reduced.")
    public static boolean disableLoudCelestialManipulator;
    @ModConfigProperty(category="Misc", name="devLog", comment="This enables dev log output. I primarily use this for development purposes so it wont be very useful to regular users.")
    public static boolean devLog;
    public static Map<String, Integer> itemDislocatorBlacklistMap;

    public static void init() {
        itemDislocatorBlacklistMap.clear();
        for (String s : itemDislocatorBlacklist) {
            if (s.contains("|")) {
                itemDislocatorBlacklistMap.put(s.substring(0, s.indexOf("|")), Integer.parseInt(s.substring(s.indexOf("|") + 1)));
                continue;
            }
            itemDislocatorBlacklistMap.put(s, -1);
        }
    }

    static {
        comments.put("items", "Allows you to disable any item in the mod. Note that disabling an item will automatically\ndisable its recipe and all recipes that use it. (Requires game restart)\nTo disable an item set its value to false");
        comments.put("blocks", "Allows you to disable any block in the mod. Note that disabling an block will automatically\ndisable its recipe and all recipes that use it. (Requires game restart)\nTo disable a block set its value to false");
        comments.put("World", "This category contains config properties related to world gen.");
        comments.put("Tweaks", "Just what the name says. Tweaks. Allows you to tweak stuff.");
        comments.put("Client Settings", "These are client side properties that have no effect server side.");
        comments.put("Stat Tweaks", "These allow you to tweak the stats of the tools, weapons and armor.");
        comments.put("Misc", "Just some misc settings.");
        worldGenEnabled = true;
        enableRetroGen = true;
        disableOreSpawnOverworld = false;
        disableOreSpawnEnd = false;
        disableOreSpawnNether = false;
        generateEnderComets = true;
        generateChaosIslands = true;
        cometRarity = 10000;
        chaosIslandSeparation = 10000;
        oreGenDimentionBlacklist = new int[0];
        rapidDespawnAOEMinedItems = false;
        disableGuardianCrystalRespawn = false;
        enableFlight = true;
        dislocatorUsesPerPearl = 1;
        hardMode = false;
        bowBlockDamage = true;
        grinderEnergyPerHeart = 80;
        dragonEggSpawnOverride = true;
        expensiveDragonRitual = true;
        itemDislocatorBlacklist = new String[]{"appliedenergistics2:item.ItemCrystalSeed"};
        reactorOutputMultiplier = 1.0;
        reactorFuelUsageMultiplier = 1.0;
        dragonDustLootModifier = 1;
        hudSettings = new int[]{996, 825, 69, 907, 90, 100, 3, 0, 1, 1, 1, 1};
        disable3DModels = false;
        invertDPDSB = false;
        useShaders = true;
        useCrystalShaders = true;
        useReactorBeamShaders = true;
        disableLoudCelestialManipulator = false;
        devLog = false;
        itemDislocatorBlacklistMap = new HashMap<String, Integer>();
    }
}

