/*
 * Decompiled with CFR 0.152.
 */
package com.mrdimka.solarfluxreborn.blocks;

import com.mrdimka.solarfluxreborn.SolarFluxRebornMod;
import com.mrdimka.solarfluxreborn.config.ModConfiguration;
import com.mrdimka.solarfluxreborn.creativetab.ModCreativeTab;
import com.mrdimka.solarfluxreborn.te.DraconicSolarPanelTileEntity;
import com.mrdimka.solarfluxreborn.te.SolarPanelTileEntity;
import com.mrdimka.solarfluxreborn.utility.Lang;
import com.mrdimka.solarfluxreborn.utility.Utils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class DraconicSolarPanelBlock
extends BlockContainer {
    public final int cap;
    public final int transfer;
    public final int maxGen;
    protected String name;

    public DraconicSolarPanelBlock(String pName, int cap, int transfer, int maxGen) {
        super(Material.field_151573_f);
        this.func_149663_c("solarfluxreborn:" + pName);
        this.name = pName;
        this.cap = cap;
        this.transfer = transfer;
        this.maxGen = maxGen;
        this.func_149647_a(ModCreativeTab.MOD_TAB);
        this.func_149711_c(3.0f);
        this.setHarvestLevel("pickaxe", 0);
        this.func_149752_b(5.0f);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_149713_g(255);
        this.field_149783_u = true;
    }

    public boolean func_149662_c(IBlockState p_isOpaqueCube_1_) {
        return false;
    }

    public boolean func_176214_u() {
        return false;
    }

    public boolean func_185481_k(IBlockState p_isFullyOpaque_1_) {
        return false;
    }

    public boolean func_149686_d(IBlockState p_isFullCube_1_) {
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState s, IBlockAccess w, BlockPos p) {
        return new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.375, 1.0);
    }

    public AxisAlignedBB func_180646_a(IBlockState s, World w, BlockPos p) {
        return new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0);
    }

    public AxisAlignedBB func_180640_a(IBlockState s, World w, BlockPos p) {
        return new AxisAlignedBB((double)p.func_177958_n(), (double)p.func_177956_o(), (double)p.func_177952_p(), (double)(p.func_177958_n() + 1), (double)p.func_177956_o() + 0.375, (double)(p.func_177952_p() + 1));
    }

    public TileEntity func_149915_a(World pWorld, int pMetadata) {
        return new DraconicSolarPanelTileEntity(this.name, this.cap, this.transfer, this.maxGen);
    }

    public EnumBlockRenderType func_149645_b(IBlockState p_getRenderType_1_) {
        return EnumBlockRenderType.MODEL;
    }

    public void func_180633_a(World w, BlockPos pos, IBlockState s, EntityLivingBase ent, ItemStack stack) {
        super.func_180633_a(w, pos, s, ent, stack);
        if (stack.func_77978_p() != null) {
            SolarPanelTileEntity localTileCell = (SolarPanelTileEntity)w.func_175625_s(pos);
            localTileCell.getInventory().readFromNBT(stack.func_77978_p().func_74775_l("SFRItems"));
            localTileCell.func_70296_d();
            localTileCell.setEnergyStored(stack.func_77978_p().func_74762_e("SFREnergy"));
            if (localTileCell instanceof DraconicSolarPanelTileEntity && stack.func_77978_p().func_150297_b("MaxGen", 3)) {
                DraconicSolarPanelTileEntity te = (DraconicSolarPanelTileEntity)localTileCell;
                NBTTagCompound nbt = new NBTTagCompound();
                te.writeCustomNBT(nbt);
                nbt.func_74768_a("MaxGen", stack.func_77978_p().func_74762_e("MaxGen"));
                te.readCustomNBT(nbt);
            }
        }
    }

    public boolean func_180639_a(World w, BlockPos pos, IBlockState s, EntityPlayer player, EnumHand hand, ItemStack stack, EnumFacing side, float p_onBlockActivated_8_, float p_onBlockActivated_9_, float p_onBlockActivated_10_) {
        if (!w.field_72995_K) {
            if (player.func_70093_af()) {
                if (Utils.hasUsableWrench(player, pos)) {
                    w.func_175655_b(pos, false);
                    return true;
                }
            } else if (w.func_175625_s(pos) instanceof SolarPanelTileEntity) {
                player.openGui((Object)SolarFluxRebornMod.instance, 0, w, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            }
        }
        return true;
    }

    private void displayChatInformation(World pWorld, BlockPos pos, EntityPlayer pPlayer) {
        SolarPanelTileEntity tile = (SolarPanelTileEntity)pWorld.func_175625_s(pos);
        String message = String.format("%s: [%d%%] %,d / %,d %s: %,d", Lang.localise("energy.stored"), tile.getPercentageEnergyStored(), tile.getEnergyStored(), tile.getMaxEnergyStored(), Lang.localise("energy.generation"), tile.getCurrentEnergyGeneration());
        pPlayer.func_145747_a((ITextComponent)new TextComponentString(message));
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        this.dismantleBlock(world, pos);
        super.func_180663_b(world, pos, state);
    }

    public List<ItemStack> getDrops(IBlockAccess p_getDrops_1_, BlockPos p_getDrops_2_, IBlockState p_getDrops_3_, int p_getDrops_4_) {
        return new ArrayList<ItemStack>();
    }

    private void dismantleBlock(World pWorld, BlockPos pos) {
        int upgradeInstalled;
        SolarPanelTileEntity localTileCell;
        int internalEnergy;
        if (!(pWorld.func_175625_s(pos) instanceof SolarPanelTileEntity)) {
            return;
        }
        ItemStack itemStack = new ItemStack((Block)this);
        itemStack.func_77982_d(new NBTTagCompound());
        if (ModConfiguration.doesKeepEnergyWhenDismantled() && (internalEnergy = (localTileCell = (SolarPanelTileEntity)pWorld.func_175625_s(pos)).getEnergyStored()) > 0) {
            if (itemStack.func_77978_p() == null) {
                itemStack.func_77982_d(new NBTTagCompound());
            }
            itemStack.func_77978_p().func_74768_a("SFREnergy", (int)((float)internalEnergy * 0.01f));
        }
        if (pWorld.func_175625_s(pos) instanceof DraconicSolarPanelTileEntity) {
            DraconicSolarPanelTileEntity panel = (DraconicSolarPanelTileEntity)pWorld.func_175625_s(pos);
            itemStack.func_77978_p().func_74768_a("MaxGen", panel.getMaximumEnergyGeneration());
        }
        if (ModConfiguration.doesKeepInventoryWhenDismantled()) {
            localTileCell = (SolarPanelTileEntity)pWorld.func_175625_s(pos);
            upgradeInstalled = localTileCell.getTotalUpgradeInstalled();
            if (upgradeInstalled > 0) {
                if (itemStack.func_77978_p() == null) {
                    itemStack.func_77982_d(new NBTTagCompound());
                }
                NBTTagCompound nbt = itemStack.func_77978_p().func_74775_l("SFRItems");
                localTileCell.getInventory().writeToNBT(nbt);
                itemStack.func_77978_p().func_74782_a("SFRItems", (NBTBase)nbt);
                itemStack.func_77978_p().func_74768_a("SFRTLUpgradeCount", upgradeInstalled);
                itemStack.func_77978_p().func_74768_a("SFRTLCapacity", localTileCell.getEnergyStorage().getMaxEnergyStored());
                itemStack.func_77978_p().func_74768_a("SFRTLTransferRate", localTileCell.getEnergyStorage().getMaxTransferExtract());
                pWorld.func_175713_t(pos);
            }
        } else {
            localTileCell = (SolarPanelTileEntity)pWorld.func_175625_s(pos);
            upgradeInstalled = localTileCell.getTotalUpgradeInstalled();
            if (upgradeInstalled > 0) {
                localTileCell.getInventory().drop(pWorld, pos);
            }
        }
        pWorld.func_175698_g(pos);
        pWorld.func_72838_d((Entity)new EntityItem(pWorld, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, itemStack));
    }
}

