/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.lib;

import io.netty.buffer.ByteBuf;
import java.awt.Color;
import net.darkhax.bookshelf.lib.Constants;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;

public class Color4f {
    private float red;
    private float green;
    private float blue;
    private float alpha;

    public Color4f(boolean alpha) {
        this(Constants.RANDOM.nextFloat(), Constants.RANDOM.nextFloat(), Constants.RANDOM.nextFloat(), alpha ? Constants.RANDOM.nextFloat() : 1.0f);
    }

    public Color4f(ItemStack stack) {
        this(stack.func_77978_p());
    }

    public Color4f(NBTTagCompound tag) {
        this(tag.func_74760_g("red"), tag.func_74760_g("green"), tag.func_74760_g("blue"), tag.func_74764_b("alpha") ? (float)tag.func_74762_e("alpha") : 1.0f);
    }

    public Color4f(ByteBuf buf) {
        this(buf.readFloat(), buf.readFloat(), buf.readFloat(), buf.readFloat());
    }

    public Color4f(Color color) {
        this(color.getRed(), color.getGreen(), color.getBlue(), 255);
    }

    public Color4f(int red, int green, int blue, int alpha) {
        this((float)red / 255.0f, (float)green / 255.0f, (float)blue / 255.0f, (float)alpha / 255.0f);
    }

    public Color4f(float red, float green, float blue) {
        this(red, green, blue, 1.0f);
    }

    public Color4f(float red, float green, float blue, float alpha) {
        this.setRed(red);
        this.setGreen(green);
        this.setBlue(blue);
        this.setAlpha(alpha);
    }

    public void write(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        this.write(stack.func_77978_p());
    }

    public void write(NBTTagCompound tag) {
        tag.func_74776_a("red", this.red);
        tag.func_74776_a("green", this.green);
        tag.func_74776_a("blue", this.blue);
        tag.func_74776_a("alpha", this.alpha);
    }

    public void write(ByteBuf buf) {
        buf.writeFloat(this.red);
        buf.writeFloat(this.green);
        buf.writeFloat(this.blue);
        buf.writeFloat(this.alpha);
    }

    public boolean isWhite() {
        return this.toAWTColor().equals(Color.WHITE);
    }

    public Color toAWTColor() {
        return new Color((int)(this.red * 255.0f), (int)(this.green * 255.0f), (int)(this.blue * 255.0f));
    }

    public float getRed() {
        return this.red;
    }

    public void setRed(float red) {
        this.red = red;
    }

    public float getGreen() {
        return this.green;
    }

    public void setGreen(float green) {
        this.green = green;
    }

    public float getBlue() {
        return this.blue;
    }

    public void setBlue(float blue) {
        this.blue = blue;
    }

    public float getAlpha() {
        return this.alpha;
    }

    public void setAlpha(float alpha) {
        this.alpha = alpha;
    }

    public String toString() {
        String output = TextFormatting.RED + "" + (int)(this.red * 255.0f) + " " + TextFormatting.GREEN + (int)(this.getGreen() * 255.0f) + " " + TextFormatting.BLUE + (int)(this.blue * 255.0f);
        if (this.alpha < 1.0f) {
            output = output + " " + TextFormatting.GRAY + (int)(100.0f - this.alpha * 100.0f);
        }
        return output;
    }
}

