/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.client.model;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import javax.vecmath.Matrix4f;
import net.darkhax.bookshelf.client.ProxyClient;
import net.darkhax.bookshelf.client.model.DefaultItemOverrideList;
import net.darkhax.bookshelf.client.model.ITileEntityRender;
import net.darkhax.bookshelf.lib.BlockStates;
import net.darkhax.bookshelf.lib.util.RenderUtils;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.IPerspectiveAwareModel;
import net.minecraftforge.client.model.IRetexturableModel;
import net.minecraftforge.client.model.SimpleModelState;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.common.property.IExtendedBlockState;
import org.apache.commons.lang3.tuple.Pair;

public class ModelMultiRetexturable
implements IPerspectiveAwareModel {
    protected final IRetexturableModel baseModel;
    protected final Function<ResourceLocation, TextureAtlasSprite> spriteGetter;
    protected final ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms;
    protected final Map<ImmutableMap<String, String>, IBakedModel> cache = Maps.newHashMap();
    protected final boolean ambientOcclusion;
    protected final boolean gui3D;
    protected final boolean builtin;
    protected final IBlockState particle;
    protected final ItemCameraTransforms cameraTransforms;
    protected final ItemOverrideList itemOverride;

    public ModelMultiRetexturable(IRetexturableModel baseModel, IBlockState particle) {
        this(baseModel, particle, RenderUtils.getBasicTransforms((IPerspectiveAwareModel)baseModel), DefaultItemOverrideList.DEFAULT);
    }

    public ModelMultiRetexturable(IRetexturableModel baseModel, IBlockState particle, ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms, ItemOverrideList itemOverride) {
        this(baseModel, (Function<ResourceLocation, TextureAtlasSprite>)((Function)location -> Minecraft.func_71410_x().func_147117_R().func_110572_b(location.toString())), transforms, true, true, false, particle, ItemCameraTransforms.field_178357_a, itemOverride);
    }

    public ModelMultiRetexturable(IRetexturableModel baseModel, Function<ResourceLocation, TextureAtlasSprite> spriteGetter, ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms, boolean ambientOcclusion, boolean gui3d, boolean builtin, IBlockState particle, ItemCameraTransforms cameraTransforms, ItemOverrideList itemOverride) {
        this.baseModel = baseModel;
        this.spriteGetter = spriteGetter;
        this.transforms = transforms;
        this.ambientOcclusion = ambientOcclusion;
        this.gui3D = gui3d;
        this.builtin = builtin;
        this.particle = particle;
        this.cameraTransforms = cameraTransforms;
        this.itemOverride = itemOverride;
    }

    public IBakedModel getRetexturedModel(ImmutableMap<String, String> builder) {
        ModelMultiRetexturable model = this;
        if (this.cache.containsKey(builder)) {
            model = this.cache.get(builder);
        } else if (this.baseModel != null) {
            IModel retexturedModel = this.baseModel.retexture(builder);
            SimpleModelState modelState = new SimpleModelState(this.transforms);
            model = retexturedModel.bake((IModelState)modelState, DefaultVertexFormats.field_176600_a, this.spriteGetter);
            this.cache.put(builder, (IBakedModel)model);
        }
        return model;
    }

    public IBakedModel getDefaultModel() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        return this.getRetexturedModel((ImmutableMap<String, String>)builder.build());
    }

    public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
        if (state != null) {
            IBlockState heldState = (IBlockState)((IExtendedBlockState)state).getValue(BlockStates.HELD_STATE);
            IBlockAccess iBlockAccess = (IBlockAccess)((IExtendedBlockState)state).getValue(BlockStates.BLOCK_ACCESS);
            BlockPos blockPos = (BlockPos)((IExtendedBlockState)state).getValue(BlockStates.BLOCKPOS);
            if (heldState != null) {
                TileEntity e;
                ITileEntityRender<TileEntity> render;
                if (iBlockAccess != null && blockPos != null && (render = ProxyClient.getTileEntityRender((e = iBlockAccess.func_175625_s(blockPos)).getClass())) != null) {
                    return this.getRetexturedModel(render.getRenderStates(e)).func_188616_a(state, side, rand);
                }
                ImmutableMap.Builder builder = ImmutableMap.builder();
                builder.put((Object)"blank", (Object)RenderUtils.getSprite(heldState).func_94215_i());
                return this.getRetexturedModel((ImmutableMap<String, String>)builder.build()).func_188616_a(state, side, rand);
            }
        }
        return RenderUtils.getMissingquads(state, side, rand);
    }

    public boolean func_177555_b() {
        return this.ambientOcclusion;
    }

    public boolean func_177556_c() {
        return this.gui3D;
    }

    public boolean func_188618_c() {
        return this.builtin;
    }

    public TextureAtlasSprite func_177554_e() {
        return RenderUtils.getSprite(this.particle);
    }

    public ItemCameraTransforms func_177552_f() {
        return this.cameraTransforms;
    }

    public ItemOverrideList func_188617_f() {
        return this.itemOverride;
    }

    public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
        return IPerspectiveAwareModel.MapWrapper.handlePerspective((IBakedModel)this, this.transforms, (ItemCameraTransforms.TransformType)cameraTransformType);
    }
}

