/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import net.minecraft.util.EnumFacing;

public class EnumHelper {
    private static final Map<Class<? extends Enum>, IEnumHandler<?>> registry = Maps.newHashMap();
    private static final List<IEnumHandler> internalHandlers = Lists.newArrayList();

    public static <E extends Enum> void registerHandler(IEnumHandler<E> handler) {
        registry.put(handler.getHandlerClass(), handler);
    }

    public static <E extends Enum> IEnumHandler<E> getHandlerFor(E e) {
        return EnumHelper.getHandlerFor(e.getClass());
    }

    public static <E extends Enum> IEnumHandler<E> getHandlerFor(Class<E> c) {
        return registry.get(c);
    }

    private static <E extends Enum> boolean hasHandler(Class<E> c) {
        return registry.keySet().contains(c);
    }

    private static <E extends Enum> void checkIsMC(Class<E> c) {
        if (c.getName().startsWith("net.minecraft")) {
            throw new IllegalStateException();
        }
    }

    public static <E extends Enum> String getName(E e) {
        if (EnumHelper.hasHandler(e.getClass())) {
            return EnumHelper.getHandlerFor(e).getName(e);
        }
        EnumHelper.checkIsMC(e.getClass());
        return e.toString();
    }

    public static <E extends Enum> int getOrdinal(E e) {
        if (EnumHelper.hasHandler(e.getClass())) {
            return EnumHelper.getHandlerFor(e).getOrdinal(e);
        }
        EnumHelper.checkIsMC(e.getClass());
        return e.ordinal();
    }

    public static <E extends Enum> E fromString(String s, Class<E> c) {
        if (EnumHelper.hasHandler(c)) {
            return EnumHelper.getHandlerFor(c).fromString(s);
        }
        EnumHelper.checkIsMC(c);
        return Enum.valueOf(c, s);
    }

    public static <E extends Enum> E fromOrdinal(int ordinal, Class<E> c) {
        if (EnumHelper.hasHandler(c)) {
            return EnumHelper.getHandlerFor(c).fromOrdinal(ordinal);
        }
        EnumHelper.checkIsMC(c);
        return (E)((Enum[])c.getEnumConstants())[ordinal];
    }

    static {
        internalHandlers.add(new IEnumHandler<EnumFacing>(){

            @Override
            public Class<EnumFacing> getHandlerClass() {
                return EnumFacing.class;
            }

            @Override
            public String getName(EnumFacing facing) {
                switch (facing) {
                    case DOWN: {
                        return "DOWN";
                    }
                    case UP: {
                        return "UP";
                    }
                    case NORTH: {
                        return "NORTH";
                    }
                    case SOUTH: {
                        return "SOUTH";
                    }
                    case WEST: {
                        return "WEST";
                    }
                    case EAST: {
                        return "EAST";
                    }
                }
                throw new IllegalArgumentException();
            }

            @Override
            public EnumFacing fromString(String s) {
                if (s.equals("DOWN")) {
                    return EnumFacing.DOWN;
                }
                if (s.equals("UP")) {
                    return EnumFacing.UP;
                }
                if (s.equals("NORTH")) {
                    return EnumFacing.NORTH;
                }
                if (s.equals("SOUTH")) {
                    return EnumFacing.SOUTH;
                }
                if (s.equals("WEST")) {
                    return EnumFacing.WEST;
                }
                if (s.equals("EAST")) {
                    return EnumFacing.EAST;
                }
                throw new IllegalArgumentException();
            }

            @Override
            public int getOrdinal(EnumFacing facing) {
                switch (facing) {
                    case DOWN: {
                        return 0;
                    }
                    case UP: {
                        return 1;
                    }
                    case NORTH: {
                        return 2;
                    }
                    case SOUTH: {
                        return 3;
                    }
                    case WEST: {
                        return 4;
                    }
                    case EAST: {
                        return 5;
                    }
                }
                throw new IllegalArgumentException();
            }

            @Override
            public EnumFacing fromOrdinal(int i) {
                switch (i) {
                    case 0: {
                        return EnumFacing.DOWN;
                    }
                    case 1: {
                        return EnumFacing.UP;
                    }
                    case 2: {
                        return EnumFacing.NORTH;
                    }
                    case 3: {
                        return EnumFacing.SOUTH;
                    }
                    case 4: {
                        return EnumFacing.WEST;
                    }
                    case 5: {
                        return EnumFacing.EAST;
                    }
                }
                throw new IllegalArgumentException();
            }
        });
        for (IEnumHandler handler : internalHandlers) {
            EnumHelper.registerHandler(handler);
        }
    }

    public static interface IEnumHandler<E extends Enum> {
        public Class<E> getHandlerClass();

        public String getName(E var1);

        public E fromString(String var1);

        public int getOrdinal(E var1);

        public E fromOrdinal(int var1);
    }
}

