/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.inventory.widget;

import com.google.common.collect.Lists;
import elec332.core.client.util.GuiDraw;
import elec332.core.inventory.widget.Widget;
import elec332.core.inventory.window.Window;
import elec332.core.util.NBTHelper;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class WidgetButton
extends Widget {
    protected static final ResourceLocation buttonTextures = new ResourceLocation("textures/gui/widgets.png");
    private List<IButtonEventListener> buttonEvents = Lists.newArrayList();
    private boolean active = true;
    protected String displayString;

    public WidgetButton(int x, int y, int width, int height) {
        this(x, y, 0, 0, width, height);
    }

    public WidgetButton(int x, int y, int width, int height, IButtonEventListener ... events) {
        this(x, y, 0, 0, width, height, events);
    }

    public WidgetButton(int x, int y, int u, int v, int width, int height) {
        super(x, y, u, v, width, height);
    }

    public WidgetButton(int x, int y, int u, int v, int width, int height, IButtonEventListener ... events) {
        this(x, y, u, v, width, height);
        Collections.addAll(this.buttonEvents, events);
    }

    public WidgetButton setDisplayString(String s) {
        this.displayString = s;
        return this;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public boolean isActive() {
        return this.active;
    }

    @Override
    public final boolean mouseClicked(int mouseX, int mouseY, int button) {
        if (this.isMouseOver(mouseX, mouseY) && this.active) {
            this.onButtonClicked();
            this.sendNBTChangesToServer(new NBTHelper().addToTag(1, "id").serializeNBT());
            return true;
        }
        return false;
    }

    @Override
    public void readNBTChangesFromPacketServerSide(NBTTagCompound tagCompound) {
        if (tagCompound.func_74762_e("id") == 1) {
            this.onButtonClicked();
        }
    }

    public void onButtonClicked() {
        this.sendButtonEvents();
    }

    @Override
    public void draw(Window gui, int guiX, int guiY, int mouseX, int mouseY) {
        if (!this.isHidden()) {
            GlStateManager.func_179094_E();
            FontRenderer fontrenderer = Minecraft.func_71410_x().field_71466_p;
            this.bindTexture(buttonTextures);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            boolean hovering = this.isMouseOver(mouseX, mouseY);
            int k = this.getHoverState(hovering);
            GL11.glEnable((int)3042);
            OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
            GL11.glBlendFunc((int)770, (int)771);
            GuiDraw.drawTexturedModalRect(guiX + this.x, guiY + this.y, 0, 46 + k * 20, this.width / 2, this.height / 2);
            GuiDraw.drawTexturedModalRect(guiX + this.x, guiY + this.y + this.height / 2, 0, 46 + k * 20 + 20 - this.height / 2, this.width / 2, this.height / 2);
            GuiDraw.drawTexturedModalRect(guiX + this.x + this.width / 2, guiY + this.y, 200 - this.width / 2, 46 + k * 20, this.width / 2, this.height / 2);
            GuiDraw.drawTexturedModalRect(guiX + this.x + this.width / 2, guiY + this.y + this.height / 2, 200 - this.width / 2, 46 + k * 20 + 20 - this.height / 2, this.width / 2, this.height / 2);
            int l = 0xE0E0E0;
            if (!this.active) {
                l = 0xA0A0A0;
            } else if (hovering) {
                l = 0xFFFFA0;
            }
            GuiDraw.drawCenteredString(fontrenderer, this.displayString, guiX + this.x + this.width / 2, guiY + this.y + (this.height - 8) / 2, l);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179121_F();
        }
    }

    protected int getHoverState(boolean hovering) {
        int b = 1;
        if (!this.active) {
            b = 0;
        } else if (hovering) {
            b = 2;
        }
        return b;
    }

    public void sendButtonEvents() {
        for (IButtonEventListener event : this.buttonEvents) {
            event.onButtonClicked(this);
        }
    }

    public WidgetButton addButtonEvent(IButtonEventListener event) {
        if (!this.buttonEvents.contains(event)) {
            this.buttonEvents.add(event);
        }
        return this;
    }

    public void removeButtonEvent(IButtonEventListener event) {
        this.buttonEvents.remove(event);
    }

    public void clearEvents() {
        this.buttonEvents.clear();
    }

    public static interface IButtonEventListener {
        public void onButtonClicked(WidgetButton var1);
    }
}

