/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.inventory;

import com.google.common.collect.Lists;
import elec332.core.inventory.IWidgetContainer;
import elec332.core.inventory.slot.SlotOutput;
import elec332.core.inventory.widget.IWidget;
import elec332.core.util.InventoryHelper;
import elec332.core.util.ItemStackHelper;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class BaseContainer
extends Container
implements IWidgetContainer {
    protected final EntityPlayer thePlayer;
    protected final List<IWidget> widgets;
    private int offset;
    private int hotBarFactor = 0;
    private int playerInvIndexStart = 0;
    private int playerInvIndexStop = 0;

    BaseContainer(EntityPlayer player, int offset) {
        this(player);
        this.offset = offset;
    }

    BaseContainer(EntityPlayer player) {
        this.thePlayer = player;
        this.offset = 0;
        this.widgets = Lists.newArrayList();
    }

    @Override
    public List<IWidget> getWidgets() {
        return this.widgets;
    }

    @Override
    public <W extends IWidget> W addWidget(W widget) {
        widget.setContainer(this);
        widget.setID(this.widgets.size());
        Iterator iterator = this.field_75149_d.iterator();
        if (iterator.hasNext()) {
            Object obj = iterator.next();
            throw new RuntimeException();
        }
        this.widgets.add(widget);
        return widget;
    }

    public void addPlayerInventoryToContainer() {
        int i;
        this.playerInvIndexStart = this.field_75151_b.size();
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)this.thePlayer.field_71071_by, j + i * 9 + 9, 8 + j * 18, 84 + this.offset + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.func_75146_a(new Slot((IInventory)this.thePlayer.field_71071_by, i, 8 + i * 18, 142 + this.offset + this.hotBarFactor()));
        }
        this.playerInvIndexStop = this.field_75151_b.size();
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public void func_75132_a(IContainerListener iCrafting) {
        Iterator<IWidget> iterator = this.widgets.iterator();
        if (iterator.hasNext()) {
            IWidget widget = iterator.next();
            throw new RuntimeException();
        }
        super.func_75132_a(iCrafting);
    }

    public void func_75142_b() {
        super.func_75142_b();
        Iterator<IWidget> iterator = this.widgets.iterator();
        if (iterator.hasNext()) {
            IWidget widget = iterator.next();
            throw new RuntimeException();
        }
    }

    @Nonnull
    public ItemStack func_82846_b(EntityPlayer player, int slotID) {
        ItemStack itemstack = ItemStackHelper.NULL_STACK;
        Slot slot = this.func_75139_a(slotID);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            if (slot instanceof SlotOutput) {
                if (!this.func_75135_a(itemstack1, this.playerInvIndexStart, this.playerInvIndexStop, true)) {
                    return ItemStackHelper.NULL_STACK;
                }
                slot.func_75220_a(itemstack1, itemstack);
            } else if (slotID >= this.playerInvIndexStart && slotID <= this.playerInvIndexStop) {
                for (int i = 0; i < this.playerInvIndexStart; ++i) {
                    Slot slot1 = this.func_75139_a(i);
                    if (!slot1.func_75214_a(itemstack1) || this.func_75135_a(itemstack1, i, i + 1, false)) continue;
                    if (itemstack1.field_77994_a < 1) {
                        this.func_75141_a(slotID, ItemStackHelper.NULL_STACK);
                    }
                    return ItemStackHelper.NULL_STACK;
                }
                if (slotID >= this.playerInvIndexStart && slotID < this.playerInvIndexStop - 9) {
                    if (!this.func_75135_a(itemstack1, this.playerInvIndexStop - 9, this.playerInvIndexStop, false)) {
                        if (itemstack1.field_77994_a < 1) {
                            this.func_75141_a(slotID, ItemStackHelper.NULL_STACK);
                        }
                        return ItemStackHelper.NULL_STACK;
                    }
                } else if (slotID >= this.playerInvIndexStop - 9 && slotID < this.playerInvIndexStop && !this.func_75135_a(itemstack1, this.playerInvIndexStart, this.playerInvIndexStop - 9, false)) {
                    if (itemstack1.field_77994_a < 1) {
                        this.func_75141_a(slotID, ItemStackHelper.NULL_STACK);
                    }
                    return ItemStackHelper.NULL_STACK;
                }
            } else if (!this.func_75135_a(itemstack1, this.playerInvIndexStart, this.playerInvIndexStop, false)) {
                return ItemStackHelper.NULL_STACK;
            }
            if (itemstack1.field_77994_a == 0) {
                slot.func_75215_d(ItemStackHelper.NULL_STACK);
            } else {
                slot.func_75218_e();
            }
            if (itemstack1.field_77994_a == itemstack.field_77994_a) {
                return ItemStackHelper.NULL_STACK;
            }
            InventoryHelper.onPickupFromSlot(slot, player, itemstack1);
        }
        return itemstack;
    }

    public Slot func_75146_a(Slot slot) {
        return super.func_75146_a(slot);
    }

    public void setHotBarFactor(int hotBarFactor) {
        this.hotBarFactor = hotBarFactor;
    }

    protected int hotBarFactor() {
        return this.hotBarFactor;
    }

    public void func_75137_b(int id, int value) {
        this.widgets.get(id).updateProgressbar(value);
    }

    public boolean func_75145_c(EntityPlayer player) {
        return true;
    }
}

