/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.asm;

import com.google.common.collect.Lists;
import elec332.core.api.APIHandlerInject;
import elec332.core.api.discovery.IASMDataHelper;
import elec332.core.api.discovery.IAdvancedASMData;
import elec332.core.asm.ASMTransformer;
import elec332.core.asm.IASMClassTransformer;
import java.util.List;
import net.minecraft.launchwrapper.IClassTransformer;

public final class ASMLoader
implements IClassTransformer {
    private static final List<IASMClassTransformer> classTransformers = Lists.newArrayList();
    private static boolean collected;

    @APIHandlerInject
    public static void collectTransformers(IASMDataHelper data) {
        for (IAdvancedASMData asmData : data.getAdvancedAnnotationList(ASMTransformer.class)) {
            Class<?> clazz = asmData.loadClass();
            if (!IASMClassTransformer.class.isAssignableFrom(clazz)) continue;
            try {
                classTransformers.add((IASMClassTransformer)clazz.newInstance());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        collected = true;
    }

    public byte[] transform(String obf, String deobf, byte[] bytes) {
        for (IASMClassTransformer classTransformer : classTransformers) {
            if (!deobf.contains(classTransformer.getDeObfuscatedClassName())) continue;
            bytes = classTransformer.transformClass(bytes);
        }
        return bytes;
    }

    public static void injectEarly(IASMClassTransformer transformer) {
        if (collected) {
            throw new UnsupportedOperationException();
        }
        classTransformers.add(transformer);
    }
}

