/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.endertanks.modintegration.waila;

import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.api.IWailaRegistrar;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import shetiphian.endertanks.Values;
import shetiphian.endertanks.common.block.BlockEnderTank;
import shetiphian.endertanks.common.misc.TankHelper;
import shetiphian.endertanks.common.misc.TankInfoHelper;
import shetiphian.endertanks.common.tileentity.TileEntityEnderTank;

public class WailaDataProvider
implements IWailaDataProvider {
    private static final WailaDataProvider INSTANCE = new WailaDataProvider();

    public ItemStack getWailaStack(IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return null;
    }

    public List<String> getWailaHead(ItemStack stack, List<String> tooltip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return tooltip;
    }

    public List<String> getWailaBody(ItemStack stack, List<String> tooltip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        if (config.getConfig("endertanks.showtankdata") && accessor.getTileEntity() instanceof TileEntityEnderTank) {
            NBTTagCompound tag = accessor.getNBTData();
            FluidStack fluidStack = null;
            if (tag.func_74764_b("fluid")) {
                NBTTagCompound fluid = tag.func_74775_l("fluid");
                fluidStack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)fluid);
            }
            TankInfoHelper.wailaGetTankInfo(tooltip, (TileEntityEnderTank)accessor.getTileEntity(), fluidStack, tag.func_74762_e("capacity"));
        }
        return tooltip;
    }

    public List<String> getWailaTail(ItemStack stack, List<String> tooltip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return tooltip;
    }

    public NBTTagCompound getNBTData(EntityPlayerMP player, TileEntity tile, NBTTagCompound tag, World world, BlockPos pos) {
        if (tile instanceof TileEntityEnderTank) {
            String code;
            TileEntityEnderTank tankTile = (TileEntityEnderTank)tile;
            String owner = tankTile.getOwnerID();
            FluidStack fluidStack = TankHelper.getTank(owner, code = tankTile.getCode(), tile.func_145831_w().field_72995_K).getFluid();
            if (fluidStack != null) {
                NBTTagCompound fluid = new NBTTagCompound();
                fluidStack.writeToNBT(fluid);
                tag.func_74782_a("fluid", (NBTBase)fluid);
            }
            tag.func_74768_a("capacity", TankHelper.getTank(owner, code, tile.func_145831_w().field_72995_K).getCapacity());
        }
        return tag;
    }

    public static void callbackRegister(IWailaRegistrar registrar) {
        if (Values.blockEnderTank != null) {
            registrar.addConfigRemote("EnderTanks", "endertanks.showtankdata", "Show Tank Data");
            registrar.registerBodyProvider((IWailaDataProvider)INSTANCE, TileEntityEnderTank.class);
            registrar.registerNBTProvider((IWailaDataProvider)INSTANCE, BlockEnderTank.class);
        }
    }
}

