/*
 * Decompiled with CFR 0.152.
 */
package mod.flatcoloredblocks.client;

import java.util.HashMap;
import java.util.Map;
import mod.flatcoloredblocks.FlatColoredBlocks;
import mod.flatcoloredblocks.block.BlockFlatColored;
import mod.flatcoloredblocks.block.EnumFlatBlockType;
import mod.flatcoloredblocks.client.IClientSide;
import mod.flatcoloredblocks.craftingitem.ItemColoredBlockCrafter;
import mod.flatcoloredblocks.model.ModelGenerator;
import mod.flatcoloredblocks.textures.TextureGenerator;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;

public class ClientSide
implements IClientSide {
    public static final ClientSide instance = new ClientSide();
    public TextureGenerator textureGenerator = new TextureGenerator();
    public ModelGenerator modelGenerator = new ModelGenerator();

    private ClientSide() {
    }

    @Override
    public void preinit() {
        this.modelGenerator.preinit();
        MinecraftForge.EVENT_BUS.register((Object)this.textureGenerator);
        MinecraftForge.EVENT_BUS.register((Object)this.modelGenerator);
    }

    @Override
    public void init() {
        Minecraft.func_71410_x().getItemColors().func_186731_a(new IItemColor(){

            public int func_186726_a(ItemStack stack, int tintIndex) {
                Block blk = Block.func_149634_a((Item)stack.func_77973_b());
                return ((BlockFlatColored)blk).colorFromState(blk.func_176203_a(stack.func_77960_j()));
            }
        }, BlockFlatColored.getAllBlocks().toArray(new Block[BlockFlatColored.getAllBlocks().size()]));
        Minecraft.func_71410_x().func_184125_al().func_186722_a(new IBlockColor(){

            public int func_186720_a(IBlockState state, IBlockAccess p_186720_2_, BlockPos pos, int tintIndex) {
                return ((BlockFlatColored)state.func_177230_c()).colorFromState(state);
            }
        }, BlockFlatColored.getAllBlocks().toArray(new Block[BlockFlatColored.getAllBlocks().size()]));
    }

    @Override
    public void configureCraftingRender(ItemColoredBlockCrafter icbc) {
        ModelLoader.setCustomModelResourceLocation((Item)icbc, (int)0, (ModelResourceLocation)new ModelResourceLocation("flatcoloredblocks:coloredcraftingitem", "inventory"));
    }

    @Override
    public void configureBlockRender(final BlockFlatColored cb) {
        String flatcoloredblocks_name = this.getTextureName(cb.getType(), cb.getVarient());
        final ModelResourceLocation flatcoloredblocks_block = new ModelResourceLocation(flatcoloredblocks_name, "normal");
        ModelResourceLocation flatcoloredblocks_item = new ModelResourceLocation(flatcoloredblocks_name, "inventory");
        ModelLoader.setCustomStateMapper((Block)cb, (IStateMapper)new IStateMapper(){

            public Map<IBlockState, ModelResourceLocation> func_178130_a(Block blockIn) {
                HashMap<IBlockState, ModelResourceLocation> loc = new HashMap<IBlockState, ModelResourceLocation>();
                for (int x = cb.getShadeOffset(); x <= cb.getMaxShade(); ++x) {
                    loc.put(cb.func_176223_P().func_177226_a(cb.getShade(), (Comparable)Integer.valueOf(x - cb.getShadeOffset())), flatcoloredblocks_block);
                }
                return loc;
            }
        });
        Item cbi = Item.func_150898_a((Block)cb);
        ModelBakery.registerItemVariants((Item)cbi, (ResourceLocation[])new ResourceLocation[]{flatcoloredblocks_block});
        for (int z = 0; z < 16; ++z) {
            ModelLoader.setCustomModelResourceLocation((Item)cbi, (int)z, (ModelResourceLocation)flatcoloredblocks_item);
        }
    }

    public String getTextureName(EnumFlatBlockType type, int varient) {
        if (!FlatColoredBlocks.instance.config.GLOWING_EMITS_LIGHT && type == EnumFlatBlockType.GLOWING) {
            return this.getBaseTextureName(type) + "_" + varient;
        }
        if (type == EnumFlatBlockType.TRANSPARENT) {
            return this.getBaseTextureName(type) + "_" + varient;
        }
        return this.getBaseTextureName(type);
    }

    public String getBaseTextureName(EnumFlatBlockType type) {
        return "flatcoloredblocks:flatcoloredblock_" + this.getTextureFor(type).name();
    }

    public String getBaseTextureNameWithBlocks(EnumFlatBlockType type) {
        return "flatcoloredblocks:blocks/flatcoloredblock_" + this.getTextureFor(type).name();
    }

    public ResourceLocation getTextureResourceLocation(EnumFlatBlockType type) {
        return new ResourceLocation("flatcoloredblocks", "textures/blocks/flatcoloredblock_" + this.getTextureFor(type).name() + ".png");
    }

    private Enum<?> getTextureFor(EnumFlatBlockType type) {
        switch (type) {
            case GLOWING: {
                return FlatColoredBlocks.instance.config.DISPLAY_TEXTURE_GLOWING;
            }
            case TRANSPARENT: {
                return FlatColoredBlocks.instance.config.DISPLAY_TEXTURE_TRANSPARENT;
            }
        }
        return FlatColoredBlocks.instance.config.DISPLAY_TEXTURE;
    }
}

