/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.mirror;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Stream;
import net.shadowfacts.mirror.MirrorClass;
import net.shadowfacts.mirror.MirrorConstructor;
import net.shadowfacts.mirror.MirrorEnum;
import net.shadowfacts.mirror.MirrorField;
import net.shadowfacts.mirror.MirrorMethod;
import net.shadowfacts.mirror.scanner.Scanner;
import net.shadowfacts.mirror.scanner.cls.JarScanner;
import net.shadowfacts.mirror.scanner.cls.PackageScanner;
import net.shadowfacts.mirror.stream.ClassStream;
import net.shadowfacts.mirror.stream.FieldStream;
import net.shadowfacts.mirror.stream.MethodStream;

public class Mirror {
    public static <T> MirrorClass<T> of(Class<T> clazz) {
        return new MirrorClass<T>(clazz);
    }

    public static ClassStream ofAll(Stream<MirrorClass<?>> classes) {
        return new ClassStream(classes);
    }

    public static ClassStream ofAll(Collection<MirrorClass<?>> classes) {
        return Mirror.ofAll(classes.stream());
    }

    public static ClassStream ofAll(MirrorClass<?> ... classes) {
        return Mirror.ofAll(Arrays.stream(classes));
    }

    public static ClassStream ofAllUnwrapped(Stream<Class<?>> classes) {
        return Mirror.ofAll(classes.map(Mirror::of));
    }

    public static ClassStream ofAllUnwrapped(Collection<Class<?>> classes) {
        return Mirror.ofAllUnwrapped(classes.stream());
    }

    public static <I> ClassStream ofAllUnwrapped(Scanner<Class<?>, I> scanner, I input) {
        return Mirror.ofAllUnwrapped(scanner.scan(input));
    }

    public static ClassStream ofAllUnwrapped(Class<?> ... classes) {
        return Mirror.ofAllUnwrapped(Arrays.stream(classes));
    }

    public static ClassStream ofAllInPackage(String thePackage) {
        return Mirror.ofAllUnwrapped(PackageScanner.instance, thePackage);
    }

    public static ClassStream ofAllInJar(File jar, ClassLoader classLoader) {
        return Mirror.ofAllUnwrapped(JarScanner.instance, new JarScanner.JarScannerOptions(jar, classLoader));
    }

    public static ClassStream ofAllInJar(File jar) {
        return Mirror.ofAllInJar(jar, Thread.currentThread().getContextClassLoader());
    }

    public static <E extends Enum<E>> MirrorEnum<E> ofEnum(Class<E> clazz) {
        return new MirrorEnum<E>(clazz);
    }

    public static MirrorField of(Field f) {
        return new MirrorField(f);
    }

    public static FieldStream ofAllFields(Stream<MirrorField> fields) {
        return new FieldStream(fields);
    }

    public static FieldStream ofAllFields(Collection<MirrorField> fields) {
        return Mirror.ofAllFields(fields.stream());
    }

    public static FieldStream ofAllFields(MirrorField ... fields) {
        return Mirror.ofAllFields(Arrays.stream(fields));
    }

    public static FieldStream ofAllUnwrappedFields(Stream<Field> fields) {
        return Mirror.ofAllFields(fields.map(MirrorField::new));
    }

    public static FieldStream ofAllUnwrappedFields(Collection<Field> fields) {
        return Mirror.ofAllUnwrappedFields(fields.stream());
    }

    public static <I> FieldStream ofAllUnwrappedFields(Scanner<Field, I> scanner, I input) {
        return Mirror.ofAllUnwrappedFields(scanner.scan(input));
    }

    public static FieldStream ofAllUnwrappedFields(Field ... fields) {
        return Mirror.ofAllUnwrappedFields(Arrays.stream(fields));
    }

    public static MirrorMethod of(Method m) {
        return new MirrorMethod(m);
    }

    public static MethodStream ofAllMethods(Stream<MirrorMethod> methods) {
        return new MethodStream(methods);
    }

    public static MethodStream ofAllMethods(Collection<MirrorMethod> methods) {
        return Mirror.ofAllMethods(methods.stream());
    }

    public static MethodStream ofAllMethods(MirrorMethod ... methods) {
        return Mirror.ofAllMethods(Arrays.stream(methods));
    }

    public static MethodStream ofAllUnwrappedMethods(Stream<Method> methods) {
        return Mirror.ofAllMethods(methods.map(MirrorMethod::new));
    }

    public static MethodStream ofAllUnwrappedMethods(Collection<Method> methods) {
        return Mirror.ofAllUnwrappedMethods(methods.stream());
    }

    public static <I> MethodStream ofAllUnwrappedMethods(Scanner<Method, I> scanner, I input) {
        return Mirror.ofAllUnwrappedMethods(scanner.scan(input));
    }

    public static MethodStream ofAllUnwrappedMethods(Method ... methods) {
        return Mirror.ofAllUnwrappedMethods(Arrays.stream(methods));
    }

    public static <T> MirrorConstructor<T> of(Constructor<T> constructor) {
        return new MirrorConstructor<T>(constructor);
    }
}

