/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.ritual;

import WayofTime.bloodmagic.api.BlockStack;
import WayofTime.bloodmagic.api.ritual.AreaDescriptor;
import WayofTime.bloodmagic.api.ritual.EnumRuneType;
import WayofTime.bloodmagic.api.ritual.IMasterRitualStone;
import WayofTime.bloodmagic.api.ritual.Ritual;
import WayofTime.bloodmagic.api.ritual.RitualComponent;
import WayofTime.bloodmagic.util.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockOre;
import net.minecraft.block.BlockRedstoneOre;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;

public class RitualMagnetic
extends Ritual {
    private static final Map<BlockStack, Boolean> oreBlockCache = new HashMap<BlockStack, Boolean>();
    public static final String PLACEMENT_RANGE = "placementRange";
    public BlockPos lastPos;

    public RitualMagnetic() {
        super("ritualMagnetic", 0, 5000, "ritual.BloodMagic.magneticRitual");
        this.addBlockRange(PLACEMENT_RANGE, new AreaDescriptor.Rectangle(new BlockPos(-1, 1, -1), 3));
        this.setMaximumVolumeAndDistanceOfRange(PLACEMENT_RANGE, 50, 4, 4);
    }

    public static boolean isBlockOre(Block block, int meta) {
        if (block == null) {
            return false;
        }
        if (block instanceof BlockOre || block instanceof BlockRedstoneOre) {
            return true;
        }
        if (Item.func_150898_a((Block)block) == null) {
            return false;
        }
        BlockStack type = new BlockStack(block, meta);
        Boolean result = oreBlockCache.get(type);
        if (result == null) {
            result = RitualMagnetic.computeIsItemOre(type);
            oreBlockCache.put(type, result);
        }
        return result;
    }

    private static boolean computeIsItemOre(BlockStack type) {
        ItemStack stack = new ItemStack(type.getBlock(), type.getMeta());
        return RitualMagnetic.isBlockOre(stack);
    }

    public static boolean isBlockOre(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        for (int id : OreDictionary.getOreIDs((ItemStack)stack)) {
            String oreName = OreDictionary.getOreName((int)id);
            if (!oreName.contains("ore")) continue;
            return true;
        }
        return false;
    }

    @Override
    public void performRitual(IMasterRitualStone masterRitualStone) {
        World world = masterRitualStone.getWorldObj();
        int currentEssence = masterRitualStone.getOwnerNetwork().getCurrentEssence();
        if (currentEssence < this.getRefreshCost()) {
            masterRitualStone.getOwnerNetwork().causeNausea();
            return;
        }
        BlockPos pos = masterRitualStone.getBlockPos();
        AreaDescriptor placementRange = this.getBlockRange(PLACEMENT_RANGE);
        BlockPos replacement = pos;
        boolean replace = false;
        for (BlockPos offset : placementRange.getContainedPositions(pos)) {
            if (!world.func_175623_d(offset)) continue;
            replacement = offset;
            replace = true;
            break;
        }
        IBlockState downState = world.func_180495_p(pos.func_177977_b());
        Block downBlock = downState.func_177230_c();
        int radius = this.getRadius(downBlock);
        if (replace) {
            int j = -1;
            int i = -radius;
            int k = -radius;
            if (this.lastPos != null) {
                j = this.lastPos.func_177956_o();
                i = Math.min(radius, Math.max(-radius, this.lastPos.func_177958_n()));
                k = Math.min(radius, Math.max(-radius, this.lastPos.func_177952_p()));
            }
            if (j + pos.func_177956_o() >= 0) {
                while (i <= radius) {
                    while (k <= radius) {
                        BlockPos newPos = pos.func_177982_a(i, j, k);
                        IBlockState state = world.func_180495_p(newPos);
                        Block block = state.func_177230_c();
                        ItemStack checkStack = block.func_185473_a(world, newPos, state);
                        if (RitualMagnetic.isBlockOre(checkStack)) {
                            Utils.swapLocations(world, newPos, world, replacement);
                            masterRitualStone.getOwnerNetwork().syphon(this.getRefreshCost());
                            this.lastPos = new BlockPos(i, j, ++k);
                            return;
                        }
                        ++k;
                    }
                    ++i;
                    k = -radius;
                }
                i = -radius;
                this.lastPos = new BlockPos(i, --j, k);
                return;
            }
            j = -1;
            this.lastPos = new BlockPos(i, j, k);
            return;
        }
    }

    public int getRadius(Block block) {
        if (block == Blocks.field_150339_S) {
            return 7;
        }
        if (block == Blocks.field_150340_R) {
            return 15;
        }
        if (block == Blocks.field_150484_ah) {
            return 31;
        }
        return 3;
    }

    @Override
    public int getRefreshTime() {
        return 40;
    }

    @Override
    public int getRefreshCost() {
        return 50;
    }

    @Override
    public ArrayList<RitualComponent> getComponents() {
        ArrayList<RitualComponent> components = new ArrayList<RitualComponent>();
        this.addCornerRunes(components, 1, 0, EnumRuneType.EARTH);
        this.addParallelRunes(components, 2, 1, EnumRuneType.EARTH);
        this.addCornerRunes(components, 2, 1, EnumRuneType.AIR);
        this.addParallelRunes(components, 2, 2, EnumRuneType.FIRE);
        return components;
    }

    @Override
    public Ritual getNewCopy() {
        return new RitualMagnetic();
    }
}

