/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.compat.guideapi.book;

import WayofTime.bloodmagic.api.registry.AltarRecipeRegistry;
import WayofTime.bloodmagic.api.ritual.EnumRuneType;
import WayofTime.bloodmagic.compat.guideapi.BookUtils;
import WayofTime.bloodmagic.compat.guideapi.entry.EntryText;
import WayofTime.bloodmagic.compat.guideapi.page.PageAltarRecipe;
import WayofTime.bloodmagic.registry.ModBlocks;
import WayofTime.bloodmagic.registry.ModItems;
import WayofTime.bloodmagic.util.helper.RecipeHelper;
import WayofTime.bloodmagic.util.helper.TextHelper;
import amerifrance.guideapi.api.IPage;
import amerifrance.guideapi.api.impl.abstraction.EntryAbstract;
import amerifrance.guideapi.api.util.PageHelper;
import amerifrance.guideapi.page.PageText;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;

public class CategoryRitual {
    static String keyBase = "guide.BloodMagic.entry.ritual.";

    public static Map<ResourceLocation, EntryAbstract> buildCategory() {
        LinkedHashMap<ResourceLocation, EntryAbstract> entries = new LinkedHashMap<ResourceLocation, EntryAbstract>();
        CategoryRitual.addRitualPagesToEntries("intro", entries);
        CategoryRitual.addRitualPagesToEntries("basics", entries);
        ArrayList<IPage> ritualStonePages = new ArrayList<IPage>();
        IRecipe ritualStoneRecipe = RecipeHelper.getRecipeForOutput(new ItemStack(ModBlocks.RITUAL_STONE));
        if (ritualStoneRecipe != null) {
            ritualStonePages.add((IPage)BookUtils.getPageForRecipe(ritualStoneRecipe));
        }
        ritualStonePages.addAll(PageHelper.pagesForLongText((String)TextHelper.localize(keyBase + "ritualStone.info.1", new Object[0]), (int)370));
        for (int i = 1; i < 5; ++i) {
            EnumRuneType type = EnumRuneType.values()[i];
            AltarRecipeRegistry.AltarRecipe scribeRecipe = RecipeHelper.getAltarRecipeForOutput(type.getScribeStack());
            if (scribeRecipe == null) continue;
            ritualStonePages.add((IPage)new PageAltarRecipe(scribeRecipe));
        }
        ritualStonePages.addAll(PageHelper.pagesForLongText((String)TextHelper.localize(keyBase + "ritualStone.info.2", new Object[0]), (int)370));
        entries.put(new ResourceLocation(keyBase + "ritualStone"), (EntryAbstract)new EntryText(ritualStonePages, TextHelper.localize(keyBase + "ritualStone", new Object[0]), true));
        ArrayList<IPage> masterRitualStonePages = new ArrayList<IPage>();
        IRecipe masterRitualStoneRecipe = RecipeHelper.getRecipeForOutput(new ItemStack(ModBlocks.RITUAL_CONTROLLER, 1, 0));
        if (masterRitualStoneRecipe != null) {
            masterRitualStonePages.add((IPage)BookUtils.getPageForRecipe(masterRitualStoneRecipe));
        }
        masterRitualStonePages.addAll(PageHelper.pagesForLongText((String)TextHelper.localize(keyBase + "masterRitualStone.info", new Object[0]), (int)370));
        entries.put(new ResourceLocation(keyBase + "masterRitualStone"), (EntryAbstract)new EntryText(masterRitualStonePages, TextHelper.localize(keyBase + "masterRitualStone", new Object[0]), true));
        ArrayList<IPage> activationCrystalPages = new ArrayList<IPage>();
        activationCrystalPages.addAll(PageHelper.pagesForLongText((String)TextHelper.localize(keyBase + "activationCrystal.info.1", new Object[0]), (int)370));
        AltarRecipeRegistry.AltarRecipe crystalRecipe = RecipeHelper.getAltarRecipeForOutput(new ItemStack(ModItems.ACTIVATION_CRYSTAL));
        if (crystalRecipe != null) {
            activationCrystalPages.add((IPage)new PageAltarRecipe(crystalRecipe));
        }
        activationCrystalPages.addAll(PageHelper.pagesForLongText((String)TextHelper.localize(keyBase + "activationCrystal.info.2", new Object[0]), (int)370));
        entries.put(new ResourceLocation(keyBase + "activationCrystal"), (EntryAbstract)new EntryText(activationCrystalPages, TextHelper.localize(keyBase + "activationCrystal", new Object[0]), true));
        ArrayList<IPage> divinerPages = new ArrayList<IPage>();
        divinerPages.addAll(PageHelper.pagesForLongText((String)TextHelper.localize(keyBase + "diviner.info.1", new Object[0]), (int)370));
        IRecipe divinerRecipe = RecipeHelper.getRecipeForOutput(new ItemStack(ModItems.RITUAL_DIVINER));
        if (divinerRecipe != null) {
            divinerPages.add((IPage)BookUtils.getPageForRecipe(divinerRecipe));
        }
        divinerPages.addAll(PageHelper.pagesForLongText((String)TextHelper.localize(keyBase + "diviner.info.2", new Object[0]), (int)370));
        entries.put(new ResourceLocation(keyBase + "diviner"), (EntryAbstract)new EntryText(divinerPages, TextHelper.localize(keyBase + "diviner", new Object[0]), true));
        CategoryRitual.addRitualPagesToEntries("fullSpring", entries);
        CategoryRitual.addRitualPagesToEntries("lava", entries);
        CategoryRitual.addRitualPagesToEntries("greenGrove", entries);
        CategoryRitual.addRitualPagesToEntries("magnetism", entries);
        CategoryRitual.addRitualPagesToEntries("crusher", entries);
        CategoryRitual.addRitualPagesToEntries("highJump", entries);
        CategoryRitual.addRitualPagesToEntries("speed", entries);
        CategoryRitual.addRitualPagesToEntries("wellOfSuffering", entries);
        CategoryRitual.addRitualPagesToEntries("featheredKnife", entries);
        CategoryRitual.addRitualPagesToEntries("regen", entries);
        CategoryRitual.addRitualPagesToEntries("harvest", entries);
        CategoryRitual.addRitualPagesToEntries("interdiction", entries);
        CategoryRitual.addRitualPagesToEntries("containment", entries);
        CategoryRitual.addRitualPagesToEntries("suppression", entries);
        CategoryRitual.addRitualPagesToEntries("expulsion", entries);
        CategoryRitual.addRitualPagesToEntries("zephyr", entries);
        CategoryRitual.addRitualPagesToEntries("laying", entries);
        CategoryRitual.addRitualPagesToEntries("timberman", entries);
        CategoryRitual.addRitualPagesToEntries("meteor", entries);
        CategoryRitual.addRitualPagesToEntries("downgrade", entries);
        for (Map.Entry entry : entries.entrySet()) {
            for (IPage page : ((EntryAbstract)entry.getValue()).pageList) {
                if (!(page instanceof PageText)) continue;
                ((PageText)page).setUnicodeFlag(true);
            }
        }
        return entries;
    }

    public static void addRitualPagesToEntries(String name, Map<ResourceLocation, EntryAbstract> entries) {
        ArrayList<IPage> pages = new ArrayList<IPage>();
        pages.addAll(PageHelper.pagesForLongText((String)TextHelper.localize(keyBase + name + ".info", new Object[0]), (int)370));
        entries.put(new ResourceLocation(keyBase + name), (EntryAbstract)new EntryText(pages, TextHelper.localize(keyBase + name, new Object[0]), true));
    }
}

