/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.relic;

import baubles.api.BaubleType;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.stats.Achievement;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.RecipeSorter;
import vazkii.botania.api.item.IWireframeCoordinateListProvider;
import vazkii.botania.common.achievement.ICraftAchievement;
import vazkii.botania.common.achievement.ModAchievements;
import vazkii.botania.common.core.handler.MethodHandles;
import vazkii.botania.common.crafting.recipe.AesirRingRecipe;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.item.relic.ItemOdinRing;
import vazkii.botania.common.item.relic.ItemRelicBauble;

public class ItemAesirRing
extends ItemRelicBauble
implements IWireframeCoordinateListProvider,
ICraftAchievement {
    private final Multimap<String, AttributeModifier> attributes = HashMultimap.create();

    public ItemAesirRing() {
        super("aesirRing");
        GameRegistry.addRecipe((IRecipe)new AesirRingRecipe());
        RecipeSorter.register((String)"botania:aesirRing", AesirRingRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"");
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onDropped(ItemTossEvent event) {
        ItemStack stack;
        if (event.getEntityItem() != null && event.getEntityItem().func_92059_d() != null && !event.getEntityItem().field_70170_p.field_72995_K && (stack = event.getEntityItem().func_92059_d()).func_77973_b() != null && stack.func_77973_b() == this) {
            event.getEntityItem().func_70106_y();
            UUID user = this.getSoulbindUUID(stack);
            for (Item item : new Item[]{ModItems.thorRing, ModItems.lokiRing, ModItems.odinRing}) {
                ItemStack stack1 = new ItemStack(item);
                this.bindToUUID(user, stack1);
                EntityItem entity = new EntityItem(event.getEntityItem().field_70170_p, event.getEntityItem().field_70165_t, event.getEntityItem().field_70163_u, event.getEntityItem().field_70161_v, stack1);
                entity.field_70159_w = event.getEntityItem().field_70159_w;
                entity.field_70181_x = event.getEntityItem().field_70181_x;
                entity.field_70179_y = event.getEntityItem().field_70179_y;
                try {
                    MethodHandles.itemAge_setter.invokeExact(entity, MethodHandles.itemAge_getter.invokeExact(entity));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                int pickupDelay = 0;
                try {
                    pickupDelay = MethodHandles.pickupDelay_getter.invokeExact(event.getEntityItem());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                entity.func_174867_a(pickupDelay);
                entity.field_70170_p.func_72838_d((Entity)entity);
            }
        }
    }

    @Override
    public void onValidPlayerWornTick(ItemStack stack, EntityPlayer player) {
        ((ItemOdinRing)ModItems.odinRing).onValidPlayerWornTick(stack, player);
    }

    public BaubleType getBaubleType(ItemStack arg0) {
        return BaubleType.RING;
    }

    @Override
    public List<BlockPos> getWireframesToDraw(EntityPlayer player, ItemStack stack) {
        return ((IWireframeCoordinateListProvider)ModItems.lokiRing).getWireframesToDraw(player, stack);
    }

    @Override
    public BlockPos getSourceWireframe(EntityPlayer player, ItemStack stack) {
        return ((IWireframeCoordinateListProvider)ModItems.lokiRing).getSourceWireframe(player, stack);
    }

    @Override
    public void onEquippedOrLoadedIntoWorld(ItemStack stack, EntityLivingBase player) {
        this.attributes.clear();
        this.fillModifiers(this.attributes, stack);
        player.func_110140_aT().func_111147_b(this.attributes);
    }

    @Override
    public void onUnequipped(ItemStack stack, EntityLivingBase player) {
        this.attributes.clear();
        this.fillModifiers(this.attributes, stack);
        player.func_110140_aT().func_111148_a(this.attributes);
    }

    private void fillModifiers(Multimap<String, AttributeModifier> attributes, ItemStack stack) {
        if (stack == null) {
            return;
        }
        attributes.put((Object)SharedMonsterAttributes.field_111267_a.func_111108_a(), (Object)new AttributeModifier(ItemAesirRing.getBaubleUUID(stack), "Bauble modifier", 20.0, 0));
    }

    @Override
    public Achievement getAchievementOnCraft(ItemStack stack, EntityPlayer player, IInventory matrix) {
        return ModAchievements.relicAesirRing;
    }
}

