/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.subtile.functional;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityCaveSpider;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.monster.SkeletonType;
import net.minecraft.entity.monster.ZombieType;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.lexicon.LexiconEntry;
import vazkii.botania.api.subtile.RadiusDescriptor;
import vazkii.botania.api.subtile.SubTileFunctional;
import vazkii.botania.common.block.subtile.functional.SubTileSpectranthemum;
import vazkii.botania.common.lexicon.LexiconData;

public class SubTileLoonuim
extends SubTileFunctional {
    private static final int COST = 35000;
    private static final int RANGE = 5;
    private static final String TAG_LOOT_TABLE = "lootTable";
    private static final String TAG_ITEMSTACK_TO_DROP = "botania:looniumItemStackToDrop";
    private ResourceLocation lootTable = new ResourceLocation("minecraft", "chests/simple_dungeon");
    private static boolean registered = false;

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (!registered) {
            MinecraftForge.EVENT_BUS.register(DropHandler.class);
            registered = true;
        }
        World world = this.supertile.func_145831_w();
        if (!world.field_72995_K && this.redstoneSignal == 0 && this.ticksExisted % 100 == 0 && this.mana >= 35000) {
            List stacks;
            ItemStack stack;
            Random rand = world.field_73012_v;
            do {
                if (!(stacks = world.func_184146_ak().func_186521_a(this.lootTable).func_186462_a(rand, new LootContext.Builder((WorldServer)world).func_186471_a())).isEmpty()) continue;
                return;
            } while ((stack = (ItemStack)stacks.get(0)) == null || BotaniaAPI.looniumBlacklist.contains(stack.func_77973_b()));
            int bound = 11;
            int xp = this.supertile.func_174877_v().func_177958_n() - 5 + rand.nextInt(bound);
            int yp = this.supertile.func_174877_v().func_177956_o();
            int zp = this.supertile.func_174877_v().func_177952_p() - 5 + rand.nextInt(bound);
            BlockPos pos = new BlockPos(xp, yp - 1, zp);
            do {
                if ((pos = pos.func_177984_a()).func_177956_o() < 254) continue;
                return;
            } while (world.func_180495_p(pos).func_177230_c().func_176214_u());
            pos = pos.func_177984_a();
            double x = (double)pos.func_177958_n() + Math.random();
            double y = (double)pos.func_177956_o() + Math.random();
            double z = (double)pos.func_177952_p() + Math.random();
            Object entity = null;
            if (world.field_73012_v.nextInt(50) == 0) {
                entity = new EntityEnderman(world);
            } else if (world.field_73012_v.nextInt(10) == 0) {
                entity = new EntityCreeper(world);
                if (world.field_73012_v.nextInt(200) == 0) {
                    ((EntityCreeper)entity).func_70077_a(null);
                }
            } else {
                switch (world.field_73012_v.nextInt(3)) {
                    case 0: {
                        entity = new EntityZombie(world);
                        if (world.field_73012_v.nextInt(10) != 0) break;
                        ((EntityZombie)entity).func_189778_a(ZombieType.HUSK);
                        break;
                    }
                    case 1: {
                        entity = new EntitySkeleton(world);
                        if (world.field_73012_v.nextInt(10) != 0) break;
                        ((EntitySkeleton)entity).func_189768_a(SkeletonType.STRAY);
                        break;
                    }
                    case 2: {
                        entity = world.field_73012_v.nextInt(10) == 0 ? new EntityCaveSpider(world) : new EntitySpider(world);
                    }
                }
            }
            entity.func_70080_a(x, y, z, world.field_73012_v.nextFloat() * 360.0f, 0.0f);
            entity.field_70179_y = 0.0;
            entity.field_70181_x = 0.0;
            entity.field_70159_w = 0.0;
            HashMultimap map = HashMultimap.create();
            map.put((Object)SharedMonsterAttributes.field_111267_a.func_111108_a(), (Object)new AttributeModifier("Loonium Modififer Health", 2.0, 1));
            map.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier("Loonium Modififer Damage", 1.5, 1));
            entity.func_110140_aT().func_111147_b((Multimap)map);
            entity.func_70690_d(new PotionEffect(MobEffects.field_76426_n, Integer.MAX_VALUE, 0));
            entity.func_70690_d(new PotionEffect(MobEffects.field_76428_l, Integer.MAX_VALUE, 0));
            NBTTagCompound cmp = new NBTTagCompound();
            stack.func_77955_b(cmp);
            entity.getEntityData().func_74782_a(TAG_ITEMSTACK_TO_DROP, (NBTBase)cmp);
            world.func_72838_d((Entity)entity);
            entity.func_180482_a(world.func_175649_E(pos), null);
            SubTileSpectranthemum.spawnExplosionParticles((Entity)entity, 5);
            this.mana -= 35000;
            this.sync();
        }
    }

    @Override
    public int getColor() {
        return 2574848;
    }

    @Override
    public LexiconEntry getEntry() {
        return LexiconData.loonium;
    }

    @Override
    public int getMaxMana() {
        return 35000;
    }

    @Override
    public boolean acceptsRedstone() {
        return true;
    }

    @Override
    public RadiusDescriptor getRadius() {
        return new RadiusDescriptor.Square(this.toBlockPos(), 5);
    }

    @Override
    public void readFromPacketNBT(NBTTagCompound cmp) {
        super.readFromPacketNBT(cmp);
        if (cmp.func_74764_b(TAG_LOOT_TABLE)) {
            this.lootTable = new ResourceLocation(cmp.func_74779_i(TAG_LOOT_TABLE));
        }
    }

    @Override
    public void writeToPacketNBT(NBTTagCompound cmp) {
        super.writeToPacketNBT(cmp);
        cmp.func_74778_a(TAG_LOOT_TABLE, this.lootTable.toString());
    }

    public static class DropHandler {
        @SubscribeEvent(priority=EventPriority.LOWEST)
        public static void onDrops(LivingDropsEvent event) {
            EntityLivingBase e = event.getEntityLiving();
            if (e.getEntityData().func_74764_b(SubTileLoonuim.TAG_ITEMSTACK_TO_DROP)) {
                NBTTagCompound cmp = e.getEntityData().func_74775_l(SubTileLoonuim.TAG_ITEMSTACK_TO_DROP);
                ItemStack stack = ItemStack.func_77949_a((NBTTagCompound)cmp);
                event.getDrops().clear();
                event.getDrops().add(new EntityItem(e.field_70170_p, e.field_70165_t, e.field_70163_u, e.field_70161_v, stack));
            }
        }
    }
}

