/*
 * Decompiled with CFR 0.152.
 */
package com.primetoxinz.stacksonstacks.logic;

import com.primetoxinz.stacksonstacks.logic.IngotLocation;
import com.primetoxinz.stacksonstacks.logic.IngotType;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import lib.render.IRenderComparable;
import lib.utils.GenericExtendedProperty;
import mcmultipart.MCMultiPartMod;
import mcmultipart.multipart.IMultipart;
import mcmultipart.multipart.IMultipartContainer;
import mcmultipart.multipart.INormallyOccludingPart;
import mcmultipart.multipart.Multipart;
import mcmultipart.multipart.MultipartHelper;
import mcmultipart.raytrace.PartMOP;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import org.lwjgl.util.vector.Vector3f;

public class PartIngot
extends Multipart
implements IRenderComparable<PartIngot>,
INormallyOccludingPart {
    public static final GenericExtendedProperty<PartIngot> PROPERTY = new GenericExtendedProperty<PartIngot>("part", PartIngot.class);
    public IngotLocation location;
    public IngotType type;
    public static final ResourceLocation LOCATION = new ModelResourceLocation("stacksonstacks:partIngot", "multipart");

    public PartIngot() {
        this.location = null;
        this.type = null;
    }

    public PartIngot(IngotLocation location, IngotType type) {
        this.location = location;
        this.type = type;
    }

    public BlockStateContainer createBlockState() {
        return new ExtendedBlockState((Block)MCMultiPartMod.multipart, new IProperty[0], new IUnlistedProperty[]{PROPERTY});
    }

    public AxisAlignedBB getBounds() {
        if (this.location != null) {
            return this.location.getBounds();
        }
        return new AxisAlignedBB(0.0, 0.0, 0.0, 0.5, 0.125, 0.25);
    }

    public void addCollisionBoxes(AxisAlignedBB mask, List<AxisAlignedBB> list, Entity collidingEntity) {
        AxisAlignedBB box = this.getBounds();
        if (box.func_72326_a(mask)) {
            list.add(box);
        }
    }

    public void addSelectionBoxes(List<AxisAlignedBB> list) {
        list.add(this.getBounds());
    }

    public void addOcclusionBoxes(List<AxisAlignedBB> list) {
        list.add(this.getBounds());
    }

    public ItemStack getPickBlock(EntityPlayer player, PartMOP hit) {
        if (this.type != null && this.type.stack != null) {
            ItemStack copy = this.type.stack.func_77946_l();
            copy.field_77994_a = 64;
            return copy;
        }
        return null;
    }

    public List<ItemStack> getDrops() {
        if (this.type != null && this.type.stack != null) {
            return Arrays.asList(this.type.stack);
        }
        return Collections.emptyList();
    }

    public IBlockState getExtendedState(IBlockState state) {
        return ((IExtendedBlockState)state).withProperty(PROPERTY, (Object)this);
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        if (this.location != null) {
            this.location.writeToNBT(tag);
        }
        if (this.type != null) {
            this.type.writeToNBT(tag);
        } else {
            System.out.println("REMOVING NULL THING");
            MultipartHelper.getPartContainer((IBlockAccess)this.getWorld(), (BlockPos)this.getPos()).removePart((IMultipart)this);
        }
        return tag;
    }

    public void readFromNBT(NBTTagCompound tag) {
        this.location = IngotLocation.readFromNBT(tag);
        this.type = IngotType.readFromNBT(tag);
    }

    public void writeUpdatePacket(PacketBuffer buf) {
        if (this.location != null) {
            this.location.writeUpdatePacket(buf);
        }
        if (this.type != null) {
            this.type.writeUpdatePacket(buf);
        }
    }

    public void readUpdatePacket(PacketBuffer buf) {
        this.location = IngotLocation.readUpdatePacket(buf);
        this.type = IngotType.readUpdatePacket(buf);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return this.getBounds();
    }

    public void harvest(EntityPlayer player, PartMOP hit) {
        if (player != null && player.func_70093_af()) {
            this.dropAll(MultipartHelper.getPartContainer((IBlockAccess)player.field_70170_p, (BlockPos)hit.func_178782_a()));
        } else {
            super.harvest(player, hit);
        }
    }

    public void dropAll(IMultipartContainer container) {
        for (IMultipart part : container.getParts()) {
            if (!(part instanceof PartIngot)) continue;
            ((PartIngot)part).drop();
        }
    }

    public void drop() {
        World world = this.getWorld();
        BlockPos pos = this.getPos();
        if (world == null || pos == null) {
            return;
        }
        double x = (double)pos.func_177958_n() + 0.5;
        double y = (double)pos.func_177956_o() + 0.5;
        double z = (double)pos.func_177952_p() + 0.5;
        if (!world.field_72995_K && world.func_82736_K().func_82766_b("doTileDrops") && !world.restoringBlockSnapshots) {
            EntityItem item = new EntityItem(world, x, y, z, this.getDrops().get(0));
            item.func_174869_p();
            world.func_72838_d((Entity)item);
        }
        if (this.getContainer() != null && this.getContainer().getParts() != null && !this.getContainer().getParts().isEmpty()) {
            this.getContainer().removePart((IMultipart)this);
        }
        this.notifyBlockUpdate();
    }

    public IngotLocation getLocation() {
        return this.location;
    }

    public Vector3f getRelativeLocation() {
        return this.location.getRelativeLocation();
    }

    @Override
    public boolean renderEquals(PartIngot other) {
        return false;
    }

    @Override
    public int renderHashCode() {
        return 0;
    }
}

