/*
 * Decompiled with CFR 0.152.
 */
package com.primetoxinz.stacksonstacks.logic;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import org.lwjgl.util.vector.Vector3f;

public class IngotLocation {
    protected float x;
    protected float y;
    protected float z;
    protected EnumFacing.Axis axis;

    public IngotLocation(float x, float y, float z, EnumFacing.Axis axis) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.axis = axis;
    }

    public IngotLocation(double x, double y, double z, EnumFacing.Axis axis) {
        this((float)x, (float)y, (float)z, axis);
    }

    public AxisAlignedBB getBounds() {
        AxisAlignedBB box = new AxisAlignedBB(0.0, 0.0, 0.0, 0.5, 0.125, 0.25).func_72317_d((double)this.x, (double)this.y, (double)this.z);
        return box;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        tag.func_74776_a("x", this.x);
        tag.func_74776_a("y", this.y);
        tag.func_74776_a("z", this.z);
        tag.func_74768_a("axis", this.axis.ordinal());
        return tag;
    }

    public static IngotLocation readFromNBT(NBTTagCompound tag) {
        float x = tag.func_74760_g("x");
        float y = tag.func_74760_g("y");
        float z = tag.func_74760_g("z");
        int axis = tag.func_74762_e("axis");
        return new IngotLocation(x, y, z, EnumFacing.Axis.values()[axis]);
    }

    public void writeUpdatePacket(PacketBuffer buf) {
        buf.writeFloat(this.x);
        buf.writeFloat(this.y);
        buf.writeFloat(this.z);
        buf.writeInt(this.axis.ordinal());
    }

    public static IngotLocation readUpdatePacket(PacketBuffer buf) {
        float x = buf.readFloat();
        float y = buf.readFloat();
        float z = buf.readFloat();
        int axis = buf.readInt();
        return new IngotLocation(x, y, z, EnumFacing.Axis.values()[axis]);
    }

    public Vector3f getRelativeLocation() {
        return new Vector3f(this.x, this.y, this.z);
    }

    public boolean equals(IngotLocation loc) {
        return loc.x == this.x && loc.y == this.y && loc.z == this.z;
    }

    public String toString() {
        return this.getRelativeLocation().toString();
    }
}

