/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.teleport.telepad;

import crazypants.enderio.EnderIO;
import crazypants.enderio.GuiID;
import crazypants.enderio.ModObject;
import crazypants.enderio.api.teleport.ITelePad;
import crazypants.enderio.config.Config;
import crazypants.enderio.integration.waila.IWailaInfoProvider;
import crazypants.enderio.network.PacketHandler;
import crazypants.enderio.paint.IPaintable;
import crazypants.enderio.render.IBlockStateWrapper;
import crazypants.enderio.render.IHaveTESR;
import crazypants.enderio.render.IRenderMapper;
import crazypants.enderio.render.property.EnumRenderMode;
import crazypants.enderio.teleport.ContainerTravelAccessable;
import crazypants.enderio.teleport.ContainerTravelAuth;
import crazypants.enderio.teleport.GuiTravelAuth;
import crazypants.enderio.teleport.anchor.BlockTravelAnchor;
import crazypants.enderio.teleport.telepad.TileTelePad;
import crazypants.enderio.teleport.telepad.gui.ContainerTelePad;
import crazypants.enderio.teleport.telepad.gui.GuiAugmentedTravelAccessible;
import crazypants.enderio.teleport.telepad.gui.GuiTelePad;
import crazypants.enderio.teleport.telepad.packet.PacketFluidLevel;
import crazypants.enderio.teleport.telepad.packet.PacketOpenServerGui;
import crazypants.enderio.teleport.telepad.packet.PacketSetTarget;
import crazypants.enderio.teleport.telepad.packet.PacketTeleport;
import crazypants.enderio.teleport.telepad.render.BlockType;
import crazypants.enderio.teleport.telepad.render.TelePadRenderMapper;
import crazypants.enderio.teleport.telepad.render.TelePadSpecialRenderer;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockTelePad
extends BlockTravelAnchor<TileTelePad>
implements IPaintable.ISolidBlockPaintableBlock,
IWailaInfoProvider,
IHaveTESR {
    public static final PropertyEnum<BlockType> BLOCK_TYPE = PropertyEnum.func_177709_a((String)"blocktype", BlockType.class);

    public static BlockTelePad createTelepad() {
        PacketHandler.INSTANCE.registerMessage(PacketOpenServerGui.class, PacketOpenServerGui.class, PacketHandler.nextID(), Side.SERVER);
        PacketHandler.INSTANCE.registerMessage(PacketSetTarget.class, PacketSetTarget.class, PacketHandler.nextID(), Side.SERVER);
        PacketHandler.INSTANCE.registerMessage(PacketSetTarget.class, PacketSetTarget.class, PacketHandler.nextID(), Side.CLIENT);
        PacketHandler.INSTANCE.registerMessage(PacketTeleport.class, PacketTeleport.class, PacketHandler.nextID(), Side.SERVER);
        PacketHandler.INSTANCE.registerMessage(PacketTeleport.class, PacketTeleport.class, PacketHandler.nextID(), Side.CLIENT);
        PacketHandler.INSTANCE.registerMessage(PacketFluidLevel.class, PacketFluidLevel.class, PacketHandler.nextID(), Side.CLIENT);
        BlockTelePad ret = new BlockTelePad();
        ret.init();
        return ret;
    }

    public BlockTelePad() {
        super(ModObject.blockTelePad.getUnlocalisedName(), TileTelePad.class);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(EnumRenderMode.RENDER, (Comparable)((Object)EnumRenderMode.AUTO)).func_177226_a(BLOCK_TYPE, (Comparable)((Object)BlockType.SINGLE)));
        this.func_149713_g(255);
        this.field_149783_u = true;
    }

    @Override
    protected void registerGuiHandlers() {
        GuiID.registerGuiHandler(GuiID.GUI_ID_TELEPAD, this);
        GuiID.registerGuiHandler(GuiID.GUI_ID_TELEPAD_TRAVEL, this);
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{EnumRenderMode.RENDER, BLOCK_TYPE});
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(BLOCK_TYPE, (Comparable)((Object)BlockType.getType(meta))).func_177226_a(EnumRenderMode.RENDER, (Comparable)((Object)EnumRenderMode.AUTO));
    }

    @Override
    public int func_176201_c(IBlockState state) {
        BlockType type = (BlockType)((Object)state.func_177229_b(BLOCK_TYPE));
        if (type == null) {
            return 0;
        }
        return type.ordinal();
    }

    @Override
    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return state.func_177226_a(EnumRenderMode.RENDER, (Comparable)((Object)EnumRenderMode.AUTO));
    }

    @Override
    protected void setBlockStateWrapperCache(@Nonnull IBlockStateWrapper blockStateWrapper, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull TileTelePad tileEntity) {
        blockStateWrapper.addCacheKey(tileEntity.inNetwork()).addCacheKey(tileEntity.isMaster());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean canRenderInLayer(BlockRenderLayer layer) {
        return true;
    }

    public boolean func_149686_d(IBlockState bs) {
        return false;
    }

    @Deprecated
    public AxisAlignedBB func_180640_a(IBlockState bs, World world, BlockPos pos) {
        BlockType bt;
        if (bs != null && bs.func_177230_c() == this && pos != null && (bt = (BlockType)((Object)bs.func_177229_b(BLOCK_TYPE))) != BlockType.SINGLE) {
            BlockPos masterLoc = bt.getLocationOfMaster(pos);
            AxisAlignedBB res = new AxisAlignedBB(masterLoc.func_177968_d().func_177968_d().func_177976_e(), masterLoc.func_177978_c().func_177974_f().func_177974_f().func_177984_a());
            return res;
        }
        return super.func_180640_a(bs, world, pos);
    }

    @Deprecated
    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block changedTo) {
        TileTelePad tileEntity;
        if (world != null && pos != null && (tileEntity = (TileTelePad)this.getTileEntity((IBlockAccess)world, pos)) != null) {
            tileEntity.updateRedstoneState();
        }
    }

    @Override
    protected boolean openGui(World world, BlockPos pos, EntityPlayer entityPlayer, EnumFacing side) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof ITelePad) {
            ITelePad tp = (ITelePad)te;
            if (tp.inNetwork()) {
                if (!tp.isMaster()) {
                    ITelePad master = tp.getMaster();
                    return this.openGui(world, master.getLocation().getBlockPos(), entityPlayer, side);
                }
            } else {
                return false;
            }
            if (tp.canBlockBeAccessed(entityPlayer)) {
                GuiID.GUI_ID_TELEPAD.openGui(world, pos, entityPlayer, side);
            } else {
                BlockTelePad.sendPrivateChatMessage(entityPlayer, tp.getOwner());
            }
        }
        return true;
    }

    @Override
    public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        TileEntity te = world.func_175625_s(new BlockPos(x, y, z));
        if (te instanceof TileTelePad) {
            if (GuiID.GUI_ID_TELEPAD.is(ID)) {
                return new ContainerTelePad(player.field_71071_by, (TileTelePad)te);
            }
            if (GuiID.GUI_ID_TELEPAD_TRAVEL.is(ID)) {
                return new ContainerTravelAccessable(player.field_71071_by, (ITelePad)te, world);
            }
            return new ContainerTravelAuth(player.field_71071_by);
        }
        return null;
    }

    @Override
    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        TileEntity te = world.func_175625_s(new BlockPos(x, y, z));
        if (te instanceof TileTelePad) {
            if (GuiID.GUI_ID_TELEPAD.is(ID)) {
                return new GuiTelePad(player.field_71071_by, (TileTelePad)te);
            }
            if (GuiID.GUI_ID_TELEPAD_TRAVEL.is(ID)) {
                return new GuiAugmentedTravelAccessible(player.field_71071_by, (TileTelePad)te, world);
            }
            return new GuiTravelAuth(player, (ITelePad)te, world);
        }
        return null;
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        BlockPos swCorner = this.findSouthWestCorner(worldIn, pos);
        BlockPos masterPos = this.getMasterPosForNewMB(worldIn, swCorner, pos);
        if (masterPos == null) {
            return super.func_180642_a(worldIn, pos, facing, hitX, hitY, hitZ, meta, placer);
        }
        Enum myType = null;
        for (BlockType bt : BlockType.values()) {
            BlockPos test = bt.getLocationOfMaster(pos);
            if (test == null || !test.equals((Object)masterPos)) continue;
            myType = bt;
        }
        if (myType == null) {
            return super.func_180642_a(worldIn, pos, facing, hitX, hitY, hitZ, meta, placer);
        }
        if (!worldIn.field_72995_K) {
            this.updateMultiBlock(worldIn, masterPos, pos, true);
        }
        return this.func_176203_a(myType.ordinal());
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        BlockType type;
        super.func_180663_b(worldIn, pos, state);
        if (state.func_177230_c() == this && (type = (BlockType)((Object)state.func_177229_b(BLOCK_TYPE))) != BlockType.SINGLE) {
            BlockPos masterPos = type.getLocationOfMaster(pos);
            this.updateMultiBlock(worldIn, masterPos, pos, false);
        }
    }

    private void updateMultiBlock(World world, BlockPos masterPos, BlockPos ignorePos, boolean form) {
        for (BlockType type : BlockType.values()) {
            if (type == BlockType.SINGLE) continue;
            Vec3i offset = type.getOffsetFromMaster();
            BlockPos targetPos = new BlockPos(masterPos.func_177958_n() + offset.func_177958_n(), masterPos.func_177956_o() + offset.func_177956_o(), masterPos.func_177952_p() + offset.func_177952_p());
            if (targetPos.equals((Object)ignorePos)) continue;
            BlockType setToType = BlockType.SINGLE;
            if (form) {
                setToType = type;
            }
            world.func_180501_a(targetPos, this.func_176223_P().func_177226_a(BLOCK_TYPE, (Comparable)((Object)setToType)), 3);
        }
    }

    private BlockPos getMasterPosForNewMB(World worldIn, BlockPos swCorner, BlockPos ignorePos) {
        BlockPos testPos = swCorner;
        for (int i = 0; i < 3; ++i) {
            testPos = swCorner.func_177967_a(EnumFacing.NORTH, i);
            for (int j = 0; j < 3; ++j) {
                if (!testPos.equals((Object)ignorePos) && !this.isSingle(worldIn, testPos)) {
                    return null;
                }
                testPos = testPos.func_177974_f();
            }
        }
        return swCorner.func_177972_a(EnumFacing.NORTH).func_177972_a(EnumFacing.EAST);
    }

    private BlockPos findSouthWestCorner(World worldIn, BlockPos pos) {
        int i;
        BlockPos res = pos;
        for (i = 0; this.isSingle(worldIn, res.func_177968_d()) && i < 2; ++i) {
            res = res.func_177968_d();
        }
        for (i = 0; this.isSingle(worldIn, res.func_177976_e()) && i < 2; ++i) {
            res = res.func_177976_e();
        }
        return res;
    }

    private boolean isSingle(World worldIn, BlockPos pos) {
        IBlockState bs = worldIn.func_180495_p(pos);
        if (bs.func_177230_c() == this) {
            return bs.func_177229_b(BLOCK_TYPE) == BlockType.SINGLE;
        }
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IRenderMapper.IItemRenderMapper getItemRenderMapper() {
        return TelePadRenderMapper.instance;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IRenderMapper.IBlockRenderMapper getBlockRenderMapper() {
        return TelePadRenderMapper.instance;
    }

    @Override
    public void getWailaInfo(List<String> tooltip, EntityPlayer player, World world, int x, int y, int z) {
        if (Config.telepadFluidUse <= 0 || world == null) {
            return;
        }
        TileTelePad te = (TileTelePad)this.getTileEntity((IBlockAccess)world, new BlockPos(x, y, z));
        if (te != null && te.inNetwork()) {
            FluidStack stored = te.getMaster().tank.getFluid();
            String fluid = stored == null ? EnderIO.lang.localize("tooltip.none") : stored.getFluid().getLocalizedName(stored);
            int amount = stored == null ? 0 : stored.amount;
            tooltip.add(String.format("%s%s : %s (%d %s)", TextFormatting.WHITE, EnderIO.lang.localize("tooltip.fluidStored"), fluid, amount, EnderIO.lang.localize("fluid.millibucket.abr")));
        }
    }

    @Override
    public int getDefaultDisplayMask(World world, int x, int y, int z) {
        return 7;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void bindTileEntitySpecialRenderer() {
        ClientRegistry.bindTileEntitySpecialRenderer(TileTelePad.class, (TileEntitySpecialRenderer)new TelePadSpecialRenderer());
    }
}

