/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.painter.blocks;

import com.enderio.core.common.BlockEnder;
import crazypants.enderio.ModObject;
import crazypants.enderio.machine.MachineRecipeInput;
import crazypants.enderio.machine.MachineRecipeRegistry;
import crazypants.enderio.machine.painter.blocks.BlockItemPaintedBlock;
import crazypants.enderio.machine.painter.blocks.TileEntityPaintedBlock;
import crazypants.enderio.machine.painter.recipe.BasicPainterTemplate;
import crazypants.enderio.paint.IPaintable;
import crazypants.enderio.paint.PainterUtil2;
import crazypants.enderio.paint.render.PaintHelper;
import crazypants.enderio.render.pipeline.BlockStateWrapperBase;
import crazypants.enderio.render.registry.SmartModelAttacher;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockPaintedStone
extends Block
implements ITileEntityProvider,
IPaintable.ISolidBlockPaintableBlock {
    private final String name;

    public static BlockPaintedStone create() {
        BlockPaintedStone result = new BlockPaintedStone(ModObject.blockPaintedStone.getUnlocalisedName());
        result.init();
        return result;
    }

    protected BlockPaintedStone(String name) {
        super(Material.field_151576_e);
        this.func_149711_c(2.0f);
        this.func_149752_b(10.0f);
        this.func_149672_a(SoundType.field_185851_d);
        this.name = name;
        this.func_149647_a(null);
        this.func_149663_c(name);
        this.setRegistryName(name);
    }

    private void init() {
        GameRegistry.register((IForgeRegistryEntry)this);
        GameRegistry.register((IForgeRegistryEntry)new BlockItemPaintedBlock(this, this.name));
        MachineRecipeRegistry.instance.registerRecipe(ModObject.blockPainter.getUnlocalisedName(), new BasicPainterTemplate<BlockPaintedStone>(this, new Block[]{Blocks.field_150347_e}){

            @Override
            public int getEnergyRequired(MachineRecipeInput ... inputs) {
                return super.getEnergyRequired(inputs) * 3;
            }
        });
        SmartModelAttacher.registerNoProps(this);
    }

    public boolean removedByPlayer(IBlockState bs, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (willHarvest) {
            return true;
        }
        return super.removedByPlayer(bs, world, pos, player, willHarvest);
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, @Nullable ItemStack stack) {
        super.func_180657_a(worldIn, player, pos, state, te, stack);
        super.removedByPlayer(state, worldIn, pos, player, true);
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        List drops = super.getDrops(world, pos, state, fortune);
        for (ItemStack drop : drops) {
            PainterUtil2.setSourceBlock(drop, this.getPaintSource(state, world, pos));
        }
        return drops;
    }

    public TileEntity func_149915_a(World world, int metadata) {
        return new TileEntityPaintedBlock();
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase player, ItemStack stack) {
        this.setPaintSource(state, (IBlockAccess)world, pos, PainterUtil2.getSourceBlock(stack));
        if (!world.field_72995_K) {
            world.func_184138_a(pos, state, state, 3);
        }
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        ItemStack pickBlock = super.getPickBlock(state, target, world, pos, player);
        PainterUtil2.setSourceBlock(pickBlock, this.getPaintSource(null, (IBlockAccess)world, pos));
        return pickBlock;
    }

    @Override
    public void setPaintSource(IBlockState state, IBlockAccess world, BlockPos pos, @Nullable IBlockState paintSource) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof IPaintable.IPaintableTileEntity) {
            ((IPaintable.IPaintableTileEntity)te).setPaintSource(paintSource);
        }
    }

    @Override
    public void setPaintSource(Block block, ItemStack stack, @Nullable IBlockState paintSource) {
        PainterUtil2.setSourceBlock(stack, paintSource);
    }

    @Override
    public IBlockState getPaintSource(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity te = BlockEnder.getAnyTileEntitySafe((IBlockAccess)world, (BlockPos)pos);
        if (te instanceof IPaintable.IPaintableTileEntity) {
            return ((IPaintable.IPaintableTileEntity)te).getPaintSource();
        }
        return null;
    }

    @Override
    public IBlockState getPaintSource(Block block, ItemStack stack) {
        return PainterUtil2.getSourceBlock(stack);
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (state != null && world != null && pos != null) {
            BlockStateWrapperBase blockStateWrapper = new BlockStateWrapperBase(state, world, pos, null);
            blockStateWrapper.addCacheKey(0);
            blockStateWrapper.bakeModel();
            return blockStateWrapper;
        }
        return state;
    }

    public IBlockState getFacade(@Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nullable EnumFacing side) {
        IBlockState paintSource = this.getPaintSource(this.func_176223_P(), world, pos);
        return paintSource != null ? paintSource : world.func_180495_p(pos);
    }

    public boolean canRenderInLayer(BlockRenderLayer layer) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item itemIn, CreativeTabs tab, List<ItemStack> list) {
        if (tab != null) {
            super.func_149666_a(itemIn, tab, list);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(IBlockState state, World world, RayTraceResult target, ParticleManager effectRenderer) {
        return PaintHelper.addHitEffects(state, world, target, effectRenderer);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World world, BlockPos pos, ParticleManager effectRenderer) {
        return PaintHelper.addDestroyEffects(world, pos, effectRenderer);
    }
}

