/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.invpanel;

import com.enderio.core.common.network.NetworkUtil;
import crazypants.enderio.EnderIO;
import crazypants.enderio.machine.invpanel.InventoryPanelContainer;
import crazypants.enderio.machine.invpanel.PacketItemInfo;
import crazypants.enderio.machine.invpanel.PacketRequestMissingItems;
import crazypants.enderio.machine.invpanel.TileInventoryPanel;
import crazypants.enderio.machine.invpanel.client.InventoryDatabaseClient;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketItemList
implements IMessage,
IMessageHandler<PacketItemList, IMessage> {
    private int windowId;
    private int generation;
    private byte[] compressed;

    public PacketItemList() {
    }

    public PacketItemList(int windowId, int generation, byte[] compressed) {
        this.windowId = windowId;
        this.generation = generation;
        this.compressed = compressed;
    }

    public void fromBytes(ByteBuf buf) {
        this.windowId = buf.readInt();
        this.generation = buf.readInt();
        this.compressed = NetworkUtil.readByteArray((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.windowId);
        buf.writeInt(this.generation);
        NetworkUtil.writeByteArray((ByteBuf)buf, (byte[])this.compressed);
    }

    public IMessage onMessage(PacketItemList message, MessageContext ctx) {
        EntityPlayer player = EnderIO.proxy.getClientPlayer();
        if (player.field_71070_bA.field_75152_c == message.windowId && player.field_71070_bA instanceof InventoryPanelContainer) {
            InventoryPanelContainer ipc = (InventoryPanelContainer)player.field_71070_bA;
            TileInventoryPanel teInvPanel = (TileInventoryPanel)ipc.getInv();
            InventoryDatabaseClient db = teInvPanel.getDatabaseClient(message.generation);
            try {
                List<Integer> missingItems = db.readCompressedItemList(message.compressed);
                if (missingItems != null) {
                    return new PacketRequestMissingItems(message.windowId, db.getGeneration(), missingItems);
                }
            }
            catch (IOException ex) {
                Logger.getLogger(PacketItemInfo.class.getName()).log(Level.SEVERE, "Exception while reading item list", ex);
            }
        }
        return null;
    }
}

