/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.crafter;

import com.enderio.core.common.util.ItemUtil;
import com.mojang.authlib.GameProfile;
import crazypants.enderio.ModObject;
import crazypants.enderio.capacitor.CapacitorKey;
import crazypants.enderio.config.Config;
import crazypants.enderio.machine.AbstractPowerConsumerEntity;
import crazypants.enderio.machine.FakePlayerEIO;
import crazypants.enderio.machine.IItemBuffer;
import crazypants.enderio.machine.SlotDefinition;
import crazypants.enderio.machine.crafter.DummyCraftingGrid;
import crazypants.enderio.paint.IPaintable;
import info.loenwind.autosave.annotations.Storable;
import info.loenwind.autosave.annotations.Store;
import info.loenwind.autosave.handlers.minecraft.HandleItemStack;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;

@Storable
public class TileCrafter
extends AbstractPowerConsumerEntity
implements IItemBuffer,
IPaintable.IPaintableTileEntity {
    @Store
    DummyCraftingGrid craftingGrid = new DummyCraftingGrid();
    @Store(handler=HandleItemStack.HandleItemStackArrayList.class)
    private final List<ItemStack> containerItems = new ArrayList<ItemStack>();
    @Store
    private boolean bufferStacks = true;
    private long ticksSinceLastCraft = 0L;
    private FakePlayerEIO playerInst;
    private static final UUID uuid = UUID.fromString("9b381cae-3c95-4a64-b958-1e25b0a4c790");
    private static final GameProfile DUMMY_PROFILE = new GameProfile(uuid, "[EioCrafter]");

    public TileCrafter() {
        super(new SlotDefinition(9, 1), CapacitorKey.CRAFTER_POWER_INTAKE, CapacitorKey.CRAFTER_POWER_BUFFER, null);
    }

    @Override
    @Nonnull
    public String getMachineName() {
        return ModObject.blockCrafter.getUnlocalisedName();
    }

    @Override
    protected boolean isMachineItemValidForSlot(int slot, ItemStack itemstack) {
        if (!this.slotDefinition.isInputSlot(slot)) {
            return false;
        }
        return this.craftingGrid.inv[slot] != null && TileCrafter.compareDamageable(itemstack, this.craftingGrid.inv[slot]);
    }

    @Override
    public boolean isActive() {
        return false;
    }

    @Override
    protected boolean processTasks(boolean redstoneCheck) {
        ++this.ticksSinceLastCraft;
        if (!(redstoneCheck && this.craftingGrid.hasValidRecipe() && this.canMergeOutput() && this.hasRequiredPower())) {
            return false;
        }
        int ticksPerCraft = this.getTicksPerCraft();
        if (this.ticksSinceLastCraft <= (long)ticksPerCraft) {
            return false;
        }
        this.ticksSinceLastCraft = 0L;
        if (!this.containerItems.isEmpty()) {
            Iterator<ItemStack> iter = this.containerItems.iterator();
            while (iter.hasNext()) {
                ItemStack stack = iter.next();
                if (this.inventory[9] == null) {
                    this.inventory[9] = stack;
                    iter.remove();
                    continue;
                }
                if (!ItemUtil.areStackMergable((ItemStack)this.inventory[9], (ItemStack)stack) || this.inventory[9].field_77994_a + stack.field_77994_a > this.inventory[9].func_77976_d()) continue;
                this.inventory[9].field_77994_a += stack.field_77994_a;
                iter.remove();
            }
            return false;
        }
        if (this.craftRecipe()) {
            int used = Math.min(this.getEnergyStored(), this.getPowerUsePerCraft());
            this.setEnergyStored(this.getEnergyStored() - used);
        }
        return false;
    }

    private boolean hasRequiredPower() {
        return this.getEnergyStored() >= this.getPowerUsePerCraft();
    }

    @Override
    public int getPowerUsePerTick() {
        return (int)Math.ceil((double)this.getPowerUsePerCraft() / (double)this.getTicksPerCraft());
    }

    protected int getPowerUsePerCraft() {
        return Config.crafterRfPerCraft;
    }

    public int getTicksPerCraft() {
        return Math.max(1, CapacitorKey.CRAFTER_TICKS.get(this.getCapacitorData()));
    }

    static boolean compareDamageable(ItemStack stack, ItemStack req) {
        if (stack.func_77969_a(req)) {
            return true;
        }
        if (stack.func_77984_f() && stack.func_77973_b() == req.func_77973_b()) {
            return stack.func_77952_i() < stack.func_77958_k();
        }
        return false;
    }

    private boolean craftRecipe() {
        int i;
        InventoryCrafting inv = new InventoryCrafting(new Container(){

            public boolean func_75145_c(EntityPlayer var1) {
                return false;
            }
        }, 3, 3);
        int[] usedItems = new int[9];
        for (int j = 0; j < 9; ++j) {
            ItemStack req = this.craftingGrid.func_70301_a(j);
            if (req == null) continue;
            for (i = 0; i < 9; ++i) {
                if (this.inventory[i] == null || this.inventory[i].field_77994_a <= usedItems[i] || !TileCrafter.compareDamageable(this.inventory[i], req)) continue;
                req = null;
                int n = i;
                usedItems[n] = usedItems[n] + 1;
                ItemStack craftingItem = this.inventory[i].func_77946_l();
                craftingItem.field_77994_a = 1;
                inv.func_70299_a(j, craftingItem);
                break;
            }
            if (req == null) continue;
            return false;
        }
        ItemStack output = CraftingManager.func_77594_a().func_82787_a(inv, this.field_145850_b);
        if (output != null) {
            if (this.playerInst == null) {
                this.playerInst = new FakePlayerEIO(this.field_145850_b, this.getLocation(), DUMMY_PROFILE);
                this.playerInst.setOwner(this.owner);
            }
            MinecraftForge.EVENT_BUS.post((Event)new PlayerEvent.ItemCraftedEvent((EntityPlayer)this.playerInst, output, (IInventory)inv));
            ItemStack[] remaining = CraftingManager.func_77594_a().func_180303_b(inv, this.field_145850_b);
            for (i = 0; i < 9; ++i) {
                for (int j = 0; j < usedItems[i] && this.inventory[i] != null; ++j) {
                    this.func_70299_a(i, this.eatOneItemForCrafting(i, this.inventory[i].func_77946_l(), remaining));
                }
            }
            if (remaining != null) {
                for (ItemStack stack : remaining) {
                    if (stack == null) continue;
                    this.containerItems.add(stack.func_77946_l());
                }
            }
            if (this.inventory[9] == null) {
                this.func_70299_a(9, output);
            } else if (ItemUtil.areStackMergable((ItemStack)this.inventory[9], (ItemStack)output)) {
                ItemStack cur = this.inventory[9].func_77946_l();
                cur.field_77994_a += output.field_77994_a;
                if (cur.field_77994_a > cur.func_77976_d()) {
                    ItemStack overflow = cur.func_77946_l();
                    overflow.field_77994_a = cur.field_77994_a - cur.func_77976_d();
                    cur.field_77994_a = cur.func_77976_d();
                    this.containerItems.add(overflow);
                }
                this.func_70299_a(9, cur);
            } else {
                this.containerItems.add(output);
            }
        } else {
            for (int j = 0; j < 9; ++j) {
                if (usedItems[j] <= 0 || this.inventory[j] == null) continue;
                ItemStack rejected = this.inventory[j].func_77946_l();
                rejected.field_77994_a = Math.min(this.inventory[j].field_77994_a, usedItems[j]);
                this.containerItems.add(rejected);
                if (this.inventory[j].field_77994_a <= usedItems[j]) {
                    this.inventory[j] = null;
                    continue;
                }
                this.inventory[j].field_77994_a -= usedItems[j];
            }
        }
        return true;
    }

    private ItemStack eatOneItemForCrafting(int slot, ItemStack avail, ItemStack[] remaining) {
        ItemStack used;
        if (remaining != null && remaining.length > 0 && avail.func_77973_b().hasContainerItem(avail) && (used = avail.func_77973_b().getContainerItem(avail)) != null) {
            for (int i = 0; i < remaining.length; ++i) {
                ItemStack s = remaining[i];
                if (s == null || !s.func_185136_b(used) || !this.func_94041_b(slot, s)) continue;
                remaining[i] = null;
                return s;
            }
        }
        --avail.field_77994_a;
        if (avail.field_77994_a == 0) {
            avail = null;
        }
        return avail;
    }

    private boolean canMergeOutput() {
        if (this.inventory[9] == null) {
            return true;
        }
        ItemStack output = this.craftingGrid.getOutput();
        if (!ItemUtil.areStackMergable((ItemStack)this.inventory[9], (ItemStack)output)) {
            return false;
        }
        return output.func_77976_d() >= this.inventory[9].field_77994_a + output.field_77994_a;
    }

    @Override
    public int func_70297_j_() {
        return this.bufferStacks ? 64 : 1;
    }

    @Override
    public boolean isBufferStacks() {
        return this.bufferStacks;
    }

    @Override
    public void setBufferStacks(boolean bufferStacks) {
        this.bufferStacks = bufferStacks;
    }

    public void updateCraftingOutput() {
        InventoryCrafting inv = new InventoryCrafting(new Container(){

            public boolean func_75145_c(EntityPlayer var1) {
                return false;
            }
        }, 3, 3);
        for (int i = 0; i < 9; ++i) {
            inv.func_70299_a(i, this.craftingGrid.func_70301_a(i));
        }
        ItemStack matches = CraftingManager.func_77594_a().func_82787_a(inv, this.field_145850_b);
        this.craftingGrid.func_70299_a(9, matches);
        this.func_70296_d();
    }
}

