/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.item.darksteel.upgrade;

import crazypants.enderio.config.Config;
import crazypants.enderio.item.darksteel.DarkSteelItems;
import crazypants.enderio.item.darksteel.upgrade.AbstractUpgrade;
import crazypants.enderio.item.darksteel.upgrade.EnergyUpgrade;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.PotionTypes;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;

public class SpeedUpgrade
extends AbstractUpgrade {
    private static final String KEY_LEVEL = "level";
    private static final String KEY_MULTIPLIER = "multiplier";
    private static String UPGRADE_NAME = "speedBoost";
    public static float[] WALK_MULTIPLIERS = new float[]{Config.darkSteelSpeedOneWalkModifier, Config.darkSteelSpeedTwoWalkMultiplier, Config.darkSteelSpeedThreeWalkMultiplier};
    public static float[] SPRINT_MULTIPLIERS = new float[]{Config.darkSteelSpeedOneSprintModifier, Config.darkSteelSpeedTwoSprintMultiplier, Config.darkSteelSpeedThreeSprintMultiplier};
    public static SpeedUpgrade SPEED_ONE = new SpeedUpgrade("enderio.darksteel.upgrade.speed_one", 1, Config.darkSteelSpeedOneCost);
    public static SpeedUpgrade SPEED_TWO = new SpeedUpgrade("enderio.darksteel.upgrade.speed_two", 2, Config.darkSteelSpeedTwoCost);
    public static SpeedUpgrade SPEED_THREE = new SpeedUpgrade("enderio.darksteel.upgrade.speed_three", 3, Config.darkSteelSpeedThreeCost);
    private short level;
    private float walkMultiplier;
    protected float sprintMultiplier;

    public static boolean isEquipped(EntityPlayer player) {
        ItemStack legs = player.func_184582_a(EntityEquipmentSlot.LEGS);
        return SpeedUpgrade.loadFromItem(legs) != null;
    }

    public static SpeedUpgrade loadFromItem(ItemStack stack) {
        if (stack == null) {
            return null;
        }
        if (stack.func_77978_p() == null) {
            return null;
        }
        if (!stack.func_77978_p().func_74764_b("enderio.darksteel.upgrade." + UPGRADE_NAME)) {
            return null;
        }
        return new SpeedUpgrade((NBTTagCompound)stack.func_77978_p().func_74781_a("enderio.darksteel.upgrade." + UPGRADE_NAME));
    }

    private static ItemStack createUpgradeItem() {
        ItemStack pot = new ItemStack((Item)Items.field_151068_bn, 1, 0);
        PotionUtils.func_185188_a((ItemStack)pot, (PotionType)PotionTypes.field_185244_p);
        return pot;
    }

    public SpeedUpgrade(NBTTagCompound tag) {
        super(UPGRADE_NAME, tag);
        this.level = tag.func_74765_d(KEY_LEVEL);
    }

    public SpeedUpgrade(String unlocName, int level, int levelCost) {
        super(UPGRADE_NAME, unlocName, SpeedUpgrade.createUpgradeItem(), levelCost);
        this.level = (short)level;
    }

    @Override
    public boolean canAddToItem(ItemStack stack) {
        if (stack == null || stack.func_77973_b() != DarkSteelItems.itemDarkSteelLeggings || !EnergyUpgrade.itemHasAnyPowerUpgrade(stack)) {
            return false;
        }
        SpeedUpgrade up = SpeedUpgrade.loadFromItem(stack);
        if (up == null) {
            return this.getLevel() == 1;
        }
        return up.getLevel() == this.getLevel() - 1;
    }

    @Override
    public boolean hasUpgrade(ItemStack stack) {
        if (!super.hasUpgrade(stack)) {
            return false;
        }
        SpeedUpgrade up = SpeedUpgrade.loadFromItem(stack);
        if (up == null) {
            return false;
        }
        return up.unlocName.equals(this.unlocName);
    }

    @Override
    public void writeUpgradeToNBT(NBTTagCompound upgradeRoot) {
        upgradeRoot.func_74777_a(KEY_LEVEL, this.getLevel());
        upgradeRoot.func_74776_a(KEY_MULTIPLIER, this.getWalkMultiplier());
    }

    public short getLevel() {
        return this.level;
    }

    public float getWalkMultiplier() {
        return this.walkMultiplier;
    }
}

