/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.integration.tic;

import crazypants.enderio.EnderIO;
import crazypants.enderio.Log;
import crazypants.enderio.fluid.BlockFluidEio;
import crazypants.enderio.integration.tic.AdditionalFluid;
import crazypants.enderio.material.Alloy;
import crazypants.util.Prep;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class TicProxy {
    static final ResourceLocation TEX_STILL = new ResourceLocation("tconstruct:blocks/fluids/molten_metal_flow");
    static final ResourceLocation TEX_FLOWING = new ResourceLocation("tconstruct:blocks/fluids/molten_metal");
    private static boolean isLoaded = false;
    private static Class<Object> TinkerRegistry;
    private static Method getMelting;
    private static Method registerAlloy;
    private static Method registerTableCasting;
    private static Method registerMelting;
    private static Method registerBasinCasting;
    private static Class<Object> MeltingRecipe;
    private static Method getResult;
    private static List<Pair<ItemStack, ItemStack[]>> alloyQueue;
    private static List<CastQueue> castQueue;
    private static List<SmeltQueue> smeltQueue;
    private static List<BasinQueue> basinQueue;

    public static void init(FMLPreInitializationEvent event) {
        if (Loader.isModLoaded((String)"tconstruct")) {
            try {
                TinkerRegistry = ReflectionHelper.getClass((ClassLoader)TicProxy.class.getClassLoader(), (String[])new String[]{"slimeknights.tconstruct.library.TinkerRegistry"});
                getMelting = ReflectionHelper.findMethod(TinkerRegistry, null, (String[])new String[]{"getMelting"}, (Class[])new Class[]{ItemStack.class});
                registerAlloy = ReflectionHelper.findMethod(TinkerRegistry, null, (String[])new String[]{"registerAlloy"}, (Class[])new Class[]{FluidStack.class, FluidStack[].class});
                registerTableCasting = ReflectionHelper.findMethod(TinkerRegistry, null, (String[])new String[]{"registerTableCasting"}, (Class[])new Class[]{ItemStack.class, ItemStack.class, Fluid.class, Integer.TYPE});
                registerMelting = ReflectionHelper.findMethod(TinkerRegistry, null, (String[])new String[]{"registerMelting"}, (Class[])new Class[]{ItemStack.class, Fluid.class, Integer.TYPE});
                registerBasinCasting = ReflectionHelper.findMethod(TinkerRegistry, null, (String[])new String[]{"registerBasinCasting"}, (Class[])new Class[]{ItemStack.class, ItemStack.class, Fluid.class, Integer.TYPE});
                MeltingRecipe = ReflectionHelper.getClass((ClassLoader)TicProxy.class.getClassLoader(), (String[])new String[]{"slimeknights.tconstruct.library.smeltery.MeltingRecipe"});
                getResult = ReflectionHelper.findMethod(MeltingRecipe, null, (String[])new String[]{"getResult"}, (Class[])new Class[0]);
                isLoaded = true;
                AdditionalFluid.init(event);
            }
            catch (RuntimeException e) {
                Log.error("Failed to load Tinker's Construct integration. Reason:");
                e.printStackTrace();
            }
        }
    }

    public static boolean isLoaded() {
        return isLoaded;
    }

    public static void registerAlloyRecipe(ItemStack result, ItemStack ... input) {
        if (!isLoaded || Prep.isInvalid(result) || input.length < 2) {
            return;
        }
        for (ItemStack itemStack : input) {
            if (!Prep.isInvalid(itemStack)) continue;
            return;
        }
        if (alloyQueue == null) {
            alloyQueue = new ArrayList<Pair<ItemStack, ItemStack[]>>();
        }
        alloyQueue.add((Pair<ItemStack, ItemStack[]>)Pair.of((Object)result, (Object)input));
        FluidStack fluidResult = TicProxy.getFluidForItems(result);
        if (fluidResult == null) {
            return;
        }
        FluidStack[] fluids = new FluidStack[input.length];
        for (int i = 0; i < input.length; ++i) {
            fluids[i] = TicProxy.getFluidForItems(input[i]);
            if (fluids[i] != null) continue;
            return;
        }
        Log.debug("Registered alloy recipe with TiC: " + result + " (" + fluidResult + ") from " + input + " (" + fluids + ")");
    }

    private static void registerAlloyRecipe(Pair<ItemStack, ItemStack[]> alloy) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        FluidStack fluidResult = TicProxy.getFluidForItems((ItemStack)alloy.getLeft());
        if (fluidResult == null) {
            TicProxy.tryBasinAloying((ItemStack)alloy.getLeft(), (ItemStack[])alloy.getRight());
            return;
        }
        FluidStack[] fluids = new FluidStack[((ItemStack[])alloy.getRight()).length];
        for (int i = 0; i < ((ItemStack[])alloy.getRight()).length; ++i) {
            fluids[i] = TicProxy.getFluidForItems(((ItemStack[])alloy.getRight())[i]);
            if (fluids[i] != null) continue;
            return;
        }
        TicProxy.gcd(fluidResult, fluids);
        registerAlloy.invoke(null, fluidResult, fluids);
        Log.debug("Tinkers.registerAlloy: " + fluidResult + ", " + fluids);
    }

    private static void tryBasinAloying(ItemStack result, ItemStack ... inputs) {
        FluidStack b;
        if (Prep.isInvalid(result) || result.field_77994_a != 1 || !(result.func_77973_b() instanceof ItemBlock) || inputs.length != 2 || Prep.isInvalid(inputs[0]) || Prep.isInvalid(inputs[1])) {
            return;
        }
        FluidStack a = TicProxy.getFluidForItems(inputs[0]);
        if (a == null == ((b = TicProxy.getFluidForItems(inputs[1])) == null)) {
            return;
        }
        if (!(a != null || inputs[0].field_77994_a == 1 && inputs[0].func_77973_b() instanceof ItemBlock)) {
            return;
        }
        if (!(b != null || inputs[1].field_77994_a == 1 && inputs[1].func_77973_b() instanceof ItemBlock)) {
            return;
        }
        if (a != null) {
            TicProxy.registerBasinCasting(result, inputs[1], a.getFluid(), a.amount);
        } else if (b != null) {
            TicProxy.registerBasinCasting(result, inputs[0], b.getFluid(), b.amount);
        }
    }

    public static void init(FMLPostInitializationEvent event) {
        if (!isLoaded) {
            return;
        }
        AdditionalFluid.init(event);
        try {
            FluidStack fluid;
            if (smeltQueue != null) {
                for (SmeltQueue smeltQueue : TicProxy.smeltQueue) {
                    if (smeltQueue.fluidOutput == null) {
                        fluid = TicProxy.getFluidForItems(smeltQueue.output);
                        if (fluid == null) {
                            Log.warn("Item used in Smeltery recipe '" + smeltQueue.output + "' doesn't smelt into a fluid");
                        } else {
                            smeltQueue.fluidOutput = fluid.getFluid();
                            smeltQueue.amount *= (float)fluid.amount;
                        }
                    }
                    if (smeltQueue.fluidOutput == null) continue;
                    registerMelting.invoke(null, smeltQueue.input, smeltQueue.fluidOutput, (int)Math.max(1.0, Math.floor(smeltQueue.amount)));
                    Log.debug("Tinkers.registerMelting: " + smeltQueue.input + ", " + smeltQueue.fluidOutput.getName() + ", " + smeltQueue.amount);
                }
                smeltQueue = null;
            }
            if (alloyQueue != null) {
                for (Pair pair : alloyQueue) {
                    TicProxy.registerAlloyRecipe((Pair<ItemStack, ItemStack[]>)pair);
                }
                alloyQueue = null;
            }
            if (castQueue != null) {
                for (CastQueue castQueue : TicProxy.castQueue) {
                    if (castQueue.fluid == null) {
                        fluid = TicProxy.getFluidForItems(castQueue.item);
                        castQueue.fluid = fluid.getFluid();
                        castQueue.amount *= (float)fluid.amount;
                    }
                    if (castQueue.fluid == null) {
                        Log.warn("Item used in cast recipe '" + castQueue.item + "' doesn't smelt into a fluid");
                        continue;
                    }
                    registerTableCasting.invoke(null, castQueue.result, castQueue.cast, castQueue.fluid, (int)Math.ceil(castQueue.amount));
                    Log.debug("Tinkers.registerTableCasting: " + castQueue.result + ", " + castQueue.cast + ", " + castQueue.fluid.getName() + ", " + castQueue.amount);
                }
                castQueue = null;
            }
            if (basinQueue != null) {
                for (BasinQueue basinQueue : TicProxy.basinQueue) {
                    if (basinQueue.fluid == null && (fluid = TicProxy.getFluidForItems(basinQueue.fluidItem)) != null) {
                        basinQueue.fluid = fluid.getFluid();
                        basinQueue.amount *= fluid.amount;
                    }
                    if (basinQueue.fluid == null) continue;
                    registerBasinCasting.invoke(null, basinQueue.output, basinQueue.cast, basinQueue.fluid, basinQueue.amount);
                    Log.debug("Tinkers.registerBasinCasting: " + basinQueue.output + ", " + basinQueue.cast + ", " + basinQueue.fluid.getName() + ", " + basinQueue.amount);
                }
                basinQueue = null;
            }
        }
        catch (IllegalAccessException e) {
            Log.error("Failed to access Tinker's Construct integration. Reason:");
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            Log.error("Failed to access Tinker's Construct integration. Reason:");
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            Log.error("Failed to access Tinker's Construct integration. Reason:");
            e.printStackTrace();
        }
    }

    private static int gcd(int a, int b) {
        while (b > 0) {
            int temp = b;
            b = a % b;
            a = temp;
        }
        return a;
    }

    private static void gcd(FluidStack input, FluidStack ... inputs) {
        int result = input.amount;
        for (FluidStack stack : inputs) {
            result = TicProxy.gcd(result, stack.amount);
        }
        if (result > 1) {
            input.amount /= result;
            for (FluidStack stack : inputs) {
                stack.amount /= result;
            }
        }
    }

    public static FluidStack getFluidForItems(ItemStack input) {
        if (!isLoaded) {
            return null;
        }
        try {
            ItemStack itemStack = input.func_77946_l();
            itemStack.field_77994_a = 1;
            Object melting = getMelting.invoke(null, itemStack);
            if (melting == null) {
                Fluid fluid;
                if (itemStack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150343_Z) && (fluid = FluidRegistry.getFluid((String)"obsidian")) != null) {
                    return new FluidStack(fluid, 288 * input.field_77994_a);
                }
                return null;
            }
            Object meltingResult = getResult.invoke(melting, new Object[0]);
            if (meltingResult instanceof FluidStack) {
                FluidStack result = (FluidStack)meltingResult;
                result.amount *= input.field_77994_a;
                return result;
            }
        }
        catch (IllegalAccessException e) {
            Log.error("Failed to access Tinker's Construct integration. Reason:");
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            Log.error("Failed to access Tinker's Construct integration. Reason:");
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            Log.error("Failed to access Tinker's Construct integration. Reason:");
            e.printStackTrace();
        }
        return null;
    }

    public static void registerMetal(final Alloy alloy) {
        if (!isLoaded) {
            return;
        }
        Fluid f = new Fluid(alloy.getFluidName(), TEX_FLOWING, TEX_STILL){

            public int getColor() {
                return 0xFF000000 | alloy.getColor();
            }
        };
        f.setDensity(9000);
        f.setLuminosity(4);
        f.setTemperature(alloy.getMeltingPoint() + 273);
        f.setViscosity(3000);
        FluidRegistry.registerFluid((Fluid)f);
        BlockFluidEio.createMetal(f, Material.field_151587_i, alloy.getColor());
        if (!EnderIO.proxy.isDedicatedServer()) {
            EnderIO.fluids.registerFluidBlockRendering(f, f.getName());
        }
        if (FluidRegistry.isUniversalBucketEnabled()) {
            FluidRegistry.addBucketForFluid((Fluid)f);
        }
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("fluid", f.getName());
        tag.func_74778_a("ore", StringUtils.capitalize((String)alloy.getBaseName()));
        tag.func_74757_a("toolforge", true);
        FMLInterModComms.sendMessage((String)"tconstruct", (String)"integrateSmeltery", (NBTTagCompound)tag);
    }

    public static String registerTableCast(ItemStack result, ItemStack cast, ItemStack item, float amount, boolean simulate) {
        if (!isLoaded) {
            return null;
        }
        if (Prep.isInvalid(result)) {
            return "Result item not found";
        }
        if (Prep.isInvalid(cast)) {
            return "Cast item not found";
        }
        if (Prep.isInvalid(item)) {
            return "Fluid item not found";
        }
        if (!simulate) {
            item = item.func_77946_l();
            item.field_77994_a = 1;
            if (castQueue == null) {
                castQueue = new ArrayList<CastQueue>();
            }
            castQueue.add(new CastQueue(result, cast, item, amount));
        }
        return null;
    }

    public static void registerTableCast(ItemStack result, ItemStack cast, Fluid fluid, float amount) {
        if (!isLoaded || Prep.isInvalid(result) || Prep.isInvalid(cast) || fluid == null) {
            return;
        }
        if (castQueue == null) {
            castQueue = new ArrayList<CastQueue>();
        }
        castQueue.add(new CastQueue(result, cast, fluid, amount));
    }

    public static void registerSmelterySmelting(ItemStack input, ItemStack output, float amount) {
        if (!isLoaded || Prep.isInvalid(input) || Prep.isInvalid(output)) {
            return;
        }
        if (smeltQueue == null) {
            smeltQueue = new ArrayList<SmeltQueue>();
        }
        smeltQueue.add(new SmeltQueue(input, output, amount));
    }

    public static void registerSmelterySmelting(ItemStack input, Fluid output, float amount) {
        if (!isLoaded || Prep.isInvalid(input) || output == null) {
            return;
        }
        if (smeltQueue == null) {
            smeltQueue = new ArrayList<SmeltQueue>();
        }
        smeltQueue.add(new SmeltQueue(input, output, amount));
    }

    public static void registerBasinCasting(ItemStack output, @Nullable ItemStack cast, ItemStack fluid, int amount) {
        if (!isLoaded || Prep.isInvalid(output) || Prep.isInvalid(fluid)) {
            return;
        }
        if (basinQueue == null) {
            basinQueue = new ArrayList<BasinQueue>();
        }
        basinQueue.add(new BasinQueue(output, cast, fluid, amount));
    }

    public static void registerBasinCasting(ItemStack output, @Nullable ItemStack cast, Fluid fluid, int amount) {
        if (!isLoaded || Prep.isInvalid(output) || fluid == null) {
            return;
        }
        if (basinQueue == null) {
            basinQueue = new ArrayList<BasinQueue>();
        }
        basinQueue.add(new BasinQueue(output, cast, fluid, amount));
    }

    private static class BasinQueue {
        ItemStack output;
        @Nullable
        ItemStack cast;
        Fluid fluid;
        ItemStack fluidItem;
        int amount;

        public BasinQueue(ItemStack output, ItemStack cast, ItemStack fluidItem, int amount) {
            this.output = output;
            this.cast = cast;
            this.fluid = null;
            this.fluidItem = fluidItem;
            this.amount = amount;
        }

        public BasinQueue(ItemStack output, ItemStack cast, Fluid fluid, int amount) {
            this.output = output;
            this.cast = cast;
            this.fluid = fluid;
            this.fluidItem = null;
            this.amount = amount;
        }
    }

    private static class SmeltQueue {
        ItemStack input;
        ItemStack output;
        Fluid fluidOutput;
        float amount;

        public SmeltQueue(ItemStack input, ItemStack output, float amount) {
            this.input = input;
            this.output = output;
            this.fluidOutput = null;
            this.amount = amount;
        }

        public SmeltQueue(ItemStack input, Fluid fluidOutput, float amount) {
            this.input = input;
            this.output = null;
            this.fluidOutput = fluidOutput;
            this.amount = amount;
        }
    }

    private static class CastQueue {
        ItemStack result;
        ItemStack cast;
        ItemStack item;
        Fluid fluid;
        float amount;

        CastQueue(ItemStack result, ItemStack cast, ItemStack item, float amount) {
            this.result = result;
            this.cast = cast;
            this.item = item;
            this.fluid = null;
            this.amount = amount;
        }

        CastQueue(ItemStack result, ItemStack cast, Fluid fluid, float amount) {
            this.result = result;
            this.cast = cast;
            this.item = null;
            this.fluid = fluid;
            this.amount = amount;
        }
    }
}

