/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.integration.tic;

import crazypants.enderio.EnderIO;
import crazypants.enderio.Log;
import crazypants.enderio.ModObject;
import crazypants.enderio.fluid.BlockFluidEio;
import crazypants.enderio.integration.tic.TicProxy;
import crazypants.enderio.material.PowderIngot;
import crazypants.util.Things;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;

public class AdditionalFluid {
    static final ResourceLocation GLOWSTONE_TEX_STILL = new ResourceLocation("enderio:blocks/fluid_glowstone_still");
    static final ResourceLocation GLOWSTONE_TEX_FLOWING = new ResourceLocation("enderio:blocks/fluid_glowstone_flowing");
    public static final String GLOWSTONE_FLUID_NAME = "glowstone";
    public static final String REDSTONE_FLUID_NAME = "redstone";
    public static final String ENDER_FLUID_NAME = "ender";
    private static final boolean REGISTER_GLOWSTONE_BLOCK = true;
    private static final boolean REGISTER_REDSTONE_BLOCK = true;
    private static final boolean REGISTER_ENDER_BLOCK = true;
    private static boolean registerVanillaRecipesForGlowstone = false;
    private static boolean registerVanillaRecipesForRedstone = false;
    private static boolean registerVanillaRecipesForEnder = false;

    static void init(FMLPreInitializationEvent event) {
        if (!Loader.isModLoaded((String)"ThermalFoundation")) {
            AdditionalFluid.glowstone(event);
            AdditionalFluid.redstone(event);
            AdditionalFluid.ender(event);
        }
    }

    static void init(FMLPostInitializationEvent event) {
        AdditionalFluid.glowstone(event);
        AdditionalFluid.redstone(event);
        AdditionalFluid.ender(event);
    }

    private static Fluid glowstone(FMLPreInitializationEvent event) {
        Fluid f = new Fluid(GLOWSTONE_FLUID_NAME, GLOWSTONE_TEX_STILL, GLOWSTONE_TEX_FLOWING){

            public int getColor() {
                return -2130706433;
            }
        };
        f.setDensity(-500);
        f.setGaseous(true);
        f.setLuminosity(15);
        f.setTemperature(1773);
        f.setViscosity(100);
        if (FluidRegistry.registerFluid((Fluid)f)) {
            BlockFluidEio.MoltenGlowstone block = new BlockFluidEio.MoltenGlowstone(f, Material.field_151586_h, 16759902);
            block.init();
            f.setBlock((Block)block);
            if (!EnderIO.proxy.isDedicatedServer()) {
                EnderIO.fluids.registerFluidBlockRendering(f, f.getName());
            }
            if (FluidRegistry.isUniversalBucketEnabled()) {
                FluidRegistry.addBucketForFluid((Fluid)f);
            }
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74778_a("fluid", f.getName());
            tag.func_74778_a("ore", "Glowstone");
            tag.func_74757_a("toolforge", true);
            FMLInterModComms.sendMessage((String)"tconstruct", (String)"integrateSmeltery", (NBTTagCompound)tag);
            registerVanillaRecipesForGlowstone = true;
        }
        return f;
    }

    private static void glowstone(FMLPostInitializationEvent event) {
        Fluid f = FluidRegistry.getFluid((String)GLOWSTONE_FLUID_NAME);
        if (f == null) {
            Log.warn("Thermal Foundation fluid 'glowstone' is unexpectedly missing. Late registering our own.");
            f = AdditionalFluid.glowstone((FMLPreInitializationEvent)null);
        }
        if (registerVanillaRecipesForGlowstone) {
            TicProxy.registerSmelterySmelting(new ItemStack(Items.field_151114_aO), f, 250.0f);
            TicProxy.registerSmelterySmelting(new ItemStack(Blocks.field_150426_aN), f, 1000.0f);
            TicProxy.registerBasinCasting(new ItemStack(Blocks.field_150426_aN), null, f, 1000);
        }
    }

    private static Fluid redstone(FMLPreInitializationEvent event) {
        Fluid f = new Fluid(REDSTONE_FLUID_NAME, TicProxy.TEX_FLOWING, TicProxy.TEX_STILL){

            public int getColor() {
                return -65536;
            }
        };
        f.setDensity(1200);
        f.setLuminosity(7);
        f.setTemperature(1973);
        f.setViscosity(1500);
        if (FluidRegistry.registerFluid((Fluid)f)) {
            BlockFluidEio.MoltenRedstone block = new BlockFluidEio.MoltenRedstone(f, Material.field_151586_h, 0xFF0000);
            block.init();
            f.setBlock((Block)block);
            if (!EnderIO.proxy.isDedicatedServer()) {
                EnderIO.fluids.registerFluidBlockRendering(f, f.getName());
            }
            if (FluidRegistry.isUniversalBucketEnabled()) {
                FluidRegistry.addBucketForFluid((Fluid)f);
            }
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74778_a("fluid", f.getName());
            tag.func_74778_a("ore", "Redstone");
            tag.func_74757_a("toolforge", true);
            FMLInterModComms.sendMessage((String)"tconstruct", (String)"integrateSmeltery", (NBTTagCompound)tag);
            registerVanillaRecipesForRedstone = true;
        }
        return f;
    }

    private static void redstone(FMLPostInitializationEvent event) {
        Fluid f = FluidRegistry.getFluid((String)REDSTONE_FLUID_NAME);
        if (f == null) {
            Log.warn("Thermal Foundation fluid 'redstone' is unexpectedly missing. Late registering our own.");
            f = AdditionalFluid.redstone((FMLPreInitializationEvent)null);
        }
        if (registerVanillaRecipesForRedstone) {
            TicProxy.registerSmelterySmelting(new ItemStack(Items.field_151137_ax), f, 100.0f);
            TicProxy.registerSmelterySmelting(new ItemStack(Blocks.field_150451_bX), f, 900.0f);
            TicProxy.registerBasinCasting(new ItemStack(Blocks.field_150451_bX), null, f, 900);
        }
    }

    private static Fluid ender(FMLPreInitializationEvent event) {
        Fluid f = new Fluid(ENDER_FLUID_NAME, TicProxy.TEX_FLOWING, TicProxy.TEX_STILL){

            public int getColor() {
                return -14976149;
            }
        };
        f.setDensity(4000);
        f.setLuminosity(3);
        f.setTemperature(1273);
        f.setViscosity(35);
        if (FluidRegistry.registerFluid((Fluid)f)) {
            BlockFluidEio.MoltenEnder block = new BlockFluidEio.MoltenEnder(f, Material.field_151586_h, 1801067);
            block.init();
            f.setBlock((Block)block);
            if (!EnderIO.proxy.isDedicatedServer()) {
                EnderIO.fluids.registerFluidBlockRendering(f, f.getName());
            }
            if (FluidRegistry.isUniversalBucketEnabled()) {
                FluidRegistry.addBucketForFluid((Fluid)f);
            }
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74778_a("fluid", f.getName());
            tag.func_74778_a("ore", "Ender");
            tag.func_74757_a("toolforge", true);
            FMLInterModComms.sendMessage((String)"tconstruct", (String)"integrateSmeltery", (NBTTagCompound)tag);
            registerVanillaRecipesForEnder = true;
        }
        return f;
    }

    private static void ender(FMLPostInitializationEvent event) {
        Fluid f = FluidRegistry.getFluid((String)ENDER_FLUID_NAME);
        if (f == null) {
            Log.warn("Thermal Foundation fluid 'ender' is unexpectedly missing. Late registering our own.");
            f = AdditionalFluid.ender((FMLPreInitializationEvent)null);
        }
        if (registerVanillaRecipesForEnder) {
            TicProxy.registerSmelterySmelting(new ItemStack(Items.field_151079_bi), f, 250.0f);
            Things cast = new Things("tconstruct:cast_custom:2");
            List<ItemStack> casts = cast.getItemStacks();
            if (!casts.isEmpty()) {
                TicProxy.registerTableCast(new ItemStack(Items.field_151079_bi), casts.get(0), f, 250.0f);
            }
        }
        TicProxy.registerSmelterySmelting(new ItemStack(ModObject.itemPowderIngot.getItem(), 1, PowderIngot.POWDER_ENDER.ordinal()), f, 27.0f);
    }
}

