/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.redstone;

import com.enderio.core.client.render.BoundingBox;
import com.enderio.core.client.render.IconUtil;
import com.enderio.core.common.util.BlockCoord;
import com.enderio.core.common.util.DyeColor;
import com.enderio.core.common.vecmath.Vector4f;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import crazypants.enderio.Log;
import crazypants.enderio.ModObject;
import crazypants.enderio.api.redstone.IRedstoneConnectable;
import crazypants.enderio.conduit.AbstractConduit;
import crazypants.enderio.conduit.AbstractConduitNetwork;
import crazypants.enderio.conduit.ConduitUtil;
import crazypants.enderio.conduit.ConnectionMode;
import crazypants.enderio.conduit.IConduit;
import crazypants.enderio.conduit.IConduitComponent;
import crazypants.enderio.conduit.RaytraceResult;
import crazypants.enderio.conduit.geom.CollidableCache;
import crazypants.enderio.conduit.geom.CollidableComponent;
import crazypants.enderio.conduit.geom.ConduitGeometryUtil;
import crazypants.enderio.conduit.redstone.IRedstoneConduit;
import crazypants.enderio.conduit.redstone.ISignalProvider;
import crazypants.enderio.conduit.redstone.RedstoneConduitNetwork;
import crazypants.enderio.conduit.redstone.Signal;
import crazypants.enderio.conduit.redstone.SignalSource;
import crazypants.enderio.conduit.render.BlockStateWrapperConduitBundle;
import crazypants.enderio.config.Config;
import crazypants.enderio.render.IBlockStateWrapper;
import crazypants.enderio.tool.ToolUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRedstoneWire;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class InsulatedRedstoneConduit
extends AbstractConduit
implements IRedstoneConduit,
IConduitComponent {
    static final Map<String, TextureAtlasSprite> ICONS = new HashMap<String, TextureAtlasSprite>();
    private static final List<Block> CONECTABLE_BLOCKS = Arrays.asList(Blocks.field_150379_bu, Blocks.field_150374_bv, Blocks.field_150429_aA, Blocks.field_150488_af, Blocks.field_150451_bX, Blocks.field_150367_z, Blocks.field_150442_at, Blocks.field_150471_bO, Blocks.field_150430_aB, Blocks.field_150452_aw, Blocks.field_150456_au, Blocks.field_150409_cd, Blocks.field_150453_bW, Blocks.field_180402_cm, Blocks.field_150483_bI, Blocks.field_150318_D, Blocks.field_150447_bR, Blocks.field_150331_J, Blocks.field_150320_F, Blocks.field_150323_B);
    private static Map<Class<?>, Boolean> CONNECTABLE_CLASSES = null;
    private static final List<ISignalProvider> SIGNAL_PROVIDERS = new ArrayList<ISignalProvider>();
    private Map<EnumFacing, ConnectionMode> forcedConnections = new EnumMap<EnumFacing, ConnectionMode>(EnumFacing.class);
    private Map<EnumFacing, DyeColor> signalColors = new EnumMap<EnumFacing, DyeColor>(EnumFacing.class);
    private Map<EnumFacing, Boolean> signalStrengths = new EnumMap<EnumFacing, Boolean>(EnumFacing.class);
    private volatile Map<EnumFacing, Boolean> specialConnections = null;
    private final List<Set<Signal>> externalSignals = new ArrayList<Set<Signal>>();
    private RedstoneConduitNetwork network;
    private int activeUpdateCooldown = 0;
    private boolean activeDirty = false;

    @SideOnly(value=Side.CLIENT)
    public static void initIcons() {
        IconUtil.addIconProvider((IconUtil.IIconProvider)new IconUtil.IIconProvider(){

            public void registerIcons(TextureMap register) {
                ICONS.put("enderio:blocks/redstoneInsulatedConduitCoreOff", register.func_174942_a(new ResourceLocation("enderio:blocks/redstoneInsulatedConduitCoreOff")));
                ICONS.put("enderio:blocks/redstoneInsulatedConduitCoreOn", register.func_174942_a(new ResourceLocation("enderio:blocks/redstoneInsulatedConduitCoreOn")));
                ICONS.put("enderio:blocks/redstoneInsulatedConduit", register.func_174942_a(new ResourceLocation("enderio:blocks/redstoneInsulatedConduit")));
                ICONS.put("enderio:blocks/redstoneConduit", register.func_174942_a(new ResourceLocation("enderio:blocks/redstoneConduit")));
                ICONS.put("enderio:blocks/redstoneConduitTransmission", register.func_174942_a(new ResourceLocation("enderio:blocks/redstoneConduitTransmission")));
            }
        });
    }

    public static void addConnectableBlock(NBTTagCompound nbt) {
        if (nbt == null) {
            Log.warn("InsulatedRedstoneConduit: An attempt was made to register a redstone connectable using a null NBT");
            return;
        }
        boolean connectable = true;
        if (nbt.func_74764_b("isConnectable")) {
            connectable = nbt.func_74767_n("isConnectable");
        }
        String className = nbt.func_74779_i("className");
        InsulatedRedstoneConduit.addConnectableInterface(className, connectable);
    }

    public static void addConnectableBlock(Block block) {
        if (block == null) {
            Log.warn("InsulatedRedstoneConduit: An attempt was made to register a redstone connectable using a null Block");
            return;
        }
        CONECTABLE_BLOCKS.add(block);
    }

    public static void addConnectableInterface(String className, boolean connectable) {
        try {
            Class<?> clz = Class.forName(className);
            InsulatedRedstoneConduit.addConnectableInterface(clz, connectable);
        }
        catch (Exception e) {
            Log.warn("InsulatedRedstoneConduit: An attempt was made to register " + className + " as connectable but it could not be loaded");
        }
    }

    public static void addConnectableInterface(Class<?> clazz, boolean connectable) {
        if (clazz == null) {
            Log.warn("InsulatedRedstoneConduit: An attempt was made to register a null class as a connectable");
            return;
        }
        InsulatedRedstoneConduit.getConnectableInterfaces().put(clazz, connectable);
    }

    private static Map<Class<?>, Boolean> getConnectableInterfaces() {
        if (CONNECTABLE_CLASSES == null) {
            CONNECTABLE_CLASSES = new HashMap();
            try {
                Class<?> conInterface = Class.forName("powercrystals.minefactoryreloaded.api.rednet.connectivity.IRedNetConnection");
                CONNECTABLE_CLASSES.put(conInterface, false);
            }
            catch (Throwable conInterface) {
                // empty catch block
            }
            try {
                Class<?> ccInterface = Class.forName("dan200.computercraft.shared.computer.blocks.IComputerTile");
                CONNECTABLE_CLASSES.put(ccInterface, true);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return CONNECTABLE_CLASSES;
    }

    public static void addSignalProvider(ISignalProvider provider) {
        SIGNAL_PROVIDERS.add(provider);
    }

    public InsulatedRedstoneConduit() {
        for (EnumFacing ignored : EnumFacing.field_82609_l) {
            this.externalSignals.add(new HashSet());
        }
    }

    public AbstractConduitNetwork<IRedstoneConduit, IRedstoneConduit> getNetwork() {
        return this.network;
    }

    @Override
    public boolean setNetwork(AbstractConduitNetwork<?, ?> network) {
        this.network = (RedstoneConduitNetwork)network;
        return true;
    }

    @Override
    public Class<? extends IConduit> getBaseConduitType() {
        return IRedstoneConduit.class;
    }

    @Override
    public void updateNetwork() {
        World world = this.getBundle().getEntity().func_145831_w();
        if (world != null) {
            this.updateNetwork(world);
        }
    }

    @Override
    public void updateEntity(World world) {
        super.updateEntity(world);
        if (!world.field_72995_K && this.activeUpdateCooldown > 0) {
            --this.activeUpdateCooldown;
            this.updateActiveState();
        }
    }

    @Override
    public void setActive(boolean active) {
        if (active != this.active) {
            this.activeDirty = true;
        }
        this.active = active;
        this.updateActiveState();
    }

    private void updateActiveState() {
        if (Config.redstoneConduitsShowState && this.activeDirty && this.activeUpdateCooldown == 0) {
            this.setClientStateDirty();
            this.activeDirty = false;
            this.activeUpdateCooldown = 4;
        }
    }

    @Override
    public void onChunkUnload(World worldObj) {
        RedstoneConduitNetwork network = (RedstoneConduitNetwork)this.getNetwork();
        if (network != null) {
            ArrayListMultimap oldSignals = ArrayListMultimap.create(network.getSignals());
            ArrayList conduits = Lists.newArrayList(network.getConduits());
            super.onChunkUnload(worldObj);
            network.afterChunkUnload(conduits, (Multimap<SignalSource, Signal>)oldSignals);
        }
    }

    @Override
    public boolean onBlockActivated(EntityPlayer player, EnumHand hand, RaytraceResult res, List<RaytraceResult> all) {
        World world = this.getBundle().getEntity().func_145831_w();
        if (!world.field_72995_K) {
            DyeColor col = DyeColor.getColorFromDye((ItemStack)player.func_184586_b(hand));
            if (col != null && res.component != null) {
                this.setSignalColor(res.component.dir, col);
                return true;
            }
            if (ToolUtil.isToolEquipped(player, hand) && res != null && res.component != null) {
                BlockCoord loc;
                EnumFacing connDir = res.component.dir;
                EnumFacing faceHit = res.movingObjectPosition.field_178784_b;
                boolean colorHit = false;
                if (all != null && this.containsExternalConnection(connDir)) {
                    for (RaytraceResult rtr : all) {
                        if (rtr == null || rtr.component == null || !"ColorController".equals(rtr.component.data)) continue;
                        colorHit = true;
                    }
                }
                if (colorHit) {
                    this.setSignalColor(connDir, DyeColor.getNext((DyeColor)this.getSignalColor(connDir)));
                    return true;
                }
                if (connDir == null || connDir == faceHit) {
                    loc = this.getLocation().getLocation(faceHit);
                    Block id = world.func_180495_p(loc.getBlockPos()).func_177230_c();
                    if (id == ModObject.blockConduitBundle.getBlock()) {
                        IRedstoneConduit neighbour = ConduitUtil.getConduit(world, loc.x, loc.y, loc.z, IRedstoneConduit.class);
                        if (neighbour != null && neighbour.getConnectionMode(faceHit.func_176734_d()) == ConnectionMode.DISABLED) {
                            neighbour.setConnectionMode(faceHit.func_176734_d(), ConnectionMode.NOT_SET);
                        }
                        this.setConnectionMode(faceHit, ConnectionMode.NOT_SET);
                        return ConduitUtil.joinConduits(this, faceHit);
                    }
                    this.forceConnectionMode(faceHit, ConnectionMode.IN_OUT);
                    return true;
                }
                if (this.externalConnections.contains(connDir)) {
                    if (this.network != null) {
                        this.network.destroyNetwork();
                    }
                    this.externalConnectionRemoved(connDir);
                    this.forceConnectionMode(connDir, ConnectionMode.DISABLED);
                    return true;
                }
                if (this.containsConduitConnection(connDir)) {
                    loc = this.getLocation().getLocation(connDir);
                    IRedstoneConduit neighbour = ConduitUtil.getConduit(this.getBundle().getEntity().func_145831_w(), loc.x, loc.y, loc.z, IRedstoneConduit.class);
                    if (neighbour != null) {
                        if (this.network != null) {
                            this.network.destroyNetwork();
                        }
                        if (neighbour.getNetwork() != null) {
                            neighbour.getNetwork().destroyNetwork();
                        }
                        neighbour.conduitConnectionRemoved(connDir.func_176734_d());
                        this.conduitConnectionRemoved(connDir);
                        neighbour.connectionsChanged();
                        this.connectionsChanged();
                        this.updateNetwork();
                        neighbour.updateNetwork();
                        return true;
                    }
                }
            }
        }
        return false;
    }

    @Override
    public void forceConnectionMode(EnumFacing dir, ConnectionMode mode) {
        if (mode == ConnectionMode.IN_OUT) {
            this.setConnectionMode(dir, mode);
            this.forcedConnections.put(dir, mode);
            this.onAddedToBundle();
            if (this.network != null) {
                this.network.updateInputsFromConduit(this);
            }
        } else {
            this.setConnectionMode(dir, mode);
            this.forcedConnections.put(dir, mode);
            this.onAddedToBundle();
            if (this.network != null) {
                this.network.updateInputsFromConduit(this);
            }
        }
    }

    @Override
    public ConnectionMode getNextConnectionMode(EnumFacing dir) {
        if (this.getConnectionMode(dir) == ConnectionMode.IN_OUT) {
            return ConnectionMode.DISABLED;
        }
        return ConnectionMode.IN_OUT;
    }

    @Override
    public ConnectionMode getPreviousConnectionMode(EnumFacing dir) {
        if (this.getConnectionMode(dir) == ConnectionMode.IN_OUT) {
            return ConnectionMode.DISABLED;
        }
        return ConnectionMode.IN_OUT;
    }

    @Override
    public ItemStack createItem() {
        return new ItemStack(ModObject.itemRedstoneConduit.getItem(), 1, 0);
    }

    @Override
    public void onInputsChanged(EnumFacing side, int[] inputValues) {
    }

    @Override
    public void onInputChanged(EnumFacing side, int inputValue) {
    }

    @Override
    public DyeColor getSignalColor(EnumFacing dir) {
        DyeColor res = this.signalColors.get(dir);
        if (res == null) {
            return DyeColor.RED;
        }
        return res;
    }

    @Override
    public void setSignalColor(EnumFacing dir, DyeColor col) {
        this.signalColors.put(dir, col);
        if (this.network != null) {
            this.network.updateInputsFromConduit(this);
        }
        this.setClientStateDirty();
    }

    @Override
    public boolean isOutputStrong(EnumFacing dir) {
        if (this.signalStrengths.containsKey(dir)) {
            return this.signalStrengths.get(dir);
        }
        return false;
    }

    @Override
    public void setOutputStrength(EnumFacing dir, boolean isStrong) {
        if (this.isOutputStrong(dir) != isStrong) {
            if (isStrong) {
                this.signalStrengths.put(dir, isStrong);
            } else {
                this.signalStrengths.remove(dir);
            }
            if (this.network != null) {
                this.network.notifyNeigborsOfSignalUpdate();
            }
        }
    }

    @Override
    public boolean canConnectToExternal(EnumFacing direction, boolean ignoreConnectionState) {
        if (ignoreConnectionState) {
            return true;
        }
        if (this.forcedConnections.get(direction) == ConnectionMode.DISABLED) {
            return false;
        }
        if (this.forcedConnections.get(direction) == ConnectionMode.IN_OUT) {
            return true;
        }
        BlockCoord loc = this.getLocation().getLocation(direction);
        World world = this.getBundle().getEntity().func_145831_w();
        IBlockState bs = world.func_180495_p(loc.getBlockPos());
        Block block = bs.func_177230_c();
        TileEntity te = world.func_175625_s(loc.getBlockPos());
        if (block == null || block == ModObject.blockConduitBundle.getBlock()) {
            return false;
        }
        if (block instanceof IRedstoneConnectable) {
            return ((IRedstoneConnectable)block).shouldRedstoneConduitConnect(world, loc.x, loc.y, loc.z, direction);
        }
        if (te instanceof IRedstoneConnectable) {
            return ((IRedstoneConnectable)te).shouldRedstoneConduitConnect(world, loc.x, loc.y, loc.z, direction);
        }
        if (block.canConnectRedstone(bs, (IBlockAccess)world, loc.getBlockPos(), direction.func_176734_d()) || CONECTABLE_BLOCKS.contains(block)) {
            return true;
        }
        if (bs.func_185897_m()) {
            return true;
        }
        Map<Class<?>, Boolean> connectableInterfaces = InsulatedRedstoneConduit.getConnectableInterfaces();
        for (Class<?> connectable : connectableInterfaces.keySet()) {
            if ((te == null || !connectable.isAssignableFrom(te.getClass())) && !connectable.isAssignableFrom(block.getClass())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isSpecialConnection(EnumFacing dir) {
        if (this.specialConnections == null) {
            this.computeSpecialConnections();
        }
        return this.specialConnections.get(dir);
    }

    protected void computeSpecialConnections() {
        EnumMap<EnumFacing, Boolean> temp = new EnumMap<EnumFacing, Boolean>(EnumFacing.class);
        block0: for (EnumFacing dir : EnumFacing.values()) {
            BlockCoord loc = this.getLocation().getLocation(dir);
            Block block = this.getBundle().getEntity().func_145831_w().func_180495_p(loc.getBlockPos()).func_177230_c();
            World world = this.getBundle().getEntity().func_145831_w();
            TileEntity te = world.func_175625_s(loc.getBlockPos());
            Map<Class<?>, Boolean> connectableInterfaces = InsulatedRedstoneConduit.getConnectableInterfaces();
            for (Class<?> connectable : connectableInterfaces.keySet()) {
                if ((te == null || !connectable.isAssignableFrom(te.getClass())) && (block == null || !connectable.isAssignableFrom(block.getClass()))) continue;
                temp.put(dir, connectableInterfaces.get(connectable));
                continue block0;
            }
            for (ISignalProvider provider : SIGNAL_PROVIDERS) {
                if (provider == null || !provider.connectsToNetwork(world, loc.getBlockPos(), dir.func_176734_d())) continue;
                temp.put(dir, true);
                continue block0;
            }
            temp.put(dir, false);
        }
        this.specialConnections = temp;
    }

    @Override
    public int isProvidingWeakPower(EnumFacing toDirection) {
        if (this.getConnectionMode(toDirection = toDirection.func_176734_d()) != ConnectionMode.IN_OUT) {
            return 0;
        }
        if (this.network == null || !this.network.isNetworkEnabled()) {
            return 0;
        }
        int result = 0;
        for (Signal signal : this.getNetworkOutputs(toDirection)) {
            if (signal.getPos().equals((Object)this.getPos().func_177972_a(toDirection))) continue;
            result = Math.max(result, signal.strength);
        }
        return result;
    }

    private BlockPos getPos() {
        return this.bundle.getEntity().func_174877_v();
    }

    @Override
    public int isProvidingStrongPower(EnumFacing toDirection) {
        if (this.isOutputStrong(toDirection.func_176734_d())) {
            return this.isProvidingWeakPower(toDirection);
        }
        return 0;
    }

    @Override
    public void externalConnectionAdded(EnumFacing fromDirection) {
        super.externalConnectionAdded(fromDirection);
        this.setConnectionMode(fromDirection, ConnectionMode.IN_OUT);
    }

    @Override
    public void externalConnectionRemoved(EnumFacing fromDirection) {
        super.externalConnectionRemoved(fromDirection);
        this.setConnectionMode(fromDirection, ConnectionMode.NOT_SET);
    }

    @Override
    public Collection<Signal> getNetworkOutputs(EnumFacing side) {
        if (side == null) {
            if (this.network == null) {
                return Collections.emptySet();
            }
            return this.network.getSignals().values();
        }
        ConnectionMode mode = this.getConnectionMode(side);
        if (this.network == null || mode != ConnectionMode.IN_OUT) {
            return Collections.emptySet();
        }
        Collection allSigs = this.network.getSignals().values();
        if (allSigs.isEmpty() || this.isSpecialConnection(side)) {
            return allSigs;
        }
        DyeColor col = this.getSignalColor(side);
        HashSet<Signal> result = new HashSet<Signal>();
        for (Signal signal : allSigs) {
            if (signal.color != col) continue;
            result.add(signal);
        }
        return result;
    }

    @Override
    public Set<Signal> getNetworkInputs(EnumFacing side) {
        if (this.network != null) {
            this.network.setNetworkEnabled(false);
        }
        HashSet<Signal> signals = new HashSet<Signal>();
        if (this.acceptSignalsForDir(side)) {
            if (this.isSpecialConnection(side)) {
                BlockCoord loc = this.getLocation().getLocation(side);
                World world = this.getBundle().getEntity().func_145831_w();
                for (ISignalProvider provider : SIGNAL_PROVIDERS) {
                    Set<Signal> inputs = provider.getNetworkInputs(world, loc.getBlockPos(), side.func_176734_d());
                    if (inputs == null) continue;
                    signals.addAll(inputs);
                }
            } else {
                int input = this.getExternalPowerLevel(side);
                if (input > 1) {
                    BlockCoord loc = this.getLocation().getLocation(side);
                    Signal signal = new Signal(loc.x, loc.y, loc.z, side, input - 1, this.getSignalColor(side));
                    signals.add(signal);
                }
            }
        }
        if (this.network != null) {
            this.network.setNetworkEnabled(true);
        }
        HashMap<DyeColor, Signal> res = new HashMap<DyeColor, Signal>();
        for (Signal signal : signals) {
            if (signal == null || res.containsKey(signal.color) && signal.strength <= ((Signal)res.get((Object)signal.color)).strength) continue;
            res.put(signal.color, signal);
        }
        return new HashSet<Signal>(res.values());
    }

    protected int getExternalPowerLevel(EnumFacing dir) {
        World world = this.getBundle().getEntity().func_145831_w();
        BlockCoord loc = this.getLocation();
        int strong = world.func_175627_a((loc = loc.getLocation(dir)).getBlockPos(), dir);
        if (strong > 0) {
            return strong;
        }
        int res = world.func_175651_c(loc.getBlockPos(), dir);
        IBlockState bs = world.func_180495_p(loc.getBlockPos());
        Block block = bs.func_177230_c();
        if (res < 15 && block == Blocks.field_150488_af) {
            int wireIn = (Integer)bs.func_177229_b((IProperty)BlockRedstoneWire.field_176351_O);
            res = Math.max(res, wireIn);
        }
        return res;
    }

    @Override
    public ConnectionMode getConnectionMode(EnumFacing dir) {
        ConnectionMode res = (ConnectionMode)((Object)this.conectionModes.get(dir));
        if (res == null) {
            return ConnectionMode.NOT_SET;
        }
        return res;
    }

    @Override
    public boolean onNeighborBlockChange(Block blockId) {
        World world = this.getBundle().getEntity().func_145831_w();
        if (world.field_72995_K) {
            return false;
        }
        boolean res = super.onNeighborBlockChange(blockId);
        if (this.network == null || this.network.updatingNetwork) {
            return false;
        }
        if (blockId != ModObject.blockConduitBundle.getBlock()) {
            this.network.updateInputsFromConduit(this);
        }
        this.computeSpecialConnections();
        return res;
    }

    @Override
    public boolean onNeighborChange(IBlockAccess world, BlockPos pos, BlockPos neighbourPos) {
        return false;
    }

    private boolean acceptSignalsForDir(EnumFacing dir) {
        if (this.getConnectionMode(dir) != ConnectionMode.IN_OUT) {
            return false;
        }
        BlockCoord loc = this.getLocation().getLocation(dir);
        return ConduitUtil.getConduit(this.getBundle().getEntity().func_145831_w(), loc.x, loc.y, loc.z, IRedstoneConduit.class) == null;
    }

    @Override
    public Collection<CollidableComponent> createCollidables(CollidableCache.CacheKey key) {
        Collection<CollidableComponent> baseCollidables = super.createCollidables(key);
        if (key.dir == null) {
            return baseCollidables;
        }
        BoundingBox bb = ConduitGeometryUtil.instance.createBoundsForConnectionController(key.dir, key.offset);
        CollidableComponent cc = new CollidableComponent(IRedstoneConduit.class, bb, key.dir, "ColorController");
        ArrayList<CollidableComponent> result = new ArrayList<CollidableComponent>();
        result.addAll(baseCollidables);
        result.add(cc);
        return result;
    }

    @Override
    public TextureAtlasSprite getTextureForState(CollidableComponent component) {
        if (component.dir == null) {
            return Config.redstoneConduitsShowState && this.isActive() ? ICONS.get("enderio:blocks/redstoneInsulatedConduitCoreOn") : ICONS.get("enderio:blocks/redstoneInsulatedConduitCoreOff");
        }
        if ("ColorController".equals(component.data)) {
            return IconUtil.instance.whiteTexture;
        }
        return ICONS.get("enderio:blocks/redstoneInsulatedConduit");
    }

    @Override
    public TextureAtlasSprite getTransmitionTextureForState(CollidableComponent component) {
        return Config.redstoneConduitsShowState && this.isActive() ? ICONS.get("enderio:blocks/redstoneConduitTransmission") : ICONS.get("enderio:blocks/redstoneConduit");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Vector4f getTransmitionTextureColorForState(CollidableComponent component) {
        return null;
    }

    @Override
    protected boolean renderStub(EnumFacing dir) {
        return false;
    }

    @Override
    protected void readTypeSettings(EnumFacing dir, NBTTagCompound dataRoot) {
        this.setSignalColor(dir, DyeColor.values()[dataRoot.func_74765_d("signalColor")]);
        this.setOutputStrength(dir, dataRoot.func_74767_n("signalStrong"));
    }

    @Override
    protected void writeTypeSettingsToNbt(EnumFacing dir, NBTTagCompound dataRoot) {
        dataRoot.func_74777_a("signalColor", (short)this.getSignalColor(dir).ordinal());
        dataRoot.func_74757_a("signalStrong", this.isOutputStrong(dir));
    }

    @Override
    public void writeToNBT(NBTTagCompound nbtRoot) {
        int i;
        byte[] modes;
        super.writeToNBT(nbtRoot);
        if (this.forcedConnections.size() >= 0) {
            modes = new byte[6];
            i = 0;
            for (EnumFacing dir : EnumFacing.field_82609_l) {
                ConnectionMode mode = this.forcedConnections.get(dir);
                modes[i] = mode != null ? (int)mode.ordinal() : -1;
                ++i;
            }
            nbtRoot.func_74773_a("forcedConnections", modes);
        }
        if (this.signalColors.size() >= 0) {
            modes = new byte[6];
            i = 0;
            for (EnumFacing dir : EnumFacing.field_82609_l) {
                DyeColor col = this.signalColors.get(dir);
                modes[i] = col != null ? (int)col.ordinal() : -1;
                ++i;
            }
            nbtRoot.func_74773_a("signalColors", modes);
        }
        if (this.signalStrengths.size() >= 0) {
            modes = new byte[6];
            i = 0;
            for (EnumFacing dir : EnumFacing.field_82609_l) {
                boolean isStrong = this.isOutputStrong(dir);
                modes[i] = isStrong ? (byte)1 : 0;
                ++i;
            }
            nbtRoot.func_74773_a("signalStrengths", modes);
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound nbtRoot, short nbtVersion) {
        super.readFromNBT(nbtRoot, nbtVersion);
        this.forcedConnections.clear();
        byte[] modes = nbtRoot.func_74770_j("forcedConnections");
        if (modes != null && modes.length == 6) {
            int i = 0;
            for (EnumFacing dir : EnumFacing.field_82609_l) {
                if (modes[i] >= 0) {
                    this.forcedConnections.put(dir, ConnectionMode.values()[modes[i]]);
                }
                ++i;
            }
        }
        this.signalColors.clear();
        byte[] cols = nbtRoot.func_74770_j("signalColors");
        if (cols != null && cols.length == 6) {
            int i = 0;
            for (EnumFacing dir : EnumFacing.field_82609_l) {
                if (cols[i] >= 0) {
                    this.signalColors.put(dir, DyeColor.values()[cols[i]]);
                }
                ++i;
            }
        }
        this.signalStrengths.clear();
        byte[] strengths = nbtRoot.func_74770_j("signalStrengths");
        if (strengths != null && strengths.length == 6) {
            int i = 0;
            for (EnumFacing dir : EnumFacing.field_82609_l) {
                if (strengths[i] > 0) {
                    this.signalStrengths.put(dir, true);
                }
                ++i;
            }
        }
    }

    @Override
    public String toString() {
        return "RedstoneConduit [network=" + this.network + " connections=" + this.conduitConnections + " active=" + this.active + "]";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void hashCodeForModelCaching(IBlockStateWrapper wrapper, BlockStateWrapperConduitBundle.ConduitCacheKey hashCodes) {
        super.hashCodeForModelCaching(wrapper, hashCodes);
        hashCodes.addEnum(this.signalColors);
        if (this.specialConnections == null) {
            this.computeSpecialConnections();
        }
        hashCodes.addBoolean(this.specialConnections);
        if (Config.redstoneConduitsShowState && this.isActive()) {
            hashCodes.add(1);
        }
    }

    public RedstoneConduitNetwork createNetworkForType() {
        return new RedstoneConduitNetwork();
    }
}

