/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.power;

import com.enderio.core.client.render.BoundingBox;
import com.enderio.core.client.render.ColorUtil;
import com.enderio.core.common.util.ForgeDirectionOffsets;
import com.enderio.core.common.vecmath.Vector3d;
import com.enderio.core.common.vecmath.Vector4f;
import crazypants.enderio.conduit.ConnectionMode;
import crazypants.enderio.conduit.IConduit;
import crazypants.enderio.conduit.IConduitBundle;
import crazypants.enderio.conduit.geom.CollidableComponent;
import crazypants.enderio.conduit.geom.ConnectionModeGeometry;
import crazypants.enderio.conduit.geom.Offset;
import crazypants.enderio.conduit.power.IPowerConduit;
import crazypants.enderio.conduit.render.DefaultConduitRenderer;
import crazypants.enderio.machine.RedstoneControlMode;
import java.util.List;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.EnumFacing;

public class PowerConduitRenderer
extends DefaultConduitRenderer {
    @Override
    public boolean isRendererForConduit(IConduit conduit) {
        return conduit instanceof IPowerConduit;
    }

    @Override
    protected void addConduitQuads(IConduitBundle bundle, IConduit conduit, TextureAtlasSprite tex, CollidableComponent component, float selfIllum, List<BakedQuad> quads) {
        if ("ColorController".equals(component.data)) {
            IPowerConduit pc = (IPowerConduit)conduit;
            ConnectionMode conMode = pc.getConnectionMode(component.dir);
            if (conduit.containsExternalConnection(component.dir) && pc.getExtractionRedstoneMode(component.dir) != RedstoneControlMode.IGNORE && conMode != ConnectionMode.DISABLED) {
                int cInt = ((IPowerConduit)conduit).getExtractionSignalColor(component.dir).getColor();
                Vector4f col = ColorUtil.toFloat4((int)cInt);
                BoundingBox bound = component.bound;
                if (conMode != ConnectionMode.IN_OUT && conMode != ConnectionMode.NOT_SET) {
                    Vector3d trans = ForgeDirectionOffsets.offsetScaled((EnumFacing)component.dir, (double)-0.12);
                    bound = bound.translate(trans);
                }
                this.addQuadsForSection(bound, tex, component.dir, quads, col);
            }
            return;
        }
        super.addConduitQuads(bundle, conduit, tex, component, selfIllum, quads);
        if (component.dir == null) {
            return;
        }
        IPowerConduit pc = (IPowerConduit)conduit;
        ConnectionMode mode = pc.getConnectionMode(component.dir);
        if (mode != ConnectionMode.INPUT && mode != ConnectionMode.OUTPUT) {
            return;
        }
        tex = mode == ConnectionMode.INPUT ? pc.getTextureForInputMode() : pc.getTextureForOutputMode();
        Offset offset = bundle.getOffset(IPowerConduit.class, component.dir);
        ConnectionModeGeometry.addModeConnectorQuads(component.dir, offset, tex, null, quads);
    }
}

