/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.gui.item;

import com.enderio.core.api.client.gui.IGuiScreen;
import com.enderio.core.api.client.render.IWidgetIcon;
import com.enderio.core.client.gui.button.CycleButton;
import com.enderio.core.client.gui.button.IconButton;
import com.enderio.core.client.gui.button.ToggleButton;
import crazypants.enderio.EnderIO;
import crazypants.enderio.conduit.gui.GuiExternalConnection;
import crazypants.enderio.conduit.gui.item.IItemFilterContainer;
import crazypants.enderio.conduit.gui.item.IItemFilterGui;
import crazypants.enderio.conduit.item.filter.SpeciesItemFilter;
import crazypants.enderio.conduit.item.filter.SpeciesMode;
import crazypants.enderio.gui.GuiContainerBaseEIO;
import crazypants.enderio.gui.IconEIO;
import net.minecraft.client.gui.GuiButton;
import org.lwjgl.opengl.GL11;

public class SpeciesItemFilterGui
implements IItemFilterGui {
    private static final int ID_WHITELIST = GuiExternalConnection.nextButtonId();
    private static final int ID_SPECIES_MODE = GuiExternalConnection.nextButtonId();
    private static final int ID_STICKY = GuiExternalConnection.nextButtonId();
    private final GuiContainerBaseEIO gui;
    private final IconButton whiteListB;
    private final CycleButton<SpeciesMode.IconHolder> speciesModeB;
    private final ToggleButton stickyB;
    final boolean isStickyModeAvailable;
    private final IItemFilterContainer filterContainer;
    private final SpeciesItemFilter filter;
    private int buttonIdOffset;
    private int xOffset;
    private int yOffset;

    public SpeciesItemFilterGui(GuiContainerBaseEIO gui, IItemFilterContainer filterContainer, boolean isStickyModeAvailable) {
        this(gui, filterContainer, isStickyModeAvailable, 32, 68, 0);
    }

    public SpeciesItemFilterGui(GuiContainerBaseEIO gui, IItemFilterContainer filterContainer, boolean isStickyModeAvailable, int xOffset, int yOffset, int buttonIdOffset) {
        int butLeft;
        this.gui = gui;
        this.isStickyModeAvailable = isStickyModeAvailable;
        this.filterContainer = filterContainer;
        this.xOffset = xOffset;
        this.yOffset = yOffset;
        this.buttonIdOffset = buttonIdOffset;
        this.filter = (SpeciesItemFilter)filterContainer.getItemFilter();
        int x = butLeft = xOffset + 92;
        int y = yOffset + 1;
        this.whiteListB = new IconButton((IGuiScreen)gui, ID_WHITELIST + buttonIdOffset, x, y, (IWidgetIcon)IconEIO.FILTER_WHITELIST);
        this.whiteListB.setToolTip(new String[]{EnderIO.lang.localize("gui.conduit.item.whitelist")});
        this.stickyB = new ToggleButton((IGuiScreen)gui, ID_STICKY + buttonIdOffset, x += 20, y, (IWidgetIcon)IconEIO.FILTER_STICKY_OFF, (IWidgetIcon)IconEIO.FILTER_STICKY);
        this.stickyB.setSelectedToolTip(EnderIO.lang.localizeList("gui.conduit.item.stickyEnabled"));
        this.stickyB.setUnselectedToolTip(new String[]{EnderIO.lang.localize("gui.conduit.item.stickyDisbaled")});
        this.stickyB.setPaintSelectedBorder(false);
        x = butLeft;
        this.speciesModeB = new CycleButton((IGuiScreen)gui, ID_SPECIES_MODE + buttonIdOffset, x, y += 20, SpeciesMode.IconHolder.class);
    }

    public void createFilterSlots() {
        this.filter.createGhostSlots(this.gui.getGhostSlots(), this.xOffset + 1, this.yOffset + 1, new Runnable(){

            @Override
            public void run() {
                SpeciesItemFilterGui.this.sendFilterChange();
            }
        });
    }

    @Override
    public void mouseClicked(int x, int y, int par3) {
    }

    @Override
    public void updateButtons() {
        if (this.isStickyModeAvailable) {
            this.stickyB.onGuiInit();
            this.stickyB.setSelected(this.filter.isSticky());
        }
        this.whiteListB.onGuiInit();
        if (this.filter.isBlacklist()) {
            this.whiteListB.setIcon((IWidgetIcon)IconEIO.FILTER_BLACKLIST);
            this.whiteListB.setToolTip(new String[]{EnderIO.lang.localize("gui.conduit.item.blacklist")});
        } else {
            this.whiteListB.setIcon((IWidgetIcon)IconEIO.FILTER_WHITELIST);
            this.whiteListB.setToolTip(new String[]{EnderIO.lang.localize("gui.conduit.item.whitelist")});
        }
        this.speciesModeB.onGuiInit();
        this.speciesModeB.setMode((Enum)SpeciesMode.IconHolder.getFromMode(this.filter.getSpeciesMode()));
    }

    @Override
    public void actionPerformed(GuiButton guiButton) {
        if (guiButton.field_146127_k == ID_STICKY + this.buttonIdOffset) {
            this.filter.setSticky(this.stickyB.isSelected());
            this.sendFilterChange();
        } else if (guiButton.field_146127_k == ID_SPECIES_MODE + this.buttonIdOffset) {
            this.filter.setSpeciesMode(((SpeciesMode.IconHolder)this.speciesModeB.getMode()).getMode());
            this.sendFilterChange();
        } else if (guiButton.field_146127_k == ID_WHITELIST + this.buttonIdOffset) {
            this.filter.setBlacklist(!this.filter.isBlacklist());
            this.sendFilterChange();
        }
    }

    private void sendFilterChange() {
        this.updateButtons();
        this.filterContainer.onFilterChanged();
    }

    @Override
    public void deactivate() {
        this.whiteListB.detach();
        this.stickyB.detach();
        this.speciesModeB.detach();
    }

    @Override
    public void renderCustomOptions(int top, float par1, int par2, int par3) {
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        this.gui.bindGuiTexture(1);
        this.gui.func_73729_b(this.gui.getGuiLeft() + this.xOffset, this.gui.getGuiTop() + this.yOffset, 0, 238, 90, 18);
        this.gui.func_73729_b(this.gui.getGuiLeft() + this.xOffset, this.gui.getGuiTop() + this.yOffset + 20, 0, 238, 90, 18);
    }
}

