/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.gui;

import com.enderio.core.api.client.gui.IGuiScreen;
import com.enderio.core.client.gui.button.ColorButton;
import com.enderio.core.common.util.DyeColor;
import crazypants.enderio.EnderIO;
import crazypants.enderio.conduit.IConduit;
import crazypants.enderio.conduit.gui.BaseSettingsPanel;
import crazypants.enderio.conduit.gui.GuiExternalConnection;
import crazypants.enderio.conduit.packet.PacketExtractMode;
import crazypants.enderio.conduit.power.IPowerConduit;
import crazypants.enderio.gui.IconEIO;
import crazypants.enderio.gui.RedstoneModeButton;
import crazypants.enderio.machine.IRedstoneModeControlable;
import crazypants.enderio.machine.RedstoneControlMode;
import crazypants.enderio.network.PacketHandler;
import net.minecraft.client.gui.GuiButton;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class PowerSettings
extends BaseSettingsPanel {
    private static final int ID_REDSTONE_BUTTON = GuiExternalConnection.nextButtonId();
    private static final int ID_COLOR_BUTTON = GuiExternalConnection.nextButtonId();
    private IPowerConduit conduit;
    private RedstoneModeButton rsB;
    private ColorButton colorB;

    protected PowerSettings(final GuiExternalConnection gui, IConduit con) {
        super(IconEIO.WRENCH_OVERLAY_POWER, EnderIO.lang.localize("itemPowerConduit.name"), gui, con);
        this.conduit = (IPowerConduit)con;
        int x = 38;
        int y = this.customTop;
        this.rsB = new RedstoneModeButton((IGuiScreen)gui, ID_REDSTONE_BUTTON, x, y, new IRedstoneModeControlable(){

            @Override
            public void setRedstoneControlMode(RedstoneControlMode mode) {
                RedstoneControlMode curMode = this.getRedstoneControlMode();
                PowerSettings.this.conduit.setExtractionRedstoneMode(mode, gui.getDir());
                if (curMode != mode) {
                    PacketHandler.INSTANCE.sendToServer((IMessage)new PacketExtractMode(PowerSettings.this.conduit, gui.getDir()));
                }
            }

            @Override
            public RedstoneControlMode getRedstoneControlMode() {
                return PowerSettings.this.conduit.getExtractionRedstoneMode(gui.getDir());
            }

            @Override
            public boolean getRedstoneControlStatus() {
                return false;
            }
        });
        this.colorB = new ColorButton((IGuiScreen)gui, ID_COLOR_BUTTON, x += this.rsB.getWidth() + this.gap, y);
        this.colorB.setToolTipHeading(EnderIO.lang.localize("gui.conduit.redstone.signalColor"));
        this.colorB.setColorIndex(this.conduit.getExtractionSignalColor(gui.getDir()).ordinal());
    }

    @Override
    public void actionPerformed(GuiButton guiButton) {
        super.actionPerformed(guiButton);
        if (guiButton.field_146127_k == ID_COLOR_BUTTON) {
            this.conduit.setExtractionSignalColor(this.gui.getDir(), DyeColor.values()[this.colorB.getColorIndex()]);
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketExtractMode(this.conduit, this.gui.getDir()));
        }
    }

    @Override
    protected void initCustomOptions() {
        super.initCustomOptions();
        this.rsB.onGuiInit();
        this.colorB.onGuiInit();
    }

    @Override
    public void deactivate() {
        super.deactivate();
        this.rsB.detach();
        this.colorB.detach();
    }
}

