/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.itemscroller.event;

import fi.dy.masa.itemscroller.event.InputEventHandler;
import fi.dy.masa.itemscroller.recipes.RecipeStorage;
import fi.dy.masa.itemscroller.util.InventoryUtils;
import java.nio.FloatBuffer;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class RenderEventHandler {
    private static final Vec3d LIGHT0_POS = new Vec3d(0.2, 1.0, -0.7).func_72432_b();
    private static final Vec3d LIGHT1_POS = new Vec3d(-0.2, 1.0, 0.7).func_72432_b();
    private static boolean renderRecipes;

    @SubscribeEvent
    public void onDrawBackground(GuiScreenEvent.BackgroundDrawnEvent event) {
        if (renderRecipes && event.getGui() instanceof GuiContainer) {
            GuiContainer gui = (GuiContainer)event.getGui();
            RecipeStorage recipes = InputEventHandler.instance().getRecipes();
            int count = recipes.getRecipeCount();
            for (int recipeId = 0; recipeId < count; ++recipeId) {
                this.renderStoredRecipeStack(recipeId, count, recipes.getRecipe(recipeId).getResult(), gui, gui.field_146297_k, recipeId == recipes.getSelection());
            }
        }
    }

    @SubscribeEvent
    public void onDrawScreen(GuiScreenEvent.DrawScreenEvent.Post event) {
        if (renderRecipes && event.getGui() instanceof GuiContainer) {
            GuiContainer gui = (GuiContainer)event.getGui();
            RecipeStorage recipes = InputEventHandler.instance().getRecipes();
            this.renderHoverTooltip(event.getMouseX(), event.getMouseY(), recipes, gui, gui.field_146297_k);
        }
    }

    public static void setRenderStoredRecipes(boolean render) {
        renderRecipes = render;
    }

    public static boolean getRenderStoredRecipes() {
        return renderRecipes;
    }

    private void renderHoverTooltip(int mouseX, int mouseY, RecipeStorage recipes, GuiContainer gui, Minecraft mc) {
        int guiLeft = 0;
        try {
            guiLeft = InputEventHandler.fieldGuiLeft.getInt(gui);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ScaledResolution scaledResolution = new ScaledResolution(mc);
        int gap = 40;
        int recipesPerColumn = 9;
        int stackBaseHeight = 16;
        int usableHeight = scaledResolution.func_78328_b() - 80;
        int entryHeight = usableHeight / 9;
        float scale = (float)entryHeight / 20.0f;
        int stackScaledSize = (int)(16.0f * scale);
        int recipeCount = recipes.getRecipeCount();
        for (int slot = 0; slot < recipeCount; ++slot) {
            int columnOffsetCount = recipeCount / 9 - slot / 9;
            float x = (float)guiLeft - ((float)columnOffsetCount + 0.2f) * (float)stackScaledSize - (float)(columnOffsetCount - 1) * scale * 20.0f;
            int y = (int)(40.0f + 0.25f * (float)stackScaledSize + (float)(slot % 9 * entryHeight));
            if (!((float)mouseX >= x) || !((float)mouseX < x + (float)stackScaledSize) || mouseY < y || mouseY >= y + stackScaledSize) continue;
            ItemStack stack = recipes.getRecipe(slot).getResult();
            if (InventoryUtils.isStackEmpty(stack)) break;
            this.renderStackToolTip(mouseX, mouseY, stack, gui, mc);
            break;
        }
    }

    private void renderStoredRecipeStack(int recipeId, int recipeCount, ItemStack stack, GuiContainer gui, Minecraft mc, boolean selected) {
        int guiLeft = 0;
        try {
            guiLeft = InputEventHandler.fieldGuiLeft.getInt(gui);
        }
        catch (Exception exception) {
            // empty catch block
        }
        FontRenderer font = RenderEventHandler.getFontRenderer(mc, stack);
        String indexStr = String.valueOf(recipeId + 1);
        int strWidth = font.func_78256_a(indexStr);
        ScaledResolution scaledResolution = new ScaledResolution(mc);
        int gap = 40;
        int recipesPerColumn = 9;
        int stackBaseHeight = 16;
        int usableHeight = scaledResolution.func_78328_b() - 80;
        int entryHeight = usableHeight / 9;
        float scale = (float)entryHeight / 20.0f;
        int stackScaledSize = (int)(16.0f * scale);
        int columnOffsetCount = recipeCount / 9 - recipeId / 9;
        float xPosition = (float)guiLeft - ((float)columnOffsetCount + 0.2f) * (float)stackScaledSize - (float)(columnOffsetCount - 1) * scale * 20.0f;
        float yPosition = 40.0f + 0.25f * (float)stackScaledSize + (float)(recipeId % 9 * entryHeight);
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)xPosition, (float)yPosition, (float)0.0f);
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)1.0f);
        int w = 16;
        if (selected) {
            Gui.func_73734_a((int)0, (int)0, (int)16, (int)1, (int)-1);
            Gui.func_73734_a((int)0, (int)0, (int)1, (int)16, (int)-1);
            Gui.func_73734_a((int)15, (int)0, (int)16, (int)16, (int)-1);
            Gui.func_73734_a((int)0, (int)15, (int)16, (int)16, (int)-1);
        }
        if (!InventoryUtils.isStackEmpty(stack)) {
            if (selected) {
                Gui.func_73734_a((int)1, (int)1, (int)15, (int)15, (int)0x20FFFFFF);
            } else {
                Gui.func_73734_a((int)0, (int)0, (int)16, (int)16, (int)0x20FFFFFF);
            }
            RenderEventHandler.enableGUIStandardItemLighting(scale);
            stack = stack.func_77946_l();
            InventoryUtils.setStackSize(stack, 1);
            mc.func_175599_af().field_77023_b += 100.0f;
            mc.func_175599_af().func_184391_a((EntityLivingBase)mc.field_71439_g, stack, 0, 0);
            mc.func_175599_af().func_180453_a(font, stack, 0, 0, null);
            mc.func_175599_af().field_77023_b -= 100.0f;
        }
        GlStateManager.func_179084_k();
        RenderHelper.func_74518_a();
        GlStateManager.func_179121_F();
        font.func_78276_b(indexStr, (int)(xPosition - scale * (float)strWidth), (int)(yPosition + (float)((entryHeight - font.field_78288_b) / 2) - 2.0f), 0xC0C0C0);
    }

    public static void enableGUIStandardItemLighting(float scale) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179114_b((float)-30.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)165.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        RenderEventHandler.enableStandardItemLighting(scale);
        GlStateManager.func_179121_F();
    }

    public static void enableStandardItemLighting(float scale) {
        GlStateManager.func_179145_e();
        GlStateManager.func_179085_a((int)0);
        GlStateManager.func_179085_a((int)1);
        GlStateManager.func_179142_g();
        GlStateManager.func_179104_a((int)1032, (int)5634);
        GlStateManager.func_187438_a((int)16384, (int)4611, (FloatBuffer)RenderHelper.func_74521_a((float)((float)RenderEventHandler.LIGHT0_POS.field_72450_a), (float)((float)RenderEventHandler.LIGHT0_POS.field_72448_b), (float)((float)RenderEventHandler.LIGHT0_POS.field_72449_c), (float)0.0f));
        float lightStrength = 0.3f * scale;
        GlStateManager.func_187438_a((int)16384, (int)4609, (FloatBuffer)RenderHelper.func_74521_a((float)lightStrength, (float)lightStrength, (float)lightStrength, (float)1.0f));
        GlStateManager.func_187438_a((int)16384, (int)4608, (FloatBuffer)RenderHelper.func_74521_a((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f));
        GlStateManager.func_187438_a((int)16384, (int)4610, (FloatBuffer)RenderHelper.func_74521_a((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f));
        GlStateManager.func_187438_a((int)16385, (int)4611, (FloatBuffer)RenderHelper.func_74521_a((float)((float)RenderEventHandler.LIGHT1_POS.field_72450_a), (float)((float)RenderEventHandler.LIGHT1_POS.field_72448_b), (float)((float)RenderEventHandler.LIGHT1_POS.field_72449_c), (float)0.0f));
        GlStateManager.func_187438_a((int)16385, (int)4609, (FloatBuffer)RenderHelper.func_74521_a((float)lightStrength, (float)lightStrength, (float)lightStrength, (float)1.0f));
        GlStateManager.func_187438_a((int)16385, (int)4608, (FloatBuffer)RenderHelper.func_74521_a((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f));
        GlStateManager.func_187438_a((int)16385, (int)4610, (FloatBuffer)RenderHelper.func_74521_a((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f));
        GlStateManager.func_179103_j((int)7424);
        float ambientLightStrength = 0.4f;
        GlStateManager.func_187424_a((int)2899, (FloatBuffer)RenderHelper.func_74521_a((float)ambientLightStrength, (float)ambientLightStrength, (float)ambientLightStrength, (float)1.0f));
    }

    private static FontRenderer getFontRenderer(Minecraft mc, ItemStack stack) {
        FontRenderer fontRenderer = null;
        if (!InventoryUtils.isStackEmpty(stack)) {
            fontRenderer = stack.func_77973_b().getFontRenderer(stack);
        }
        return fontRenderer != null ? fontRenderer : mc.field_71466_p;
    }

    private void renderStackToolTip(int x, int y, ItemStack stack, GuiContainer gui, Minecraft mc) {
        List list = stack.func_82840_a((EntityPlayer)mc.field_71439_g, mc.field_71474_y.field_82882_x);
        for (int i = 0; i < list.size(); ++i) {
            if (i == 0) {
                list.set(i, stack.func_77953_t().field_77937_e + (String)list.get(i));
                continue;
            }
            list.set(i, TextFormatting.GRAY + (String)list.get(i));
        }
        FontRenderer font = stack.func_77973_b().getFontRenderer(stack);
        if (font == null) {
            font = mc.field_71466_p;
        }
        GuiUtils.preItemToolTip((ItemStack)stack);
        GuiUtils.drawHoveringText((List)list, (int)x, (int)y, (int)gui.field_146294_l, (int)gui.field_146295_m, (int)-1, (FontRenderer)font);
        GuiUtils.postItemToolTip();
    }
}

