/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.itemscroller.event;

import fi.dy.masa.itemscroller.ItemScroller;
import fi.dy.masa.itemscroller.config.Configs;
import fi.dy.masa.itemscroller.event.RenderEventHandler;
import fi.dy.masa.itemscroller.proxy.ClientProxy;
import fi.dy.masa.itemscroller.recipes.RecipeStorage;
import fi.dy.masa.itemscroller.util.InventoryUtils;
import fi.dy.masa.itemscroller.util.MethodHandleUtils;
import java.lang.invoke.MethodHandle;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.gui.inventory.GuiContainerCreative;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.SlotItemHandler;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

@SideOnly(value=Side.CLIENT)
public class InputEventHandler {
    private static InputEventHandler instance;
    private boolean disabled;
    private int lastPosX;
    private int lastPosY;
    private int slotNumberLast;
    private final Set<Integer> draggedSlots = new HashSet<Integer>();
    private WeakReference<Slot> sourceSlotCandidate = new WeakReference<Object>(null);
    private WeakReference<Slot> sourceSlot = new WeakReference<Object>(null);
    private ItemStack stackInCursorLast = InventoryUtils.EMPTY_STACK;
    private RecipeStorage recipes;
    private static final MethodHandle methodHandle_getSlotAtPosition;
    public static final Field fieldGuiLeft;
    public static final Field fieldGuiTop;
    public static final Field fieldGuiXSize;
    public static final Field fieldGuiYSize;

    public InputEventHandler() {
        this.initializeRecipeStorage();
        instance = this;
    }

    public static InputEventHandler instance() {
        return instance;
    }

    @SubscribeEvent
    public void onMouseInputEventPre(GuiScreenEvent.MouseInputEvent.Pre event) {
        if (!this.disabled && event.getGui() instanceof GuiContainer && !(event.getGui() instanceof GuiContainerCreative) && event.getGui().field_146297_k != null && event.getGui().field_146297_k.field_71439_g != null && !Configs.GUI_BLACKLIST.contains(event.getGui().getClass().getName())) {
            GuiContainer gui = (GuiContainer)event.getGui();
            int dWheel = Mouse.getEventDWheel();
            boolean cancel = false;
            if (dWheel != 0) {
                if (RenderEventHandler.getRenderStoredRecipes()) {
                    this.recipes.scrollSelection(dWheel < 0);
                } else {
                    cancel = InventoryUtils.tryMoveItems(gui, this.recipes, dWheel > 0);
                }
            } else {
                this.checkForItemPickup(gui);
                this.storeSourceSlotCandidate(gui);
                if (Configs.enableRightClickCraftingOneStack && Mouse.getEventButton() == 1 && InventoryUtils.isCraftingSlot(gui, gui.getSlotUnderMouse())) {
                    InventoryUtils.rightClickCraftOneStack(gui);
                } else if (Configs.enableShiftPlaceItems && InventoryUtils.canShiftPlaceItems(gui)) {
                    cancel = this.shiftPlaceItems(gui);
                } else if (Configs.enableShiftDropItems && this.canShiftDropItems(gui)) {
                    cancel = this.shiftDropItems(gui);
                } else if (Configs.enableDragMovingShiftLeft || Configs.enableDragMovingShiftRight || Configs.enableDragMovingControlLeft) {
                    cancel = this.dragMoveItems(gui);
                }
            }
            if (cancel) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onKeyInputEventPre(GuiScreenEvent.KeyboardInputEvent.Pre event) {
        if (!(event.getGui() instanceof GuiContainer) || event.getGui().field_146297_k == null || event.getGui().field_146297_k.field_71439_g == null) {
            return;
        }
        GuiContainer gui = (GuiContainer)event.getGui();
        if (Keyboard.getEventKey() == 23 && Keyboard.getEventKeyState() && GuiScreen.func_175283_s() && GuiScreen.func_146271_m() && GuiScreen.func_146272_n()) {
            if (gui.getSlotUnderMouse() != null) {
                InputEventHandler.debugPrintSlotInfo(gui, gui.getSlotUnderMouse());
            } else {
                ItemScroller.logger.info("GUI class: {}", new Object[]{gui.getClass().getName()});
            }
        } else if (Configs.enableControlShiftDropkeyDropItems && Keyboard.getEventKeyState() && !Configs.GUI_BLACKLIST.contains(gui.getClass().getName()) && GuiScreen.func_146271_m() && GuiScreen.func_146272_n() && gui.field_146297_k.field_71474_y.field_74316_C.isActiveAndMatches(Keyboard.getEventKey())) {
            Slot slot = gui.getSlotUnderMouse();
            if (slot != null && slot.func_75216_d()) {
                InventoryUtils.dropStacks(gui, slot.func_75211_c(), slot);
            }
        } else if (Keyboard.getEventKeyState() && ClientProxy.KEY_DISABLE.isActiveAndMatches(Keyboard.getEventKey())) {
            boolean bl = this.disabled = !this.disabled;
            if (this.disabled) {
                gui.field_146297_k.field_71439_g.func_184185_a(SoundEvents.field_187679_dF, 0.8f, 0.8f);
            } else {
                gui.field_146297_k.field_71439_g.func_184185_a(SoundEvents.field_189107_dL, 0.5f, 1.0f);
            }
        } else if (Keyboard.getEventKey() == ClientProxy.KEY_RECIPE.func_151463_i()) {
            if (Keyboard.getEventKeyState()) {
                RenderEventHandler.setRenderStoredRecipes(true);
            } else {
                RenderEventHandler.setRenderStoredRecipes(false);
            }
        } else if (Keyboard.getEventKeyState() && Keyboard.isKeyDown((int)ClientProxy.KEY_RECIPE.func_151463_i()) && Keyboard.getEventKey() >= 2 && Keyboard.getEventKey() <= 10) {
            int index = MathHelper.func_76125_a((int)(Keyboard.getEventKey() - 2), (int)0, (int)8);
            InventoryUtils.storeOrLoadRecipe(gui, index);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        this.recipes.readFromDisk();
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Load event) {
        this.recipes.writeToDisk();
    }

    public void initializeRecipeStorage() {
        this.recipes = new RecipeStorage(18, Configs.craftingScrollingSaveFileIsGlobal);
    }

    public RecipeStorage getRecipes() {
        return this.recipes;
    }

    private void storeSourceSlotCandidate(GuiContainer gui) {
        Slot slot;
        if (Mouse.getEventButtonState() && (Mouse.getEventButton() == 0 || Mouse.getEventButton() == 1) && (slot = gui.getSlotUnderMouse()) != null) {
            ItemStack stackCursor = gui.field_146297_k.field_71439_g.field_71071_by.func_70445_o();
            ItemStack stack = InventoryUtils.EMPTY_STACK;
            if (!InventoryUtils.isStackEmpty(stackCursor)) {
                stack = new ItemStack(stackCursor.func_77973_b(), InventoryUtils.getStackSize(stackCursor), stackCursor.func_77960_j());
            }
            this.stackInCursorLast = stack;
            this.sourceSlotCandidate = new WeakReference<Slot>(slot);
        }
    }

    private void checkForItemPickup(GuiContainer gui) {
        ItemStack stackCursor = gui.field_146297_k.field_71439_g.field_71071_by.func_70445_o();
        if (!InventoryUtils.isStackEmpty(stackCursor) && !stackCursor.func_77969_a(this.stackInCursorLast)) {
            this.sourceSlot = new WeakReference(this.sourceSlotCandidate.get());
        }
    }

    private static void debugPrintSlotInfo(GuiContainer gui, Slot slot) {
        if (slot == null) {
            ItemScroller.logger.info("slot was null");
            return;
        }
        boolean hasSlot = gui.field_147002_h.field_75151_b.contains(slot);
        IInventory inv = slot instanceof SlotItemHandler ? ((SlotItemHandler)slot).getItemHandler() : slot.field_75224_c;
        String stackStr = InventoryUtils.getStackString(slot.func_75211_c());
        ItemScroller.logger.info(String.format("slot: slotNumber: %d, getSlotIndex(): %d, getHasStack(): %s, slot class: %s, inv class: %s, Container's slot list has slot: %s, stack: %s", slot.field_75222_d, slot.getSlotIndex(), slot.func_75216_d(), slot.getClass().getName(), inv != null ? inv.getClass().getName() : "<null>", hasSlot ? " true" : "false", stackStr));
    }

    private boolean shiftPlaceItems(GuiContainer gui) {
        Slot slot = gui.getSlotUnderMouse();
        InventoryUtils.leftClickSlot(gui, slot.field_75222_d);
        this.draggedSlots.add(slot.field_75222_d);
        InventoryUtils.tryMoveStacks(slot, gui, true, false, false);
        return true;
    }

    private boolean shiftDropItems(GuiContainer gui) {
        ItemStack stackReference = gui.field_146297_k.field_71439_g.field_71071_by.func_70445_o();
        if (!InventoryUtils.isStackEmpty(stackReference)) {
            stackReference = stackReference.func_77946_l();
            InventoryUtils.dropItemsFromCursor(gui);
            InventoryUtils.dropStacks(gui, stackReference, (Slot)this.sourceSlot.get());
            return true;
        }
        return false;
    }

    private boolean canShiftDropItems(GuiContainer gui) {
        if (!GuiScreen.func_146272_n() || Mouse.getEventButton() != 0 || InventoryUtils.isStackEmpty(gui.field_146297_k.field_71439_g.field_71071_by.func_70445_o())) {
            return false;
        }
        try {
            int left = fieldGuiLeft.getInt(gui);
            int top = fieldGuiTop.getInt(gui);
            int xSize = fieldGuiXSize.getInt(gui);
            int ySize = fieldGuiYSize.getInt(gui);
            int mouseAbsX = Mouse.getEventX() * gui.field_146294_l / gui.field_146297_k.field_71443_c;
            int mouseAbsY = gui.field_146295_m - Mouse.getEventY() * gui.field_146295_m / gui.field_146297_k.field_71440_d - 1;
            boolean isOutsideGui = mouseAbsX < left || mouseAbsY < top || mouseAbsX >= left + xSize || mouseAbsY >= top + ySize;
            return isOutsideGui && this.getSlotAtPosition(gui, mouseAbsX - left, mouseAbsY - top) == null;
        }
        catch (IllegalAccessException e) {
            ItemScroller.logger.warn("Failed to reflect GuiContainer#guiLeft or guiTop or xSize or ySize");
            return false;
        }
    }

    private boolean dragMoveItems(GuiContainer gui) {
        boolean eitherMouseButtonDown;
        int mouseX = Mouse.getEventX() * gui.field_146294_l / gui.field_146297_k.field_71443_c;
        int mouseY = gui.field_146295_m - Mouse.getEventY() * gui.field_146295_m / gui.field_146297_k.field_71440_d - 1;
        if (!InventoryUtils.isStackEmpty(gui.field_146297_k.field_71439_g.field_71071_by.func_70445_o())) {
            this.lastPosX = mouseX;
            this.lastPosY = mouseY;
            return false;
        }
        boolean eventKeyIsLeftButton = Mouse.getEventButton() == 0;
        boolean eventKeyIsRightButton = Mouse.getEventButton() == 1;
        boolean leftButtonDown = Mouse.isButtonDown((int)0);
        boolean rightButtonDown = Mouse.isButtonDown((int)1);
        boolean isShiftDown = GuiScreen.func_146272_n();
        boolean isControlDown = GuiScreen.func_146271_m();
        boolean bl = eitherMouseButtonDown = leftButtonDown || rightButtonDown;
        if (isShiftDown && leftButtonDown && !Configs.enableDragMovingShiftLeft || isShiftDown && rightButtonDown && !Configs.enableDragMovingShiftRight || isControlDown && eitherMouseButtonDown && !Configs.enableDragMovingControlLeft) {
            return false;
        }
        boolean leaveOneItem = !leftButtonDown;
        boolean moveOnlyOne = !isShiftDown;
        boolean cancel = false;
        if (Mouse.getEventButtonState() && ((eventKeyIsLeftButton || eventKeyIsRightButton) && isControlDown && Configs.enableDragMovingControlLeft || eventKeyIsRightButton && isShiftDown && Configs.enableDragMovingShiftRight)) {
            this.slotNumberLast = -1;
            cancel = this.dragMoveFromSlotAtPosition(gui, mouseX, mouseY, leaveOneItem, moveOnlyOne);
        }
        if (!cancel && (isShiftDown || isControlDown) && eitherMouseButtonDown) {
            int absY;
            int distX = mouseX - this.lastPosX;
            int distY = mouseY - this.lastPosY;
            int absX = Math.abs(distX);
            if (absX > (absY = Math.abs(distY))) {
                int inc = distX > 0 ? 1 : -1;
                int x = this.lastPosX;
                while (true) {
                    int y = absX != 0 ? this.lastPosY + (x - this.lastPosX) * distY / absX : mouseY;
                    this.dragMoveFromSlotAtPosition(gui, x, y, leaveOneItem, moveOnlyOne);
                    if (x != mouseX) {
                        x += inc;
                        continue;
                    }
                    break;
                }
            } else {
                int inc = distY > 0 ? 1 : -1;
                int y = this.lastPosY;
                while (true) {
                    int x = absY != 0 ? this.lastPosX + (y - this.lastPosY) * distX / absY : mouseX;
                    this.dragMoveFromSlotAtPosition(gui, x, y, leaveOneItem, moveOnlyOne);
                    if (y == mouseY) break;
                    y += inc;
                }
            }
        }
        this.lastPosX = mouseX;
        this.lastPosY = mouseY;
        Slot slot = this.getSlotAtPosition(gui, mouseX, mouseY);
        int n = this.slotNumberLast = slot != null ? slot.field_75222_d : -1;
        if (!eitherMouseButtonDown) {
            this.draggedSlots.clear();
        }
        return cancel;
    }

    private boolean dragMoveFromSlotAtPosition(GuiContainer gui, int x, int y, boolean leaveOneItem, boolean moveOnlyOne) {
        boolean cancel;
        Slot slot = this.getSlotAtPosition(gui, x, y);
        boolean flag = slot != null && InventoryUtils.isValidSlot(slot, gui, true) && slot.func_82869_a((EntityPlayer)gui.field_146297_k.field_71439_g);
        boolean bl = cancel = flag && (leaveOneItem || moveOnlyOne);
        if (flag && slot.field_75222_d != this.slotNumberLast && !this.draggedSlots.contains(slot.field_75222_d)) {
            if (moveOnlyOne) {
                cancel = InventoryUtils.tryMoveSingleItemToOtherInventory(slot, gui);
            } else if (leaveOneItem) {
                cancel = InventoryUtils.tryMoveAllButOneItemToOtherInventory(slot, gui);
            } else {
                InventoryUtils.shiftClickSlot(gui, slot.field_75222_d);
                cancel = true;
            }
            this.draggedSlots.add(slot.field_75222_d);
        }
        return cancel;
    }

    private Slot getSlotAtPosition(GuiContainer gui, int x, int y) {
        try {
            return methodHandle_getSlotAtPosition.invokeExact(gui, x, y);
        }
        catch (Throwable e) {
            ItemScroller.logger.error("Error while trying invoke GuiContainer#getSlotAtPosition() from {}", new Object[]{gui.getClass().getSimpleName(), e});
            return null;
        }
    }

    static {
        methodHandle_getSlotAtPosition = MethodHandleUtils.getMethodHandleVirtual(GuiContainer.class, new String[]{"func_146975_c", "getSlotAtPosition"}, Integer.TYPE, Integer.TYPE);
        fieldGuiLeft = ReflectionHelper.findField(GuiContainer.class, (String[])new String[]{"field_147003_i", "guiLeft"});
        fieldGuiTop = ReflectionHelper.findField(GuiContainer.class, (String[])new String[]{"field_147009_r", "guiTop"});
        fieldGuiXSize = ReflectionHelper.findField(GuiContainer.class, (String[])new String[]{"field_146999_f", "xSize"});
        fieldGuiYSize = ReflectionHelper.findField(GuiContainer.class, (String[])new String[]{"field_147000_g", "ySize"});
    }
}

