/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.refinedrelocation.network;

import javax.annotation.Nullable;
import net.blay09.mods.refinedrelocation.api.filter.IChecklistFilter;
import net.blay09.mods.refinedrelocation.api.filter.IConfigurableFilter;
import net.blay09.mods.refinedrelocation.api.filter.IFilter;
import net.blay09.mods.refinedrelocation.api.filter.IRootFilter;
import net.blay09.mods.refinedrelocation.capability.CapabilityRootFilter;
import net.blay09.mods.refinedrelocation.client.gui.GuiChecklistFilter;
import net.blay09.mods.refinedrelocation.client.gui.GuiRootFilter;
import net.blay09.mods.refinedrelocation.client.gui.GuiSortingChest;
import net.blay09.mods.refinedrelocation.container.ContainerChecklistFilter;
import net.blay09.mods.refinedrelocation.container.ContainerRootFilter;
import net.blay09.mods.refinedrelocation.container.ContainerSortingChest;
import net.blay09.mods.refinedrelocation.network.MessageOpenGui;
import net.blay09.mods.refinedrelocation.tile.TileSortingChest;
import net.blay09.mods.refinedrelocation.util.TileWrapper;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class GuiHandler {
    public static final int GUI_SORTING_CHEST = 1;
    public static final int GUI_ROOT_FILTER = 2;
    public static final int GUI_ANY_FILTER = 3;

    @Nullable
    public Container getContainer(int id, EntityPlayer player, MessageOpenGui message) {
        TileEntity actualTile = message.hasPosition() ? player.field_70170_p.func_175625_s(message.getPos()) : null;
        TileWrapper tileEntity = actualTile != null ? new TileWrapper(actualTile) : null;
        switch (id) {
            case 1: {
                return actualTile instanceof TileSortingChest ? new ContainerSortingChest(player, (TileSortingChest)actualTile) : null;
            }
            case 2: {
                return tileEntity != null ? (tileEntity.hasCapability(CapabilityRootFilter.CAPABILITY, null) ? new ContainerRootFilter(player, tileEntity) : null) : null;
            }
            case 3: {
                IRootFilter rootFilter;
                if (tileEntity == null || (rootFilter = tileEntity.getCapability(CapabilityRootFilter.CAPABILITY, null)) == null) break;
                IFilter filter = rootFilter.getFilter(message.getIntValue());
                if (filter instanceof IConfigurableFilter) {
                    return ((IConfigurableFilter)((Object)filter)).createContainer(player, tileEntity);
                }
                if (!(filter instanceof IChecklistFilter)) break;
                return new ContainerChecklistFilter(player, tileEntity, (IChecklistFilter)filter);
            }
        }
        return null;
    }

    @Nullable
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGuiScreen(int id, EntityPlayer player, MessageOpenGui message) {
        TileEntity actualTile = message.hasPosition() ? player.field_70170_p.func_175625_s(message.getPos()) : null;
        TileWrapper tileEntity = actualTile != null ? new TileWrapper(actualTile) : null;
        switch (id) {
            case 1: {
                return actualTile instanceof TileSortingChest ? new GuiSortingChest(player, (TileSortingChest)actualTile) : null;
            }
            case 2: {
                return tileEntity != null ? (tileEntity.hasCapability(CapabilityRootFilter.CAPABILITY, null) ? new GuiRootFilter(player, tileEntity) : null) : null;
            }
            case 3: {
                Container container;
                if (tileEntity == null || !((container = player.field_71070_bA) instanceof ContainerRootFilter)) break;
                IFilter filter = ((ContainerRootFilter)container).getRootFilter().getFilter(message.getIntValue());
                if (filter instanceof IConfigurableFilter) {
                    return ((IConfigurableFilter)((Object)filter)).createGuiScreen(player, tileEntity);
                }
                if (!(filter instanceof IChecklistFilter)) break;
                return new GuiChecklistFilter(player, tileEntity, (IChecklistFilter)filter);
            }
        }
        return null;
    }
}

