/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.refinedrelocation.container;

import javax.annotation.Nullable;
import net.blay09.mods.refinedrelocation.api.RefinedRelocationAPI;
import net.blay09.mods.refinedrelocation.api.TileOrMultipart;
import net.blay09.mods.refinedrelocation.api.container.IContainerMessage;
import net.blay09.mods.refinedrelocation.api.filter.IChecklistFilter;
import net.blay09.mods.refinedrelocation.container.ContainerMod;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.item.ItemStack;

public class ContainerChecklistFilter
extends ContainerMod {
    public static final String KEY_CHECK = "Check";
    public static final String KEY_UNCHECK = "Uncheck";
    public static final String KEY_STATES = "States";
    private static final int UPDATE_INTERVAL = 20;
    private final EntityPlayer player;
    private final TileOrMultipart tileEntity;
    private final IChecklistFilter filter;
    private final byte[] lastStates;
    private int ticksSinceUpdate = 20;

    public ContainerChecklistFilter(EntityPlayer player, TileOrMultipart tileEntity, IChecklistFilter filter) {
        this.player = player;
        this.tileEntity = tileEntity;
        this.filter = filter;
        this.lastStates = new byte[filter.getOptionCount()];
        this.addPlayerInventory(player, 128);
    }

    public void func_75142_b() {
        super.func_75142_b();
        ++this.ticksSinceUpdate;
        if (this.ticksSinceUpdate >= 20) {
            boolean anyChanges = false;
            for (int i = 0; i < this.lastStates.length; ++i) {
                byte isChecked = (byte)(this.filter.isOptionChecked(i) ? 1 : 0);
                if (this.lastStates[i] == isChecked) continue;
                anyChanges = true;
                this.lastStates[i] = isChecked;
            }
            if (anyChanges) {
                RefinedRelocationAPI.syncContainerValue(KEY_STATES, this.lastStates, (Iterable<IContainerListener>)this.field_75149_d);
                RefinedRelocationAPI.updateFilterPreview(this.player, this.tileEntity, this.filter);
            }
            this.ticksSinceUpdate = 0;
        }
    }

    @Nullable
    public ItemStack func_184996_a(int slotId, int dragType, ClickType clickTypeIn, EntityPlayer player) {
        ItemStack itemStack = super.func_184996_a(slotId, dragType, clickTypeIn, player);
        RefinedRelocationAPI.updateFilterPreview(player, this.tileEntity, this.filter);
        return itemStack;
    }

    public TileOrMultipart getTileEntity() {
        return this.tileEntity;
    }

    @Override
    public void receivedMessageServer(IContainerMessage message) {
        if (message.getKey().equals(KEY_CHECK)) {
            int index = message.getIntValue();
            if (index < 0 || index >= this.lastStates.length) {
                return;
            }
            this.filter.setOptionChecked(index, true);
            this.tileEntity.markDirty();
            this.lastStates[index] = 1;
            RefinedRelocationAPI.updateFilterPreview(this.player, this.tileEntity, this.filter);
        } else if (message.getKey().equals(KEY_UNCHECK)) {
            int index = message.getIntValue();
            if (index < 0 || index >= this.lastStates.length) {
                return;
            }
            this.filter.setOptionChecked(index, false);
            this.tileEntity.markDirty();
            this.lastStates[index] = 0;
            RefinedRelocationAPI.updateFilterPreview(this.player, this.tileEntity, this.filter);
        }
    }

    @Override
    public void receivedMessageClient(IContainerMessage message) {
        if (message.getKey().equals(KEY_STATES)) {
            byte[] states = message.getByteArrayValue();
            for (int i = 0; i < states.length; ++i) {
                this.filter.setOptionChecked(i, states[i] == 1);
            }
        }
    }
}

