/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.refinedrelocation.client.gui.base.element;

import net.blay09.mods.refinedrelocation.client.gui.base.IParentScreen;
import net.blay09.mods.refinedrelocation.client.gui.base.element.GuiElement;
import net.blay09.mods.refinedrelocation.client.gui.base.element.IScrollTarget;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ChatAllowedCharacters;

public class GuiTextFieldMultiLine
extends GuiElement
implements IScrollTarget {
    private static final int ENABLED_COLOR = 0xE0E0E0;
    private static final int DISABLED_COLOR = 0x707070;
    private static final int PADDING = 2;
    private FontRenderer fontRenderer;
    private String text = "";
    private int maxLength = Integer.MAX_VALUE;
    private boolean isEnabled = true;
    private boolean visible = true;
    private boolean canLoseFocus = true;
    private boolean isFocused;
    private int cursorPosition;
    private int cursorCounter;
    private int scrollOffset;
    private int lineScrollOffset;
    private String[] renderCache;
    private int lastRowCount;

    public GuiTextFieldMultiLine(int x, int y, int width, int height) {
        this.fontRenderer = Minecraft.func_71410_x().field_71466_p;
        this.setPosition(x, y);
        this.setSize(width, height);
    }

    @Override
    public void initGui(IParentScreen parentScreen) {
        super.initGui(parentScreen);
        this.fontRenderer = parentScreen.getFontRenderer();
    }

    private int getStartOfLine(int position, int iterations) {
        int startOfLine = position;
        for (int i = 0; i < iterations; ++i) {
            startOfLine = this.text.lastIndexOf(10, startOfLine - 1);
        }
        return startOfLine != -1 ? startOfLine + 1 : 0;
    }

    private int getEndOfLine(int position, int iteration) {
        int endOfLine = position - 1;
        for (int i = 0; i < iteration; ++i) {
            if ((endOfLine = this.text.indexOf(10, endOfLine + 1)) != -1) continue;
            return this.text.length();
        }
        return endOfLine != -1 ? endOfLine : this.text.length();
    }

    private int getLineLength(int position) {
        return this.getEndOfLine(position, 1) - this.getStartOfLine(position, 1);
    }

    private int getStartOfWord(int position) {
        if (this.text.isEmpty()) {
            return 0;
        }
        if (this.text.charAt(position = Math.max(Math.min(position, this.text.length() - 1), 0)) == '\n') {
            return position;
        }
        boolean foundAlphabetic = false;
        for (int i = position; i >= 0; --i) {
            char c = this.text.charAt(i);
            if (c == '\n') {
                return i + 1;
            }
            if (Character.isAlphabetic(c)) {
                foundAlphabetic = true;
                continue;
            }
            if (!foundAlphabetic) continue;
            return i + 1;
        }
        return 0;
    }

    private int getStartOfNextWord(int position) {
        if (this.text.charAt(position = Math.max(Math.min(position, this.text.length() - 1), 0)) == '\n') {
            return position;
        }
        boolean foundNonAlphabetic = false;
        for (int i = position; i < this.text.length(); ++i) {
            char c = this.text.charAt(i);
            if (c == '\n') {
                return i;
            }
            if (!Character.isAlphabetic(c)) {
                foundNonAlphabetic = true;
                continue;
            }
            if (!foundNonAlphabetic) continue;
            return i;
        }
        return this.text.length();
    }

    public void setCursorPosition(int cursorPosition) {
        this.cursorPosition = Math.min(Math.max(cursorPosition, 0), this.text.length());
        int cursorLine = 0;
        for (int i = 0; i < this.cursorPosition; ++i) {
            if (this.text.charAt(i) != '\n') continue;
            ++cursorLine;
        }
        int innerHeight = this.getHeight() - 2;
        int cursorRenderY = (cursorLine - this.scrollOffset) * this.fontRenderer.field_78288_b + 2;
        if (cursorRenderY < 0) {
            this.scroll(0, cursorRenderY / this.fontRenderer.field_78288_b - 1);
        } else if (cursorRenderY > innerHeight - this.fontRenderer.field_78288_b) {
            this.scroll(0, (cursorRenderY - innerHeight) / this.fontRenderer.field_78288_b + 1);
        }
        int innerWidth = this.getWidth() - 2;
        int startOfLine = this.getStartOfLine(cursorPosition, 1);
        int endOfLine = this.getEndOfLine(cursorPosition, 1);
        int cursorPositionX = Math.min(this.getLineLength(cursorPosition), cursorPosition - startOfLine);
        String lineText = this.text.substring(startOfLine, endOfLine);
        this.lineScrollOffset = Math.max(Math.min(this.lineScrollOffset, lineText.length()), 0);
        String renderText = this.fontRenderer.func_78269_a(lineText, innerWidth);
        if (cursorPositionX == this.lineScrollOffset) {
            this.lineScrollOffset -= renderText.length();
        }
        this.lineScrollOffset = Math.max(Math.min(this.lineScrollOffset, lineText.length()), 0);
        int offset = renderText.length() + this.lineScrollOffset;
        if (cursorPositionX > offset) {
            this.lineScrollOffset += cursorPositionX - offset;
        } else if (cursorPositionX <= this.lineScrollOffset) {
            this.lineScrollOffset -= this.lineScrollOffset - cursorPositionX;
        }
        this.lineScrollOffset = Math.max(Math.min(this.lineScrollOffset, lineText.length()), 0);
    }

    public void scroll(int x, int y) {
        this.lineScrollOffset = Math.max(this.lineScrollOffset + x, 0);
        this.scrollOffset = Math.max(this.scrollOffset + y, 0);
    }

    private void deleteBack(boolean wholeWord) {
        int deleteCount = 1;
        if (wholeWord) {
            deleteCount = this.cursorPosition - this.getStartOfWord(this.cursorPosition);
        }
        if (this.cursorPosition > 0) {
            this.text = this.text.substring(0, this.cursorPosition - deleteCount) + this.text.substring(this.cursorPosition);
            this.setCursorPosition(this.cursorPosition - deleteCount);
            this.renderCache = null;
        }
    }

    private void deleteFront(boolean wholeWord) {
        int deleteCount = 1;
        if (wholeWord) {
            deleteCount = this.getStartOfNextWord(this.cursorPosition) - this.cursorPosition;
        }
        if (this.cursorPosition < this.text.length()) {
            this.text = this.text.substring(0, this.cursorPosition) + this.text.substring(this.cursorPosition + deleteCount);
            this.renderCache = null;
        }
    }

    private void writeText(String s) {
        this.text = (this.cursorPosition > 0 ? this.text.substring(0, this.cursorPosition) : "") + s + (this.text.length() > this.cursorPosition ? this.text.substring(this.cursorPosition) : "");
        this.setCursorPosition(this.cursorPosition + s.length());
        this.renderCache = null;
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int mouseButton) {
        boolean isInside = this.isInside(mouseX, mouseY);
        if (this.canLoseFocus) {
            this.setFocused(isInside);
        }
        if (this.isFocused && isInside && mouseButton == 0) {
            int endOfLine;
            int relX = mouseX - this.getAbsoluteX();
            int relY = mouseY - this.getAbsoluteY() - this.fontRenderer.field_78288_b + 5;
            int lineNumber = Math.round((float)relY / (float)this.fontRenderer.field_78288_b) + this.scrollOffset + 1;
            int startOfLine = this.getStartOfLine(this.getEndOfLine(0, lineNumber), 1);
            if (startOfLine == (endOfLine = this.getEndOfLine(startOfLine, 1))) {
                this.setCursorPosition(startOfLine);
            } else {
                String renderText = this.fontRenderer.func_78269_a(this.text.substring(Math.max(startOfLine + this.lineScrollOffset, 0), Math.max(0, endOfLine)), this.getWidth() - 2);
                this.setCursorPosition(startOfLine + this.fontRenderer.func_78269_a(renderText, relX).length() + this.lineScrollOffset);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean keyTyped(char typedChar, int keyCode) {
        if (!this.isFocused) {
            return false;
        }
        switch (keyCode) {
            case 207: {
                if (GuiScreen.func_146271_m()) {
                    this.setCursorPosition(this.text.length());
                } else {
                    this.setCursorPosition(this.getEndOfLine(this.cursorPosition, 1));
                }
                return true;
            }
            case 199: {
                if (GuiScreen.func_146271_m()) {
                    this.setCursorPosition(0);
                } else {
                    this.setCursorPosition(this.getStartOfLine(this.cursorPosition, 1));
                }
                return true;
            }
            case 203: {
                if (GuiScreen.func_146271_m()) {
                    this.setCursorPosition(this.getStartOfWord(this.cursorPosition - 1));
                } else {
                    this.setCursorPosition(this.cursorPosition - 1);
                }
                return true;
            }
            case 205: {
                if (GuiScreen.func_146271_m()) {
                    this.setCursorPosition(this.getStartOfNextWord(this.cursorPosition + 1));
                } else {
                    this.setCursorPosition(this.cursorPosition + 1);
                }
                return true;
            }
            case 200: {
                if (GuiScreen.func_146271_m()) {
                    this.scroll(0, -1);
                } else {
                    int upLine = this.getStartOfLine(this.cursorPosition, 2);
                    this.setCursorPosition(upLine + Math.min(this.getLineLength(upLine), this.cursorPosition - this.getStartOfLine(this.cursorPosition, 1)));
                }
                return true;
            }
            case 208: {
                if (GuiScreen.func_146271_m()) {
                    this.scroll(0, 1);
                } else {
                    int downLine = this.getEndOfLine(this.cursorPosition, 2);
                    this.setCursorPosition(this.getStartOfLine(downLine, 1) + Math.min(this.getLineLength(downLine), this.cursorPosition - this.getStartOfLine(this.cursorPosition, 1)));
                }
                return true;
            }
            case 28: {
                if (this.isEnabled) {
                    this.writeText("\n");
                }
                return true;
            }
            case 211: {
                if (this.isEnabled) {
                    this.deleteFront(GuiScreen.func_146271_m());
                }
                return true;
            }
            case 14: {
                if (this.isEnabled) {
                    this.deleteBack(GuiScreen.func_146271_m());
                }
                return true;
            }
        }
        if (this.isEnabled && ChatAllowedCharacters.func_71566_a((char)typedChar)) {
            this.writeText(Character.toString(typedChar));
            return true;
        }
        return false;
    }

    @Override
    public void update() {
        super.update();
        ++this.cursorCounter;
    }

    @Override
    public void drawForeground(IParentScreen parentScreen, int mouseX, int mouseY) {
        super.drawForeground(parentScreen, mouseX, mouseY);
        if (this.visible) {
            int y;
            GuiTextFieldMultiLine.func_73734_a((int)(this.getAbsoluteX() - 1), (int)(this.getAbsoluteY() - 1), (int)(this.getAbsoluteX() + this.getWidth() + 1), (int)(this.getAbsoluteY() + this.getHeight() + 1), (int)-1118482);
            GuiTextFieldMultiLine.func_73734_a((int)this.getAbsoluteX(), (int)this.getAbsoluteY(), (int)(this.getAbsoluteX() + this.getWidth()), (int)(this.getAbsoluteY() + this.getHeight()), (int)-16777216);
            if (this.renderCache == null) {
                this.renderCache = this.text.split("\n");
            }
            for (int i = this.scrollOffset; i < this.renderCache.length && (y = (i - this.scrollOffset) * this.fontRenderer.field_78288_b) + this.fontRenderer.field_78288_b < this.getHeight(); ++i) {
                if (this.lineScrollOffset >= this.renderCache[i].length()) continue;
                String renderText = this.fontRenderer.func_78269_a(this.renderCache[i].substring(this.lineScrollOffset), this.getWidth() - 2);
                this.fontRenderer.func_175065_a(renderText, (float)(this.getAbsoluteX() + 2), (float)(this.getAbsoluteY() + 2 + y), this.isEnabled ? 0xE0E0E0 : 0x707070, true);
            }
            int cursorLine = 0;
            int lastLineIdx = 0;
            for (int i = 0; i < this.cursorPosition; ++i) {
                if (this.text.charAt(i) != '\n') continue;
                ++cursorLine;
                lastLineIdx = i + 1;
            }
            if (this.cursorCounter / 6 % 2 == 0 && (cursorLine - this.scrollOffset) * this.fontRenderer.field_78288_b >= 0 && (cursorLine - this.scrollOffset + 1) * this.fontRenderer.field_78288_b < this.getHeight() + 2) {
                this.drawCursor(this.getAbsoluteX() + this.fontRenderer.func_78256_a(this.text.substring(lastLineIdx + this.lineScrollOffset, this.cursorPosition)) + 2, this.getAbsoluteY() + (cursorLine - this.scrollOffset) * this.fontRenderer.field_78288_b + 2);
            }
        }
    }

    private void drawCursor(int x, int y) {
        Tessellator tessellator = Tessellator.func_178181_a();
        GlStateManager.func_179131_c((float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179090_x();
        GlStateManager.func_179115_u();
        GlStateManager.func_187422_a((GlStateManager.LogicOp)GlStateManager.LogicOp.OR_REVERSE);
        tessellator.func_178180_c().func_181668_a(7, DefaultVertexFormats.field_181705_e);
        tessellator.func_178180_c().func_181662_b((double)x, (double)(y + this.fontRenderer.field_78288_b), 0.0).func_181675_d();
        tessellator.func_178180_c().func_181662_b((double)(x + 1), (double)(y + this.fontRenderer.field_78288_b), 0.0).func_181675_d();
        tessellator.func_178180_c().func_181662_b((double)(x + 1), (double)y, 0.0).func_181675_d();
        tessellator.func_178180_c().func_181662_b((double)x, (double)y, 0.0).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179134_v();
        GlStateManager.func_179098_w();
    }

    public boolean isCanLoseFocus() {
        return this.canLoseFocus;
    }

    public void setCanLoseFocus(boolean canLoseFocus) {
        this.canLoseFocus = canLoseFocus;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public boolean isFocused() {
        return this.isFocused;
    }

    public void setFocused(boolean isFocused) {
        if (isFocused && !this.isFocused) {
            this.cursorCounter = 0;
        }
        this.isFocused = isFocused;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void setEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text.length() > this.maxLength ? text.substring(0, this.maxLength) : text;
        this.setCursorPosition(this.cursorPosition);
        this.renderCache = null;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
    }

    @Override
    public int getVisibleRows() {
        return this.getHeight() / this.fontRenderer.field_78288_b;
    }

    @Override
    public int getRowCount() {
        if (this.renderCache != null) {
            this.lastRowCount = this.renderCache.length;
        }
        return this.lastRowCount;
    }

    @Override
    public int getCurrentOffset() {
        return this.scrollOffset;
    }

    @Override
    public void setCurrentOffset(int offset) {
        this.scrollOffset = offset;
    }
}

