/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.gui;

import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.EnumFacing;

public class RenderGlowEffect {
    private static final Quad[] quads = new Quad[]{new Quad(new Vt(0.0f, 0.0f, 0.0f), new Vt(1.0f, 0.0f, 0.0f), new Vt(1.0f, 0.0f, 1.0f), new Vt(0.0f, 0.0f, 1.0f)), new Quad(new Vt(0.0f, 1.0f, 1.0f), new Vt(1.0f, 1.0f, 1.0f), new Vt(1.0f, 1.0f, 0.0f), new Vt(0.0f, 1.0f, 0.0f)), new Quad(new Vt(1.0f, 1.0f, 0.0f), new Vt(1.0f, 0.0f, 0.0f), new Vt(0.0f, 0.0f, 0.0f), new Vt(0.0f, 1.0f, 0.0f)), new Quad(new Vt(1.0f, 0.0f, 1.0f), new Vt(1.0f, 1.0f, 1.0f), new Vt(0.0f, 1.0f, 1.0f), new Vt(0.0f, 0.0f, 1.0f)), new Quad(new Vt(0.0f, 0.0f, 1.0f), new Vt(0.0f, 1.0f, 1.0f), new Vt(0.0f, 1.0f, 0.0f), new Vt(0.0f, 0.0f, 0.0f)), new Quad(new Vt(1.0f, 0.0f, 0.0f), new Vt(1.0f, 1.0f, 0.0f), new Vt(1.0f, 1.0f, 1.0f), new Vt(1.0f, 0.0f, 1.0f))};

    public static void renderGlow(Tessellator tessellator, double x, double y, double z) {
        VertexBuffer buffer = tessellator.func_178180_c();
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        buffer.func_181668_a(7, DefaultVertexFormats.field_181711_k);
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        RenderGlowEffect.addSideFullTexture(buffer, EnumFacing.UP.ordinal(), 1.1f, -0.05f);
        RenderGlowEffect.addSideFullTexture(buffer, EnumFacing.DOWN.ordinal(), 1.1f, -0.05f);
        RenderGlowEffect.addSideFullTexture(buffer, EnumFacing.NORTH.ordinal(), 1.1f, -0.05f);
        RenderGlowEffect.addSideFullTexture(buffer, EnumFacing.SOUTH.ordinal(), 1.1f, -0.05f);
        RenderGlowEffect.addSideFullTexture(buffer, EnumFacing.WEST.ordinal(), 1.1f, -0.05f);
        RenderGlowEffect.addSideFullTexture(buffer, EnumFacing.EAST.ordinal(), 1.1f, -0.05f);
        tessellator.func_78381_a();
        GlStateManager.func_179121_F();
    }

    public static void addSideFullTexture(VertexBuffer buffer, int side, float mult, float offset) {
        int brightness = 240;
        int b1 = brightness >> 16 & 0xFFFF;
        int b2 = brightness & 0xFFFF;
        float u1 = 0.0f;
        float v1 = 0.0f;
        float u2 = 1.0f;
        float v2 = 1.0f;
        Quad quad = quads[side];
        buffer.func_181662_b((double)(quad.v1.x * mult + offset), (double)(quad.v1.y * mult + offset), (double)(quad.v1.z * mult + offset)).func_187315_a((double)u1, (double)v1).func_187314_a(b1, b2).func_181669_b(255, 255, 255, 128).func_181675_d();
        buffer.func_181662_b((double)(quad.v2.x * mult + offset), (double)(quad.v2.y * mult + offset), (double)(quad.v2.z * mult + offset)).func_187315_a((double)u1, (double)v2).func_187314_a(b1, b2).func_181669_b(255, 255, 255, 128).func_181675_d();
        buffer.func_181662_b((double)(quad.v3.x * mult + offset), (double)(quad.v3.y * mult + offset), (double)(quad.v3.z * mult + offset)).func_187315_a((double)u2, (double)v2).func_187314_a(b1, b2).func_181669_b(255, 255, 255, 128).func_181675_d();
        buffer.func_181662_b((double)(quad.v4.x * mult + offset), (double)(quad.v4.y * mult + offset), (double)(quad.v4.z * mult + offset)).func_187315_a((double)u2, (double)v1).func_187314_a(b1, b2).func_181669_b(255, 255, 255, 128).func_181675_d();
    }

    private static class Quad {
        public final Vt v1;
        public final Vt v2;
        public final Vt v3;
        public final Vt v4;

        public Quad(Vt v1, Vt v2, Vt v3, Vt v4) {
            this.v1 = v1;
            this.v2 = v2;
            this.v3 = v3;
            this.v4 = v4;
        }

        public Quad rotate(EnumFacing direction) {
            switch (direction) {
                case NORTH: {
                    return new Quad(this.v4, this.v1, this.v2, this.v3);
                }
                case EAST: {
                    return new Quad(this.v3, this.v4, this.v1, this.v2);
                }
                case SOUTH: {
                    return new Quad(this.v2, this.v3, this.v4, this.v1);
                }
                case WEST: {
                    return this;
                }
            }
            return this;
        }
    }

    private static class Vt {
        public final float x;
        public final float y;
        public final float z;

        public Vt(float x, float y, float z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }
    }
}

