/*
 * Decompiled with CFR 0.152.
 */
package mezz.modnametooltip;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.commons.lang3.text.WordUtils;

public class TooltipEventHandler {
    private static final String chatFormatting = TextFormatting.BLUE.toString() + TextFormatting.ITALIC.toString();
    private final Map<String, String> modNamesForIds = new HashMap<String, String>();

    public TooltipEventHandler() {
        Map modMap = Loader.instance().getIndexedModList();
        for (Map.Entry modEntry : modMap.entrySet()) {
            String lowercaseId = ((String)modEntry.getKey()).toLowerCase(Locale.ENGLISH);
            String modName = ((ModContainer)modEntry.getValue()).getName();
            this.modNamesForIds.put(lowercaseId, modName);
        }
    }

    @Nullable
    public String getModNameForItem(@Nonnull Item item) {
        ResourceLocation itemResourceLocation = (ResourceLocation)Item.field_150901_e.func_177774_c((Object)item);
        if (itemResourceLocation == null) {
            return null;
        }
        String modId = itemResourceLocation.func_110624_b();
        String lowercaseModId = modId.toLowerCase(Locale.ENGLISH);
        String modName = this.modNamesForIds.get(lowercaseModId);
        if (modName == null) {
            modName = WordUtils.capitalize((String)modId);
            this.modNamesForIds.put(lowercaseModId, modName);
        }
        return modName;
    }

    @SubscribeEvent
    public void onToolTip(@Nonnull ItemTooltipEvent event) {
        ItemStack itemStack = event.getItemStack();
        if (itemStack == null) {
            return;
        }
        Item item = itemStack.func_77973_b();
        if (item == null) {
            return;
        }
        String modName = this.getModNameForItem(item);
        if (modName != null) {
            event.getToolTip().add(chatFormatting + modName);
        }
    }
}

