/*
 * Decompiled with CFR 0.152.
 */
package cyano.orespawn;

import cyano.orespawn.events.OreGenDisabler;
import cyano.orespawn.init.WorldGen;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.Level;

@Mod(modid="orespawn", name="Ore Spawn", version="1.1.0", acceptedMinecraftVersions="[1.10.2]")
public class OreSpawn {
    public static OreSpawn INSTANCE = null;
    public static final String MODID = "orespawn";
    public static final String NAME = "Ore Spawn";
    public static final String VERSION = "1.1.0";
    public static final List<Path> oreSpawnConfigFiles = new LinkedList<Path>();
    public static final List<String> additionalStoneBlocks = new ArrayList<String>();
    public static boolean disableVanillaOreGen = false;
    public static boolean forceOreGen = false;
    public static boolean ignoreNonExistant = true;
    public static Path oreSpawnFolder = null;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        String[] blocks;
        INSTANCE = this;
        Configuration config = new Configuration(event.getSuggestedConfigurationFile());
        config.load();
        disableVanillaOreGen = config.getBoolean("disable_standard_ore_generation", "options", disableVanillaOreGen, "If true, then default Minecraft ore generation will be handled exclusively by orespawn .json files \n(vanilla ore generation will be disabled)");
        forceOreGen = config.getBoolean("force_ore_generation", "options", forceOreGen, "If true, then ore generation cannot be disabled by other mods.");
        ignoreNonExistant = config.getBoolean("ignore_missing_blocks", "options", ignoreNonExistant, "If true, then references to non-existant blocks in the .json files will be ingored without causing an error.");
        for (String s : blocks = config.getString("nonstandard_spawn_blocks", "options", "", "A semi-colon (;) delimited list of block IDs of non-stone blocks that you want to also have ores spawn \nin them (e.g. \"minecraft:gravel;minecraft:sandstone;minecraft:stained_hardened_clay\"").split(";")) {
            if (s.trim().isEmpty()) continue;
            additionalStoneBlocks.add(s);
        }
        oreSpawnFolder = Paths.get(event.getSuggestedConfigurationFile().toPath().getParent().toString(), MODID);
        if (!Files.isDirectory(oreSpawnFolder, new LinkOption[0])) {
            try {
                Files.createDirectories(oreSpawnFolder, new FileAttribute[0]);
            }
            catch (IOException e) {
                FMLLog.severe((String)("orespawn: Error: Failed to make folder " + oreSpawnFolder), (Object[])new Object[0]);
            }
        }
        Path oreVanillaSpawnFile = Paths.get(oreSpawnFolder.toString(), "minecraft.json");
        if (disableVanillaOreGen && !Files.exists(oreVanillaSpawnFile, new LinkOption[0])) {
            try {
                Files.createDirectories(oreVanillaSpawnFile.getParent(), new FileAttribute[0]);
                Files.write(oreVanillaSpawnFile, Arrays.asList("{\n\t\"dimensions\":[\n\t\t{\n\t\t\t\"dimension\":\"+\",\n\t\t\t\"ores\":[\n\t\t\t\t{\n\t\t\t\t\t\"blockID\":\"minecraft:coal_ore\",\n\t\t\t\t\t\"size\":25,\n\t\t\t\t\t\"variation\":12,\n\t\t\t\t\t\"frequency\":20,\n\t\t\t\t\t\"minHeight\":0,\n\t\t\t\t\t\"maxHeight\":128,\n\t\t\t\t\t\"biomes\":[\n\n\t\t\t\t\t]\n\t\t\t\t},\n\t\t\t\t{\n\t\t\t\t\t\"blockID\":\"minecraft:iron_ore\",\n\t\t\t\t\t\"size\":8,\n\t\t\t\t\t\"variation\":4,\n\t\t\t\t\t\"frequency\":20,\n\t\t\t\t\t\"minHeight\":0,\n\t\t\t\t\t\"maxHeight\":64,\n\t\t\t\t\t\"biomes\":[\n\n\t\t\t\t\t]\n\t\t\t\t},\n\t\t\t\t{\n\t\t\t\t\t\"blockID\":\"minecraft:gold_ore\",\n\t\t\t\t\t\"size\":8,\n\t\t\t\t\t\"variation\":2,\n\t\t\t\t\t\"frequency\":2,\n\t\t\t\t\t\"minHeight\":0,\n\t\t\t\t\t\"maxHeight\":32,\n\t\t\t\t\t\"biomes\":[\n\n\t\t\t\t\t]\n\t\t\t\t},\n\t\t\t\t{\n\t\t\t\t\t\"blockID\":\"minecraft:diamond_ore\",\n\t\t\t\t\t\"size\":6,\n\t\t\t\t\t\"variation\":3,\n\t\t\t\t\t\"frequency\":1,\n\t\t\t\t\t\"minHeight\":0,\n\t\t\t\t\t\"maxHeight\":16,\n\t\t\t\t\t\"biomes\":[\n\n\t\t\t\t\t]\n\t\t\t\t},\n\t\t\t\t{\n\t\t\t\t\t\"blockID\":\"minecraft:redstone_ore\",\n\t\t\t\t\t\"size\":6,\n\t\t\t\t\t\"variation\":3,\n\t\t\t\t\t\"frequency\":8,\n\t\t\t\t\t\"minHeight\":0,\n\t\t\t\t\t\"maxHeight\":16,\n\t\t\t\t\t\"biomes\":[\n\n\t\t\t\t\t]\n\t\t\t\t},\n\t\t\t\t{\n\t\t\t\t\t\"blockID\":\"minecraft:lapis_ore\",\n\t\t\t\t\t\"size\":5,\n\t\t\t\t\t\"variation\":2,\n\t\t\t\t\t\"frequency\":1,\n\t\t\t\t\t\"minHeight\":0,\n\t\t\t\t\t\"maxHeight\":32,\n\t\t\t\t\t\"biomes\":[\n\n\t\t\t\t\t]\n\t\t\t\t},\n\t\t\t\t{\n\t\t\t\t\t\"blockID\":\"minecraft:emerald_ore\",\n\t\t\t\t\t\"size\":1,\n\t\t\t\t\t\"variation\":0,\n\t\t\t\t\t\"frequency\":8,\n\t\t\t\t\t\"minHeight\":4,\n\t\t\t\t\t\"maxHeight\":32,\n\t\t\t\t\t\"biomes\":[\n\t\t\t\t\t\t\"Extreme Hills Edge\",\n\t\t\t\t\t\t\"Extreme Hills\"\n\t\t\t\t\t]\n\t\t\t\t},\n\t\t\t\t{\n\t\t\t\t\t\"blockID\":\"minecraft:dirt\",\n\t\t\t\t\t\"size\":112,\n\t\t\t\t\t\"variation\":50,\n\t\t\t\t\t\"frequency\":10,\n\t\t\t\t\t\"minHeight\":0,\n\t\t\t\t\t\"maxHeight\":255,\n\t\t\t\t\t\"biomes\":[\n\n\t\t\t\t\t]\n\t\t\t\t},\n\t\t\t\t{\n\t\t\t\t\t\"blockID\":\"minecraft:gravel\",\n\t\t\t\t\t\"size\":112,\n\t\t\t\t\t\"variation\":50,\n\t\t\t\t\t\"frequency\":8,\n\t\t\t\t\t\"minHeight\":0,\n\t\t\t\t\t\"maxHeight\":255,\n\t\t\t\t\t\"biomes\":[\n\n\t\t\t\t\t]\n\t\t\t\t},\n\t\t\t\t{\n\t\t\t\t\t\"__comment\":\"granite\",\n\t\t\t\t\t\"blockID\":\"minecraft:stone\",\n\t\t\t\t\t\"blockMeta\":1,\n\t\t\t\t\t\"size\":112,\n\t\t\t\t\t\"variation\":50,\n\t\t\t\t\t\"frequency\":10,\n\t\t\t\t\t\"minHeight\":0,\n\t\t\t\t\t\"maxHeight\":255,\n\t\t\t\t\t\"biomes\":[\n\n\t\t\t\t\t]\n\t\t\t\t},\n\t\t\t\t{\n\t\t\t\t\t\"__comment\":\"diorite\",\n\t\t\t\t\t\"blockID\":\"minecraft:stone\",\n\t\t\t\t\t\"blockMeta\":3,\n\t\t\t\t\t\"size\":112,\n\t\t\t\t\t\"variation\":50,\n\t\t\t\t\t\"frequency\":10,\n\t\t\t\t\t\"minHeight\":0,\n\t\t\t\t\t\"maxHeight\":255,\n\t\t\t\t\t\"biomes\":[\n\n\t\t\t\t\t]\n\t\t\t\t},\n\t\t\t\t{\n\t\t\t\t\t\"__comment\":\"andesite\",\n\t\t\t\t\t\"blockID\":\"minecraft:stone\",\n\t\t\t\t\t\"blockMeta\":5,\n\t\t\t\t\t\"size\":112,\n\t\t\t\t\t\"variation\":50,\n\t\t\t\t\t\"frequency\":10,\n\t\t\t\t\t\"minHeight\":0,\n\t\t\t\t\t\"maxHeight\":255,\n\t\t\t\t\t\"biomes\":[\n\n\t\t\t\t\t]\n\t\t\t\t}\n\t\t\t]\n\t\t},\n\t\t{\n\t\t\t\"dimension\":-1,\n\t\t\t\"ores\":[\n\t\t\t\t{\n\t\t\t\t\t\"blockID\":\"minecraft:quartz_ore\",\n\t\t\t\t\t\"size\":15,\n\t\t\t\t\t\"variation\":4,\n\t\t\t\t\t\"frequency\":7,\n\t\t\t\t\t\"minHeight\":0,\n\t\t\t\t\t\"maxHeight\":128,\n\t\t\t\t\t\"biomes\":[\n\n\t\t\t\t\t]\n\t\t\t\t}\n\t\t\t]\n\t\t}\n\t]\n}".split("\n")), Charset.forName("UTF-8"), new OpenOption[0]);
            }
            catch (IOException e) {
                FMLLog.severe((String)("orespawn: Error: Failed to write file " + oreVanillaSpawnFile), (Object[])new Object[0]);
            }
        }
        config.save();
        if (event.getSide() == Side.CLIENT) {
            this.clientPreInit(event);
        }
        if (event.getSide() == Side.SERVER) {
            this.serverPreInit(event);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void clientPreInit(FMLPreInitializationEvent event) {
    }

    @SideOnly(value=Side.SERVER)
    private void serverPreInit(FMLPreInitializationEvent event) {
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        if (disableVanillaOreGen) {
            MinecraftForge.ORE_GEN_BUS.register((Object)OreGenDisabler.getInstance());
        }
        if (event.getSide() == Side.CLIENT) {
            this.clientInit(event);
        }
        if (event.getSide() == Side.SERVER) {
            this.serverInit(event);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void clientInit(FMLInitializationEvent event) {
    }

    @SideOnly(value=Side.SERVER)
    private void serverInit(FMLInitializationEvent event) {
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        try {
            Files.walk(oreSpawnFolder, new FileVisitOption[0]).filter(p -> Files.isRegularFile(p, new LinkOption[0])).filter(p -> p.getFileName().toString().toLowerCase(Locale.US).endsWith(".json")).forEach(oreSpawnConfigFiles::add);
        }
        catch (IOException ioe) {
            FMLLog.log((Level)Level.ERROR, (Throwable)ioe, (String)"Error while searching for orespawn files", (Object[])new Object[0]);
        }
        for (Path oreSpawnFile : oreSpawnConfigFiles) {
            try {
                WorldGen.loadConfig(oreSpawnFile);
            }
            catch (IOException e) {
                FMLLog.log((Level)Level.ERROR, (Throwable)e, (String)("orespawn: Error parsing ore-spawn config file " + oreSpawnFile), (Object[])new Object[0]);
            }
        }
        WorldGen.init();
        if (event.getSide() == Side.CLIENT) {
            this.clientPostInit(event);
        }
        if (event.getSide() == Side.SERVER) {
            this.serverPostInit(event);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void clientPostInit(FMLPostInitializationEvent event) {
    }

    @SideOnly(value=Side.SERVER)
    private void serverPostInit(FMLPostInitializationEvent event) {
    }
}

