/*
 * Decompiled with CFR 0.152.
 */
package com.sb205.missing_pieces.Shelf;

import com.google.common.base.Predicate;
import com.sb205.missing_pieces.Config.MpConfiguration;
import com.sb205.missing_pieces.MissingPieces;
import com.sb205.missing_pieces.Shelf.GuiHandlerShelf;
import com.sb205.missing_pieces.Shelf.TileEntityShelf;
import com.sb205.missing_pieces.Utilities.BlockInfo;
import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockShelf
extends BlockContainer
implements ITileEntityProvider {
    public static final PropertyDirection PROPERTYFACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);

    public BlockShelf(Material mType, Float matHardness) {
        super(mType);
        this.func_149647_a(CreativeTabs.field_78030_b);
        this.func_149711_c(matHardness.floatValue());
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing facing = EnumFacing.func_176731_b((int)meta);
        return this.func_176223_P().func_177226_a((IProperty)PROPERTYFACING, (Comparable)facing);
    }

    public int func_176201_c(IBlockState state) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)PROPERTYFACING);
        int facingbits = facing.func_176736_b();
        return facingbits;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{PROPERTYFACING});
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityShelf();
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof TileEntityShelf) {
            TileEntityShelf tileEntityShelf = (TileEntityShelf)tileentity;
        }
    }

    public AxisAlignedBB func_180646_a(IBlockState state, World worldIn, BlockPos pos) {
        EnumFacing enumfacing = EnumFacing.func_176731_b((int)this.func_176201_c(state));
        return this.getAxisAlignedBBFromFacing(enumfacing);
    }

    private AxisAlignedBB getAxisAlignedBBFromFacing(EnumFacing facing) {
        double maxZ;
        double maxX;
        double maxY;
        double minX;
        double minY;
        double minZ;
        switch (facing) {
            default: {
                minZ = 0.0;
                minY = 0.0;
                minX = 0.0;
                maxY = 1.0;
                maxX = 1.0;
                maxZ = 0.5;
                break;
            }
            case EAST: {
                minX = 0.5;
                minZ = 0.0;
                minY = 0.0;
                maxY = 1.0;
                maxX = 1.0;
                maxZ = 1.0;
                break;
            }
            case SOUTH: {
                minY = 0.0;
                minX = 0.0;
                minZ = 0.5;
                maxY = 1.0;
                maxX = 1.0;
                maxZ = 1.0;
                break;
            }
            case WEST: {
                minZ = 0.0;
                minY = 0.0;
                minX = 0.0;
                maxX = 0.5;
                maxY = 1.0;
                maxZ = 1.0;
            }
        }
        return new AxisAlignedBB(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing blockFaceClickedOn, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        EnumFacing enumfacing = placer == null ? EnumFacing.NORTH : EnumFacing.func_176733_a((double)placer.field_70177_z);
        return this.func_176223_P().func_177226_a((IProperty)PROPERTYFACING, (Comparable)enumfacing);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        float SHELF_FRONT = 0.5f;
        if (worldIn.field_72995_K) {
            return true;
        }
        IInventory inventory = worldIn.func_175625_s(pos) instanceof IInventory ? (IInventory)worldIn.func_175625_s(pos) : null;
        float eyeHeight = playerIn.func_70047_e();
        EnumFacing enumfacing = EnumFacing.func_176731_b((int)this.func_176201_c(state));
        int selectedSlot = 0;
        switch (enumfacing) {
            default: {
                double delta = (double)(hitZ - 0.5f) / playerIn.func_70040_Z().field_72449_c;
                double actualY = (double)hitY - delta * playerIn.func_70040_Z().field_72448_b;
                double actualX = (double)hitX - delta * playerIn.func_70040_Z().field_72450_a;
                if (actualY > 0.5) {
                    if (actualX > 0.5) {
                        selectedSlot = 1;
                        break;
                    }
                    selectedSlot = 0;
                    break;
                }
                if (actualX > 0.5) {
                    selectedSlot = 3;
                    break;
                }
                selectedSlot = 2;
                break;
            }
            case EAST: {
                double delta = (double)(0.5f - hitX) / playerIn.func_70040_Z().field_72450_a;
                double actualY = hitY;
                double actualZ = hitZ;
                if (actualY > 0.5) {
                    if (actualZ > 0.5) {
                        selectedSlot = 1;
                        break;
                    }
                    selectedSlot = 0;
                    break;
                }
                if (actualZ > 0.5) {
                    selectedSlot = 3;
                    break;
                }
                selectedSlot = 2;
                break;
            }
            case SOUTH: {
                double delta = (double)(hitZ - 0.5f) / playerIn.func_70040_Z().field_72449_c;
                double actualY = (double)hitY - delta * playerIn.func_70040_Z().field_72448_b;
                double actualX = (double)hitX - delta * playerIn.func_70040_Z().field_72450_a;
                if (actualY > 0.5) {
                    if (actualX < 0.5) {
                        selectedSlot = 1;
                        break;
                    }
                    selectedSlot = 0;
                    break;
                }
                if (actualX < 0.5) {
                    selectedSlot = 3;
                    break;
                }
                selectedSlot = 2;
                break;
            }
            case WEST: {
                double delta = (double)(hitX - 0.5f) / playerIn.func_70040_Z().field_72450_a;
                double actualY = hitY;
                double actualZ = hitZ;
                if (actualY > 0.5) {
                    if (actualZ < 0.5) {
                        selectedSlot = 1;
                        break;
                    }
                    selectedSlot = 0;
                    break;
                }
                selectedSlot = actualZ < 0.5 ? 3 : 2;
            }
        }
        if (playerIn.func_184614_ca() == null && inventory.func_70301_a(selectedSlot) == null || inventory == null) {
            playerIn.openGui((Object)MissingPieces.instance, GuiHandlerShelf.getGuiID(), worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        } else if (playerIn.func_184614_ca() == null && inventory.func_70301_a(selectedSlot) != null) {
            playerIn.func_184611_a(EnumHand.MAIN_HAND, inventory.func_70301_a(selectedSlot));
            inventory.func_70299_a(selectedSlot, null);
            worldIn.func_184138_a(pos, state, state, 3);
        } else if (inventory.func_70301_a(selectedSlot) == null) {
            inventory.func_70299_a(selectedSlot, playerIn.func_184614_ca());
            playerIn.func_184611_a(EnumHand.MAIN_HAND, null);
            worldIn.func_184138_a(pos, state, state, 3);
        } else {
            playerIn.openGui((Object)MissingPieces.instance, GuiHandlerShelf.getGuiID(), worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        return true;
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        IInventory inventory;
        IInventory iInventory = inventory = worldIn.func_175625_s(pos) instanceof IInventory ? (IInventory)worldIn.func_175625_s(pos) : null;
        if (inventory != null) {
            for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                if (inventory.func_70301_a(i) == null) continue;
                EntityItem item = new EntityItem(worldIn, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, inventory.func_70301_a(i));
                float multiplier = 0.1f;
                float motionX = worldIn.field_73012_v.nextFloat() - 0.5f;
                float motionY = worldIn.field_73012_v.nextFloat() - 0.5f;
                float motionZ = worldIn.field_73012_v.nextFloat() - 0.5f;
                item.field_70159_w = motionX * multiplier;
                item.field_70181_x = motionY * multiplier;
                item.field_70179_y = motionZ * multiplier;
                worldIn.func_72838_d((Entity)item);
            }
            inventory.func_174888_l();
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public String getOredictName() {
        String name = this.func_149739_a().substring(5);
        String[] parts = name.split("_");
        String firstLetter = parts[1].substring(0, 1);
        return parts[0] + ":" + firstLetter.toUpperCase(Locale.ENGLISH) + ":" + parts[1].substring(1);
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return this.getAxisAlignedBBFromFacing(this.getFacingFromState(state));
    }

    public EnumFacing getFacingFromState(IBlockState state) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)PROPERTYFACING);
        return facing;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public IBlockState correctFacing(World worldIn, BlockPos pos, IBlockState state) {
        EnumFacing enumfacing = null;
        for (EnumFacing enumfacing1 : EnumFacing.Plane.HORIZONTAL) {
            IBlockState iblockstate = worldIn.func_180495_p(pos.func_177972_a(enumfacing1));
            if (iblockstate.func_177230_c() == this) {
                return state;
            }
            if (!iblockstate.func_185913_b()) continue;
            if (enumfacing != null) {
                enumfacing = null;
                break;
            }
            enumfacing = enumfacing1;
        }
        if (enumfacing != null) {
            return state.func_177226_a((IProperty)PROPERTYFACING, (Comparable)enumfacing.func_176734_d());
        }
        EnumFacing enumfacing2 = (EnumFacing)state.func_177229_b((IProperty)PROPERTYFACING);
        if (worldIn.func_180495_p(pos.func_177972_a(enumfacing2)).func_185913_b()) {
            enumfacing2 = enumfacing2.func_176734_d();
        }
        if (worldIn.func_180495_p(pos.func_177972_a(enumfacing2)).func_185913_b()) {
            enumfacing2 = enumfacing2.func_176746_e();
        }
        if (worldIn.func_180495_p(pos.func_177972_a(enumfacing2)).func_185913_b()) {
            enumfacing2 = enumfacing2.func_176734_d();
        }
        return state.func_177226_a((IProperty)PROPERTYFACING, (Comparable)enumfacing2);
    }

    public static enum ShelfInfo {
        ACACIA("acacia_shelf", BlockInfo.BlockType.BT_PLANK_ACACIA, Material.field_151575_d, MpConfiguration.shelfAcacia),
        BIRCH("birch_shelf", BlockInfo.BlockType.BT_PLANK_BIRCH, Material.field_151575_d, MpConfiguration.shelfBirch),
        DARK_OAK("dark_oak_shelf", BlockInfo.BlockType.BT_PLANK_DARK_OAK, Material.field_151575_d, MpConfiguration.shelfDarkOak),
        JUNGLE("jungle_shelf", BlockInfo.BlockType.BT_PLANK_JUNGLE, Material.field_151575_d, MpConfiguration.shelfJungle),
        OAK("oak_shelf", BlockInfo.BlockType.BT_PLANK_OAK, Material.field_151575_d, MpConfiguration.shelfOak),
        SPRUCE("spruce_shelf", BlockInfo.BlockType.BT_PLANK_SPRUCE, Material.field_151575_d, MpConfiguration.shelfSpruce);

        String shelfName;
        ItemStack shelfIngredientA;
        Material matType;
        Boolean enabled;

        private ShelfInfo(String name, BlockInfo.BlockType ingredientA, Material mType, Boolean enable) {
            this.shelfName = name;
            this.shelfIngredientA = BlockInfo.blockType2Stack(ingredientA);
            this.matType = mType;
            this.enabled = enable;
        }

        public Material getMaterial() {
            return this.matType;
        }

        public String getName() {
            return this.shelfName;
        }
    }
}

