/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import mekanism.api.MekanismConfig;
import mekanism.client.HolidayManager;
import mekanism.client.sound.ISoundSource;
import mekanism.common.Upgrade;
import mekanism.common.base.IActiveState;
import mekanism.common.base.IHasSound;
import mekanism.common.base.IUpgradeTile;
import mekanism.common.base.SoundWrapper;
import mekanism.common.tile.TileEntityElectricBlock;
import net.minecraft.client.audio.ISound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class TileEntityNoisyElectricBlock
extends TileEntityElectricBlock
implements IHasSound,
ISoundSource,
IActiveState {
    public ResourceLocation soundURL;
    @SideOnly(value=Side.CLIENT)
    public SoundWrapper sound;
    public String soundPath;

    public TileEntityNoisyElectricBlock(String sound, String name, double maxEnergy) {
        super(name, maxEnergy);
        this.soundPath = sound;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public SoundWrapper getSound() {
        return this.sound;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean shouldPlaySound() {
        return this.getActive() && !this.func_145837_r();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ResourceLocation getSoundLocation() {
        return this.soundURL;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public float getVolume() {
        if (this instanceof IUpgradeTile && ((IUpgradeTile)((Object)this)).getComponent().supports(Upgrade.MUFFLING)) {
            return Math.max(0.001f, 1.0f - (float)((IUpgradeTile)((Object)this)).getComponent().getUpgrades(Upgrade.MUFFLING) / (float)Upgrade.MUFFLING.getMax());
        }
        return 1.0f;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public float getFrequency() {
        return 1.0f;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Vec3d getSoundPosition() {
        return new Vec3d((Vec3i)this.func_174877_v()).func_72441_c(0.5, 0.5, 0.5);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean shouldRepeat() {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getRepeatDelay() {
        return 0;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ISound.AttenuationType getAttenuation() {
        return ISound.AttenuationType.LINEAR;
    }

    @Override
    public void func_145829_t() {
        super.func_145829_t();
        if (this.field_145850_b.field_72995_K) {
            try {
                this.soundURL = HolidayManager.filterSound(new ResourceLocation("mekanism", "tile." + this.soundPath));
                this.initSounds();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void initSounds() {
        this.sound = new SoundWrapper(this, this);
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (this.field_145850_b.field_72995_K) {
            this.updateSound();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void updateSound() {
        if (this.shouldPlaySound() && this.getSound().canRestart() && MekanismConfig.client.enableMachineSounds) {
            this.getSound().reset();
            this.getSound().play();
        }
    }
}

