/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration;

import ic2.api.recipe.IRecipeInput;
import ic2.api.recipe.RecipeInputOreDict;
import ic2.api.recipe.Recipes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mekanism.api.gas.GasRegistry;
import mekanism.api.gas.GasStack;
import mekanism.api.infuse.InfuseObject;
import mekanism.api.infuse.InfuseRegistry;
import mekanism.api.util.StackUtils;
import mekanism.common.Mekanism;
import mekanism.common.MekanismItems;
import mekanism.common.Resource;
import mekanism.common.recipe.RecipeHandler;
import mekanism.common.util.MekanismUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.oredict.OreDictionary;

public final class OreDictManager {
    private static final List<String> minorCompat = Arrays.asList("Nickel", "Aluminum", "Uranium", "Draconium");

    public static void init() {
        OreDictManager.addLogRecipes();
        for (ItemStack ore : OreDictionary.getOres((String)"plankWood")) {
            if (ore.func_77981_g()) {
                ItemStack wildStack = new ItemStack(ore.func_77973_b(), 1, Short.MAX_VALUE);
                if (RecipeHandler.Recipe.PRECISION_SAWMILL.containsRecipe(wildStack)) continue;
                RecipeHandler.addPrecisionSawmillRecipe(wildStack, new ItemStack(Items.field_151055_y, 6), new ItemStack(MekanismItems.Sawdust), 0.25);
                continue;
            }
            RecipeHandler.addPrecisionSawmillRecipe(StackUtils.size(ore, 1), new ItemStack(Items.field_151055_y, 6), new ItemStack(MekanismItems.Sawdust), 0.25);
        }
        for (ItemStack ore : OreDictionary.getOres((String)"oreNetherSteel")) {
            RecipeHandler.addEnrichmentChamberRecipe(StackUtils.size(ore, 1), new ItemStack(MekanismItems.OtherDust, 4, 1));
        }
        if (OreDictionary.getOres((String)"itemRubber").size() > 0) {
            for (ItemStack ore : OreDictionary.getOres((String)"woodRubber")) {
                RecipeHandler.addPrecisionSawmillRecipe(StackUtils.size(ore, 1), new ItemStack(Blocks.field_150344_f, 4), StackUtils.size((ItemStack)OreDictionary.getOres((String)"itemRubber").get(0), 1), 1.0);
            }
        }
        for (ItemStack ore : OreDictionary.getOres((String)"dustSulfur")) {
            RecipeHandler.addChemicalOxidizerRecipe(StackUtils.size(ore, 1), new GasStack(GasRegistry.getGas("sulfurDioxideGas"), 100));
        }
        for (ItemStack ore : OreDictionary.getOres((String)"dustSalt")) {
            RecipeHandler.addChemicalOxidizerRecipe(StackUtils.size(ore, 1), new GasStack(GasRegistry.getGas("brine"), 15));
        }
        for (ItemStack ore : OreDictionary.getOres((String)"dustRefinedObsidian")) {
            RecipeHandler.addOsmiumCompressorRecipe(StackUtils.size(ore, 1), new ItemStack(MekanismItems.Ingot, 1, 0));
            RecipeHandler.addCrusherRecipe(StackUtils.size(ore, 1), new ItemStack(MekanismItems.OtherDust, 1, 6));
            RecipeHandler.addEnrichmentChamberRecipe(StackUtils.size(ore, 1), new ItemStack(MekanismItems.CompressedObsidian));
            InfuseRegistry.registerInfuseObject(StackUtils.size(ore, 1), new InfuseObject(InfuseRegistry.get("OBSIDIAN"), 10));
        }
        for (Resource resource : Resource.values()) {
            for (ItemStack ore : OreDictionary.getOres((String)("clump" + resource.getName()))) {
                RecipeHandler.addCrusherRecipe(StackUtils.size(ore, 1), new ItemStack(MekanismItems.DirtyDust, 1, resource.ordinal()));
            }
            for (ItemStack ore : OreDictionary.getOres((String)("shard" + resource.getName()))) {
                RecipeHandler.addPurificationChamberRecipe(StackUtils.size(ore, 1), new ItemStack(MekanismItems.Clump, 1, resource.ordinal()));
            }
            for (ItemStack ore : OreDictionary.getOres((String)("crystal" + resource.getName()))) {
                RecipeHandler.addChemicalInjectionChamberRecipe(StackUtils.size(ore, 1), "hydrogenChloride", new ItemStack(MekanismItems.Shard, 1, resource.ordinal()));
            }
            for (ItemStack ore : OreDictionary.getOres((String)("dustDirty" + resource.getName()))) {
                RecipeHandler.addEnrichmentChamberRecipe(StackUtils.size(ore, 1), new ItemStack(MekanismItems.Dust, 1, resource.ordinal()));
            }
            for (ItemStack ore : OreDictionary.getOres((String)("ore" + resource.getName()))) {
                RecipeHandler.addEnrichmentChamberRecipe(StackUtils.size(ore, 1), new ItemStack(MekanismItems.Dust, 2, resource.ordinal()));
                RecipeHandler.addPurificationChamberRecipe(StackUtils.size(ore, 1), new ItemStack(MekanismItems.Clump, 3, resource.ordinal()));
                RecipeHandler.addChemicalInjectionChamberRecipe(StackUtils.size(ore, 1), "hydrogenChloride", new ItemStack(MekanismItems.Shard, 4, resource.ordinal()));
                RecipeHandler.addChemicalDissolutionChamberRecipe(StackUtils.size(ore, 1), new GasStack(GasRegistry.getGas(resource.getName().toLowerCase()), 1000));
            }
            for (ItemStack ore : OreDictionary.getOres((String)("ingot" + resource.getName()))) {
                RecipeHandler.addCrusherRecipe(StackUtils.size(ore, 1), new ItemStack(MekanismItems.Dust, 1, resource.ordinal()));
            }
            try {
                for (ItemStack ore : OreDictionary.getOres((String)("dust" + resource.getName()))) {
                    RecipeHandler.addCombinerRecipe(StackUtils.size(ore, 8), StackUtils.size((ItemStack)OreDictionary.getOres((String)("ore" + resource.getName())).get(0), 1));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        for (String s : minorCompat) {
            for (ItemStack ore : OreDictionary.getOres((String)("ore" + s))) {
                try {
                    RecipeHandler.addEnrichmentChamberRecipe(StackUtils.size(ore, 1), StackUtils.size((ItemStack)OreDictionary.getOres((String)("dust" + s)).get(0), 2));
                }
                catch (Exception exception) {}
            }
            for (ItemStack ore : OreDictionary.getOres((String)("ingot" + s))) {
                try {
                    RecipeHandler.addCrusherRecipe(StackUtils.size(ore, 1), StackUtils.size((ItemStack)OreDictionary.getOres((String)("dust" + s)).get(0), 1));
                }
                catch (Exception exception) {}
            }
            for (ItemStack ore : OreDictionary.getOres((String)("dust" + s))) {
                try {
                    RecipeHandler.addCombinerRecipe(StackUtils.size(ore, 8), StackUtils.size((ItemStack)OreDictionary.getOres((String)("ore" + s)).get(0), 1));
                }
                catch (Exception exception) {}
            }
        }
        for (ItemStack ore : OreDictionary.getOres((String)"oreYellorite")) {
            try {
                RecipeHandler.addEnrichmentChamberRecipe(StackUtils.size(ore, 1), StackUtils.size((ItemStack)OreDictionary.getOres((String)"dustYellorium").get(0), 2));
            }
            catch (Exception exception) {}
        }
        for (ItemStack ore : OreDictionary.getOres((String)"oreCertusQuartz")) {
            try {
                RecipeHandler.addEnrichmentChamberRecipe(StackUtils.size(ore, 1), StackUtils.size((ItemStack)OreDictionary.getOres((String)"dustCertusQuartz").get(0), 4));
            }
            catch (Exception exception) {}
        }
        for (ItemStack ore : OreDictionary.getOres((String)"crystalCertusQuartz")) {
            try {
                RecipeHandler.addCrusherRecipe(StackUtils.size(ore, 1), StackUtils.size((ItemStack)OreDictionary.getOres((String)"dustCertusQuartz").get(0), 1));
            }
            catch (Exception exception) {}
        }
        for (ItemStack ore : OreDictionary.getOres((String)"dustCertusQuartz")) {
            try {
                RecipeHandler.addEnrichmentChamberRecipe(StackUtils.size(ore, 1), StackUtils.size((ItemStack)OreDictionary.getOres((String)"crystalCertusQuartz").get(0), 1));
            }
            catch (Exception exception) {}
        }
        for (ItemStack ore : OreDictionary.getOres((String)"gemQuartz")) {
            try {
                RecipeHandler.addCrusherRecipe(StackUtils.size(ore, 1), StackUtils.size((ItemStack)OreDictionary.getOres((String)"dustNetherQuartz").get(0), 1));
            }
            catch (Exception exception) {}
        }
        for (ItemStack ore : OreDictionary.getOres((String)"dustNetherQuartz")) {
            try {
                RecipeHandler.addEnrichmentChamberRecipe(StackUtils.size(ore, 1), StackUtils.size((ItemStack)OreDictionary.getOres((String)"gemQuartz").get(0), 1));
            }
            catch (Exception exception) {}
        }
        for (ItemStack ore : OreDictionary.getOres((String)"oreQuartz")) {
            RecipeHandler.addEnrichmentChamberRecipe(StackUtils.size(ore, 1), new ItemStack(Items.field_151128_bU, 6));
        }
        for (ItemStack ore : OreDictionary.getOres((String)"crystalFluix")) {
            try {
                RecipeHandler.addCrusherRecipe(StackUtils.size(ore, 1), StackUtils.size((ItemStack)OreDictionary.getOres((String)"dustFluix").get(0), 1));
            }
            catch (Exception exception) {}
        }
        for (ItemStack ore : OreDictionary.getOres((String)"dustFluix")) {
            try {
                RecipeHandler.addEnrichmentChamberRecipe(StackUtils.size(ore, 1), StackUtils.size((ItemStack)OreDictionary.getOres((String)"crystalFluix").get(0), 1));
            }
            catch (Exception exception) {}
        }
        for (ItemStack ore : OreDictionary.getOres((String)"ingotCopper")) {
            RecipeHandler.addMetallurgicInfuserRecipe(InfuseRegistry.get("TIN"), 10, StackUtils.size(ore, 1), new ItemStack(MekanismItems.Ingot, 1, 2));
        }
        for (ItemStack ore : OreDictionary.getOres((String)"ingotRefinedObsidian")) {
            RecipeHandler.addCrusherRecipe(StackUtils.size(ore, 1), new ItemStack(MekanismItems.OtherDust, 1, 6));
        }
        for (ItemStack ore : OreDictionary.getOres((String)"ingotOsmium")) {
            RecipeHandler.addMetallurgicInfuserRecipe(InfuseRegistry.get("REDSTONE"), 10, StackUtils.size(ore, 1), new ItemStack(MekanismItems.ControlCircuit, 1, 0));
        }
        for (ItemStack ore : OreDictionary.getOres((String)"ingotRedstone")) {
            RecipeHandler.addCrusherRecipe(StackUtils.size(ore, 1), new ItemStack(Items.field_151137_ax));
        }
        for (ItemStack ore : OreDictionary.getOres((String)"ingotRefinedGlowstone")) {
            RecipeHandler.addCrusherRecipe(StackUtils.size(ore, 1), new ItemStack(Items.field_151114_aO));
        }
        try {
            RecipeHandler.addCrusherRecipe(new ItemStack(MekanismItems.Ingot, 1, 2), StackUtils.size((ItemStack)OreDictionary.getOres((String)"dustBronze").get(0), 1));
            if (Mekanism.hooks.IC2Loaded) {
                OreDictManager.addIC2BronzeRecipe();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            FurnaceRecipes.func_77602_a().func_151394_a(new ItemStack(MekanismItems.Dust, 1, Resource.SILVER.ordinal()), StackUtils.size((ItemStack)OreDictionary.getOres((String)"ingotSilver").get(0), 1), 0.0f);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            FurnaceRecipes.func_77602_a().func_151394_a(new ItemStack(MekanismItems.Dust, 1, Resource.LEAD.ordinal()), StackUtils.size((ItemStack)OreDictionary.getOres((String)"ingotLead").get(0), 1), 0.0f);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            RecipeHandler.addCrusherRecipe(new ItemStack(Items.field_151044_h), StackUtils.size((ItemStack)OreDictionary.getOres((String)"dustCoal").get(0), 1));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            RecipeHandler.addCrusherRecipe(new ItemStack(Items.field_151044_h, 1, 1), StackUtils.size((ItemStack)OreDictionary.getOres((String)"dustCharcoal").get(0), 1));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            RecipeHandler.addCrusherRecipe(new ItemStack(Items.field_151016_H), StackUtils.size((ItemStack)OreDictionary.getOres((String)"dustSaltpeter").get(0), 1));
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (ItemStack ore : OreDictionary.getOres((String)"sand")) {
            try {
                RecipeHandler.addCrusherRecipe(StackUtils.size(ore, 1), StackUtils.size((ItemStack)OreDictionary.getOres((String)"itemSilicon").get(0), 1));
            }
            catch (Exception exception) {}
        }
        for (ItemStack ore : OreDictionary.getOres((String)"dustSaltpeter")) {
            RecipeHandler.addEnrichmentChamberRecipe(StackUtils.size(ore, 1), new ItemStack(Items.field_151016_H));
        }
        for (ItemStack ore : OreDictionary.getOres((String)"ingotSteel")) {
            RecipeHandler.addCrusherRecipe(StackUtils.size(ore, 1), new ItemStack(MekanismItems.OtherDust, 1, 1));
        }
        for (ItemStack ore : OreDictionary.getOres((String)"dustLapis")) {
            RecipeHandler.addCrusherRecipe(new ItemStack(Items.field_151100_aR, 1, 4), StackUtils.size(ore, 1));
        }
        for (ItemStack ore : OreDictionary.getOres((String)"dustLithium")) {
            RecipeHandler.addChemicalOxidizerRecipe(StackUtils.size(ore, 1), new GasStack(GasRegistry.getGas("lithium"), 100));
        }
        for (ItemStack ore : OreDictionary.getOres((String)"dustObsidian")) {
            RecipeHandler.addCombinerRecipe(StackUtils.size(ore, 4), new ItemStack(Blocks.field_150343_Z));
            RecipeHandler.addMetallurgicInfuserRecipe(InfuseRegistry.get("DIAMOND"), 10, StackUtils.size(ore, 1), new ItemStack(MekanismItems.OtherDust, 1, 5));
        }
        for (ItemStack ore : OreDictionary.getOres((String)"dustDiamond")) {
            InfuseRegistry.registerInfuseObject(ore, new InfuseObject(InfuseRegistry.get("DIAMOND"), 10));
            RecipeHandler.addEnrichmentChamberRecipe(StackUtils.size(ore, 1), new ItemStack(Items.field_151045_i));
        }
        for (ItemStack ore : OreDictionary.getOres((String)"dustTin")) {
            InfuseRegistry.registerInfuseObject(ore, new InfuseObject(InfuseRegistry.get("TIN"), 50));
        }
        try {
            for (ItemStack ore : OreDictionary.getOres((String)"treeSapling")) {
                if (ore.func_77952_i() != 0 && ore.func_77952_i() != Short.MAX_VALUE) continue;
                RecipeHandler.addCrusherRecipe(new ItemStack(ore.func_77973_b(), 1, Short.MAX_VALUE), new ItemStack(MekanismItems.BioFuel, 2));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Optional.Method(modid="IC2")
    public static void addIC2BronzeRecipe() {
        try {
            Recipes.macerator.addRecipe((IRecipeInput)new RecipeInputOreDict("ingotBronze"), null, false, new ItemStack[]{StackUtils.size((ItemStack)OreDictionary.getOres((String)"dustBronze").get(0), 1)});
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void addLogRecipes() {
        Container tempContainer = new Container(){

            public boolean func_75145_c(EntityPlayer player) {
                return false;
            }
        };
        InventoryCrafting tempCrafting = new InventoryCrafting(tempContainer, 3, 3);
        ArrayList recipeList = (ArrayList)CraftingManager.func_77594_a().func_77592_b();
        for (int i = 1; i < 9; ++i) {
            tempCrafting.func_70299_a(i, null);
        }
        List registeredOres = OreDictionary.getOres((String)"logWood");
        for (int i = 0; i < registeredOres.size(); ++i) {
            ItemStack logEntry = (ItemStack)registeredOres.get(i);
            if (logEntry.func_77952_i() == Short.MAX_VALUE) {
                for (int j = 0; j < 16; ++j) {
                    ItemStack log = new ItemStack(logEntry.func_77973_b(), 1, j);
                    tempCrafting.func_70299_a(0, log);
                    ItemStack resultEntry = MekanismUtils.findMatchingRecipe(tempCrafting, null);
                    if (resultEntry == null) continue;
                    RecipeHandler.addPrecisionSawmillRecipe(log, StackUtils.size(resultEntry, 6), new ItemStack(MekanismItems.Sawdust), 1.0);
                }
                continue;
            }
            ItemStack log = StackUtils.size(logEntry, 1);
            tempCrafting.func_70299_a(0, log);
            ItemStack resultEntry = MekanismUtils.findMatchingRecipe(tempCrafting, null);
            if (resultEntry == null) continue;
            RecipeHandler.addPrecisionSawmillRecipe(log, StackUtils.size(resultEntry, 6), new ItemStack(MekanismItems.Sawdust), 1.0);
        }
    }
}

