/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.jei;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import mekanism.api.gas.GasStack;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.gui.element.GuiProgress;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.util.LangUtils;
import mezz.jei.api.recipe.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public abstract class BaseRecipeCategory
implements IRecipeCategory,
IGuiWrapper {
    public static final GuiDummy gui = new GuiDummy();
    public String recipeName;
    public String unlocalizedName;
    public String guiTexture;
    public ResourceLocation guiLocation;
    public GuiProgress.ProgressBar progressBar;
    public int xOffset = 28;
    public int yOffset = 16;
    public Set<GuiElement> guiElements = new HashSet<GuiElement>();

    public BaseRecipeCategory(String gui, String name, String unlocalized, GuiProgress.ProgressBar progress) {
        this.guiTexture = gui;
        this.guiLocation = new ResourceLocation(this.guiTexture);
        this.progressBar = progress;
        this.recipeName = name;
        this.unlocalizedName = unlocalized;
        this.addGuiElements();
    }

    public String getUid() {
        return "mekanism." + this.recipeName;
    }

    public String getTitle() {
        return LangUtils.localize(this.unlocalizedName);
    }

    public void drawExtras(Minecraft minecraft) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.changeTexture(this.guiLocation);
        for (GuiElement e : this.guiElements) {
            e.renderBackground(0, 0, -this.xOffset, -this.yOffset);
        }
    }

    public void drawAnimations(Minecraft minecraft) {
    }

    @Override
    public void drawTexturedRect(int x, int y, int u, int v, int w, int h) {
        gui.func_73729_b(x, y, u, v, w, h);
    }

    @Override
    public void drawTexturedRectFromIcon(int x, int y, TextureAtlasSprite icon, int w, int h) {
        gui.func_175175_a(x, y, icon, w, h);
    }

    @Override
    public void displayTooltip(String s, int xAxis, int yAxis) {
    }

    @Override
    public void displayTooltips(List<String> list, int xAxis, int yAxis) {
    }

    @Override
    public FontRenderer getFont() {
        return null;
    }

    public void displayGauge(int length, int xPos, int yPos, int overlayX, int overlayY, int scale, FluidStack fluid, GasStack gas) {
        int renderRemaining;
        if (fluid == null && gas == null) {
            return;
        }
        int start = 0;
        do {
            renderRemaining = 0;
            if (scale > 16) {
                renderRemaining = 16;
                scale -= 16;
            } else {
                renderRemaining = scale;
                scale = 0;
            }
            this.changeTexture(MekanismRenderer.getBlocksTexture());
            if (fluid != null) {
                gui.func_175175_a(xPos, yPos + length - renderRemaining - start, MekanismRenderer.getFluidTexture(fluid.getFluid(), MekanismRenderer.FluidType.STILL), 16, 16 - (16 - renderRemaining));
            } else if (gas != null) {
                gui.func_175175_a(xPos, yPos + length - renderRemaining - start, gas.getGas().getSprite(), 16, 16 - (16 - renderRemaining));
            }
            start += 16;
        } while (renderRemaining != 0 && scale != 0);
        this.changeTexture(this.guiLocation);
        gui.func_73729_b(xPos, yPos, overlayX, overlayY, 16, length + 1);
    }

    public void displayGauge(int xPos, int yPos, int sizeX, int sizeY, GasStack gas) {
        if (gas == null) {
            return;
        }
        this.changeTexture(MekanismRenderer.getBlocksTexture());
        gui.func_175175_a(xPos, yPos, gas.getGas().getSprite(), sizeX, sizeY);
    }

    public String stripTexture() {
        return this.guiTexture.replace("mekanism:gui/", "");
    }

    public void changeTexture(ResourceLocation texture) {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(texture);
    }

    public void addGuiElements() {
    }

    public static class GuiDummy
    extends Gui {
    }
}

