/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.gas;

import mekanism.api.gas.GasRegistry;
import mekanism.client.render.MekanismRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public class Gas {
    private String name;
    private String unlocalizedName;
    private Fluid fluid;
    private ResourceLocation iconLocation;
    private TextureAtlasSprite sprite;
    private boolean visible = true;
    private boolean from_fluid = false;

    public Gas(String s, String icon) {
        this.unlocalizedName = this.name = s;
        this.iconLocation = new ResourceLocation(icon);
    }

    public Gas(Fluid f) {
        this.unlocalizedName = this.name = f.getName();
        this.iconLocation = f.getStill();
        this.fluid = f;
        this.from_fluid = true;
    }

    public String getName() {
        return this.name;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public Gas setVisible(boolean v) {
        this.visible = v;
        return this;
    }

    public String getUnlocalizedName() {
        return "gas." + this.unlocalizedName;
    }

    public String getLocalizedName() {
        return I18n.func_74838_a((String)this.getUnlocalizedName());
    }

    public Gas setUnlocalizedName(String s) {
        this.unlocalizedName = s;
        return this;
    }

    public ResourceLocation getIcon() {
        if (this.from_fluid) {
            return this.getFluid().getStill();
        }
        return this.iconLocation;
    }

    public TextureAtlasSprite getSprite() {
        if (this.from_fluid) {
            return MekanismRenderer.getFluidTexture(this.fluid, MekanismRenderer.FluidType.STILL);
        }
        return this.sprite;
    }

    public Gas registerIcon(TextureMap map) {
        map.func_174942_a(this.iconLocation);
        this.from_fluid = false;
        return this;
    }

    public Gas updateIcon(TextureMap map) {
        TextureAtlasSprite tex = map.getTextureExtry(this.iconLocation.toString());
        if (tex != null) {
            this.sprite = tex;
        }
        return this;
    }

    public int getID() {
        return GasRegistry.getGasID(this);
    }

    public NBTTagCompound write(NBTTagCompound nbtTags) {
        nbtTags.func_74778_a("gasName", this.getName());
        return nbtTags;
    }

    public static Gas readFromNBT(NBTTagCompound nbtTags) {
        if (nbtTags == null || nbtTags.func_82582_d()) {
            return null;
        }
        return GasRegistry.getGas(nbtTags.func_74779_i("gasName"));
    }

    public boolean hasFluid() {
        return this.fluid != null;
    }

    public Fluid getFluid() {
        return this.fluid;
    }

    public Gas registerFluid() {
        if (this.fluid == null) {
            if (FluidRegistry.getFluid((String)this.getName()) == null) {
                this.fluid = new Fluid(this.getName(), this.getIcon(), this.getIcon()).setGaseous(true);
                FluidRegistry.registerFluid((Fluid)this.fluid);
            } else {
                this.fluid = FluidRegistry.getFluid((String)this.getName());
            }
        }
        return this;
    }

    public String toString() {
        return this.name;
    }
}

