/*
 * Decompiled with CFR 0.152.
 */
package com.workshopcraft.simplebarrels.tiles;

import com.workshopcraft.simplebarrels.handlers.BarrelItemHandler;
import java.util.HashMap;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;

public class TileEntityBarrel
extends TileEntity {
    public BarrelItemHandler itemHandler = new BarrelItemHandler();
    public IBlockState state;
    public Boolean itemIsBlock = false;
    private int ticksSinceSync;
    private String customName;
    public int numPlayersUsing;
    public int ticks = 0;
    public Boolean comp;
    public Boolean frame;
    public HashMap playerClicks;

    public TileEntityBarrel() {
        this.itemHandler.t = this;
        this.comp = false;
        this.frame = false;
        this.playerClicks = new HashMap();
    }

    public TileEntityBarrel(Boolean c, Boolean f) {
        this.itemHandler.t = this;
        this.comp = c;
        this.frame = f;
        this.playerClicks = new HashMap();
    }

    public void init(Boolean c, Boolean f) {
        this.comp = c;
        this.frame = f;
    }

    public void init(Boolean c, Boolean f, int s) {
        this.comp = c;
        this.frame = f;
        this.itemHandler.size = s;
    }

    public String getName() {
        return this.hasCustomName() ? this.customName : "container.chest";
    }

    public boolean hasCustomName() {
        return this.customName != null && !this.customName.isEmpty();
    }

    public void setCustomName(String name) {
        this.customName = name;
    }

    public boolean isBlock(ItemStack i) {
        return i.func_77973_b() instanceof ItemBlock;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.itemHandler.count = compound.func_74762_e("count");
        if (compound.func_150297_b("CustomName", 8)) {
            this.customName = compound.func_74779_i("CustomName");
        }
        this.comp = compound.func_74767_n("comp");
        this.frame = compound.func_74767_n("frame");
        this.itemHandler.size = compound.func_74762_e("size");
        if (this.itemHandler.size == 0) {
            this.itemHandler.size = 4096;
        }
        if (this.itemHandler.count > 0) {
            NBTTagList nbttaglist = compound.func_150295_c("Items", 10);
            NBTTagCompound nbttagcompound = nbttaglist.func_150305_b(0);
            int j = nbttagcompound.func_74771_c("Slot") & 0xFF;
            this.itemHandler.barrelContents = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound);
            this.itemHandler.barrelContents.func_77964_b(compound.func_74762_e("state"));
        }
        NBTTagList playerList = compound.func_150295_c("players", 10);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        NBTTagList nbttaglist = new NBTTagList();
        if (this.itemHandler != null && this.itemHandler.count > 0) {
            if (this.itemHandler.barrelContents != null) {
                NBTTagCompound nbttagcompound = new NBTTagCompound();
                nbttagcompound.func_74774_a("Slot", (byte)0);
                this.itemHandler.barrelContents.func_77955_b(nbttagcompound);
                nbttaglist.func_74742_a((NBTBase)nbttagcompound);
            }
            compound.func_74782_a("Items", (NBTBase)nbttaglist);
            compound.func_74768_a("count", this.itemHandler.count);
            compound.func_74768_a("size", this.itemHandler.size);
            if (this.itemHandler.barrelContents != null) {
                compound.func_74768_a("state", this.itemHandler.barrelContents.func_77973_b().getMetadata(this.itemHandler.barrelContents));
            } else {
                compound.func_74768_a("state", 0);
            }
        }
        compound.func_74757_a("comp", this.comp.booleanValue());
        compound.func_74757_a("frame", this.frame.booleanValue());
        if (this.hasCustomName()) {
            compound.func_74778_a("CustomName", this.customName);
        }
        if (this.playerClicks.size() > 0) {
            // empty if block
        }
        return compound;
    }

    public int getInventoryStackLimit() {
        return 65535;
    }

    public boolean isUseableByPlayer(EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) != this ? false : player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_145836_u() {
        super.func_145836_u();
    }

    public boolean func_145842_c(int id, int type) {
        if (id == 1) {
            this.numPlayersUsing = type;
            return true;
        }
        return super.func_145842_c(id, type);
    }

    public boolean isItemValidForSlot(int index, ItemStack stack) {
        return this.itemHandler.barrelContents != null && this.itemHandler.barrelContents.equals(stack) && this.itemHandler.barrelContents.func_77978_p().equals((Object)stack.func_77978_p());
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.func_145836_u();
    }

    public int getField(int id) {
        return 0;
    }

    public void setField(int id, int value) {
    }

    public int getFieldCount() {
        return 0;
    }

    public void clear() {
        this.itemHandler.barrelContents = null;
        this.itemHandler.count = 0;
    }

    @Nullable
    public final SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public final NBTTagCompound func_189517_E_() {
        NBTTagCompound tag = super.func_189517_E_();
        if (tag == null) {
            tag = new NBTTagCompound();
        }
        this.writeTileClientData(tag);
        return tag;
    }

    private void writeTileClientData(NBTTagCompound compound) {
        NBTTagList nbttaglist = new NBTTagList();
        if (this.itemHandler != null && this.itemHandler.count != 0) {
            if (this.itemHandler.barrelContents != null) {
                NBTTagCompound nbttagcompound = new NBTTagCompound();
                nbttagcompound.func_74774_a("Slot", (byte)0);
                this.itemHandler.barrelContents.func_77955_b(nbttagcompound);
                nbttaglist.func_74742_a((NBTBase)nbttagcompound);
            }
            compound.func_74782_a("Items", (NBTBase)nbttaglist);
            compound.func_74768_a("count", this.itemHandler.count);
            compound.func_74757_a("comp", this.comp.booleanValue());
            compound.func_74757_a("frame", this.frame.booleanValue());
            compound.func_74768_a("size", this.itemHandler.size);
            if (this.itemHandler.barrelContents != null) {
                compound.func_74768_a("state", this.itemHandler.barrelContents.func_77973_b().getMetadata(this.itemHandler.barrelContents));
            } else {
                compound.func_74768_a("state", 0);
            }
        }
        if (this.hasCustomName()) {
            compound.func_74778_a("CustomName", this.customName);
        }
    }

    public final void onDataPacket(NetworkManager m, SPacketUpdateTileEntity p) {
        this.readTileClientData(p.func_148857_g());
        IBlockState state = this.getBlockState();
        this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
    }

    private IBlockState getBlockState() {
        return this.func_145831_w().func_180495_p(this.func_174877_v());
    }

    private void readTileClientData(NBTTagCompound compound) {
        if (compound != null) {
            if (compound.func_150297_b("CustomName", 8)) {
                this.customName = compound.func_74779_i("CustomName");
            }
            this.comp = compound.func_74767_n("comp");
            this.frame = compound.func_74767_n("frame");
            this.itemHandler.size = compound.func_74762_e("size");
            if (this.itemHandler.size == 0) {
                this.itemHandler.size = 4096;
            }
            NBTTagList nbttaglist = compound.func_150295_c("Items", 10);
            NBTTagCompound nbttagcompound = nbttaglist.func_150305_b(0);
            int j = nbttagcompound.func_74771_c("Slot") & 0xFF;
            this.itemHandler.barrelContents = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound);
            this.itemHandler.count = compound.func_74762_e("count");
            int st = compound.func_74762_e("state");
            int s = 0;
            boolean err = false;
            try {
                s = compound.func_74762_e("state");
            }
            catch (NullPointerException e) {
                err = true;
            }
            if (!err && this.itemHandler.barrelContents != null) {
                this.itemHandler.barrelContents.func_77973_b().setDamage(this.itemHandler.barrelContents, s);
            }
        }
    }

    public ITextComponent func_145748_c_() {
        return null;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.itemHandler;
        }
        return (T)super.getCapability(capability, facing);
    }

    public void onBreakBlock() {
        ItemStack istack = new ItemStack(this.func_145838_q(), 1);
        NBTTagCompound n = new NBTTagCompound();
        n.func_74757_a("comp", this.comp.booleanValue());
        n.func_74757_a("frame", this.frame.booleanValue());
        n.func_74768_a("size", this.itemHandler.size);
        istack.func_77982_d(this.getTileData());
    }
}

