/*
 * Decompiled with CFR 0.152.
 */
package com.workshopcraft.simplebarrels.blocks;

import com.workshopcraft.simplebarrels.SimpleBarrels;
import com.workshopcraft.simplebarrels.tesr.TESRBlockBarrel;
import com.workshopcraft.simplebarrels.tiles.TileEntityBarrel;
import java.util.ArrayList;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockBarrel
extends BlockContainer {
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;

    public BlockBarrel() {
        super(Material.field_151575_d);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
        this.func_149647_a(SimpleBarrels.tabSimpleBarrels);
        this.func_149711_c(2.0f);
        this.func_149752_b(6.0f);
        this.setHarvestLevel("Axe", 0);
    }

    public BlockBarrel(String uname) {
        super(Material.field_151575_d);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
        this.func_149647_a(SimpleBarrels.tabSimpleBarrels);
        this.func_149711_c(2.0f);
        this.func_149752_b(6.0f);
        this.setHarvestLevel("Axe", 0);
        this.func_149663_c(uname);
        this.setRegistryName(uname);
    }

    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityBarrel.class, (TileEntitySpecialRenderer)new TESRBlockBarrel());
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return true;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO());
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        NBTTagCompound n = new NBTTagCompound();
        n = stack.func_77978_p();
        if (n != null) {
            TileEntity t1;
            Boolean c = n.func_74767_n("comp");
            Boolean f = n.func_74767_n("frame");
            int s = n.func_74762_e("size");
            if (s == 0) {
                s = 4096;
            }
            if ((t1 = worldIn.func_175625_s(pos)) == null) {
                return;
            }
            if (!(t1 instanceof TileEntityBarrel)) {
                return;
            }
            TileEntityBarrel t = (TileEntityBarrel)t1;
            if (t != null) {
                t.init(c, f, s);
                t.itemHandler.size = s;
                BlockBarrel.updateBarrel((TileEntityBarrel)worldIn.func_175625_s(pos));
            }
        } else {
            TileEntity t1 = worldIn.func_175625_s(pos);
            if (t1 == null) {
                return;
            }
            if (!(t1 instanceof TileEntityBarrel)) {
                return;
            }
            TileEntityBarrel t = (TileEntityBarrel)t1;
            if (t != null) {
                t.init(true, true, 4096);
                t.itemHandler.size = 4096;
                BlockBarrel.updateBarrel((TileEntityBarrel)worldIn.func_175625_s(pos));
            }
        }
    }

    public void func_176208_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player) {
        if (!worldIn.field_72995_K) {
            Random rand = new Random();
            TileEntityBarrel te = (TileEntityBarrel)worldIn.func_175625_s(pos);
            if (te != null) {
                ItemStack stack = new ItemStack(this.func_180660_a(state, rand, 1), 1);
                if (!stack.func_77942_o()) {
                    stack.func_77982_d(new NBTTagCompound());
                }
                stack.func_77978_p().func_74768_a("size", te.itemHandler.size);
                stack.func_77978_p().func_74757_a("comp", te.comp.booleanValue());
                stack.func_77978_p().func_74757_a("frame", te.frame.booleanValue());
                float f = rand.nextFloat() * 0.8f + 0.1f;
                float f1 = rand.nextFloat() * 0.8f + 0.1f;
                float f2 = rand.nextFloat() * 0.8f + 0.1f;
                EntityItem item = new EntityItem(worldIn, (double)((float)pos.func_177958_n() + f), (double)((float)pos.func_177956_o() + f1), (double)((float)pos.func_177952_p() + f2), stack);
                float f3 = 0.05f;
                item.field_70159_w = (float)rand.nextGaussian() * f3;
                item.field_70181_x = (float)rand.nextGaussian() * f3 + 0.2f;
                item.field_70179_y = (float)rand.nextGaussian() * f3;
                worldIn.func_72838_d((Entity)item);
            }
        }
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityBarrel();
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing = EnumFacing.func_82600_a((int)meta);
        if (enumfacing.func_176740_k() == EnumFacing.Axis.Y) {
            enumfacing = EnumFacing.NORTH;
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public static void updateBarrel(TileEntityBarrel t) {
        NBTTagCompound compound = new NBTTagCompound();
        t.func_189515_b(compound);
        t.func_70296_d();
        t.func_145831_w().func_184138_a(t.func_174877_v(), t.func_145831_w().func_180495_p(t.func_174877_v()), t.func_145831_w().func_180495_p(t.func_174877_v()), 3);
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        super.func_180663_b(world, pos, state);
    }

    public ArrayList<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        TileEntity t = world.func_175625_s(pos);
        if (t instanceof TileEntityBarrel) {
            TileEntityBarrel tile = (TileEntityBarrel)t;
            if (tile.itemHandler != null) {
                while (tile.itemHandler.extractItem(0, 1, true) != null) {
                    items.add(tile.itemHandler.extractItem(0, 64, false));
                }
            }
        }
        return items;
    }

    public void dumpBarrel(TileEntityBarrel t) {
        if (t instanceof TileEntityBarrel) {
            System.out.println("Barrel Dump");
            System.out.println("Size :" + t.itemHandler.size);
            System.out.println("Count :" + t.itemHandler.count);
            if (t.comp.booleanValue()) {
                System.out.println("Comparator : true");
            } else {
                System.out.println("Comparator : false");
            }
            if (t.frame.booleanValue()) {
                System.out.println("Frame : true");
            } else {
                System.out.println("Frame : false");
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, @Nullable ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        int incResult;
        if (worldIn.field_72995_K) return true;
        TileEntity te = worldIn.func_175625_s(pos);
        if (!(te instanceof TileEntityBarrel)) return true;
        TileEntityBarrel te2 = (TileEntityBarrel)te;
        if (!(te2.itemHandler.extractItem(0, 1, true) instanceof ItemStack)) {
            if (heldItem == null) return true;
            NBTTagCompound n = heldItem.func_77978_p();
            ItemStack insertStack = new ItemStack(heldItem.func_77973_b(), heldItem.field_77994_a, heldItem.func_77960_j());
            insertStack.func_77982_d(n);
            te2.itemHandler.insertItem(0, insertStack, false);
            playerIn.field_71071_by.field_70462_a[playerIn.field_71071_by.field_70461_c].field_77994_a = 0;
            playerIn.field_71071_by.field_70459_e = true;
            BlockBarrel.updateBarrel(te2);
            return true;
        }
        if (heldItem == null) return true;
        if (!te2.itemHandler.extractItem(0, 1, true).func_77969_a(heldItem)) return true;
        NBTTagCompound t1 = te2.itemHandler.extractItem(0, 1, true).func_77978_p();
        Boolean match = false;
        if (heldItem.func_77978_p() != null && t1 != null && t1.equals((Object)heldItem.func_77978_p())) {
            match = true;
        }
        if (t1 == null) {
            // empty if block
        }
        if (t1 == null && heldItem.func_77978_p() == null) {
            match = true;
        } else if (t1.toString().equals(heldItem.func_77978_p().toString())) {
            match = true;
        }
        if (!match.booleanValue() || te2.itemHandler.count >= te2.itemHandler.size) return true;
        playerIn.field_71071_by.field_70462_a[playerIn.field_71071_by.field_70461_c].field_77994_a = incResult = te2.itemHandler.incItems(heldItem.field_77994_a);
        playerIn.field_71071_by.field_70459_e = true;
        BlockBarrel.updateBarrel(te2);
        return true;
    }
}

